/*  KRunning - CertificationEdit.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Okt 14 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CERTIFICATIONEDIT_H
#define CERTIFICATIONEDIT_H

// QT Stuff
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qcanvas.h>
#include <qlabel.h>
#include <qintdict.h>
#include <qwmatrix.h>
#include <qpaintdevicemetrics.h>

// KDE Stuff
#include <kdialogbase.h>
#include <klocale.h>
#include <kprinter.h>
#include <kfontcombo.h>

// Own Stuff
#include "Preferences.h"

class CertificationEditor : public QCanvasView {
        Q_OBJECT

    public:
        CertificationEditor(QCanvas *, QWidget* parent=0, const char* name=0, WFlags f=0);
        void clear();

    protected:
        void contentsMousePressEvent(QMouseEvent*);
        void contentsMouseMoveEvent(QMouseEvent*);

    signals:
        //  void status(const QString&);

    private:
        QCanvasItem* moving;
        QPoint moving_start;
};


class CertificationEdit : public QWidget {
        Q_OBJECT

    public:
        CertificationEdit(QCanvas *, QWidget* parent=0, const char* name=0, WFlags f=0);
        ~CertificationEdit();

    public slots:


    private slots:


        void clear();
        void init();
        void addText(const QString &text);
        /*
            void addSprite();
            void addCircle();
            void addHexagon();
            void addPolygon();
            void addSpline();
            
            void addLine();
            void addRectangle();
            void addMesh();
            void addLogo();
            void addButterfly();

            void enlarge();
            void shrink();
            void rotateClockwise();
            void rotateCounterClockwise();
            void zoomIn();
            void zoomOut();
            void mirror();
            void moveL();
            void moveR();
            void moveU();
            void moveD();

            void print();
          */
        //    void toggleDoubleBuffer();

    private:
        QCanvas* canvas;
        CertificationEditor *editor;

        QPopupMenu* options;
        //  int dbf_id;
};

class CertificationEditDialog : public KDialogBase
{
        Q_OBJECT
    public:
        CertificationEditDialog (QWidget *parent, const char *name);
        ~CertificationEditDialog();
    private:
        CertificationEdit * ceWidget;
    protected slots:
        /** is called, if the ok-button is clicked*/
        void ok();
};

#endif //CERTIFICATIONEDIT
