/*  KRunning - CreateTables.h
 *  Copyright (C) 2003 by Andreas Scherf
 *  Begin Mon Apr 14 2003 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CREATE_TABLES_H
#define CREATE_TABLES_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CreateTablesGUI.h"
#include <kpushbutton.h>
#include <qradiobutton.h>
#include <ksqueezedtextlabel.h>
#include <kaction.h>
#include <kcombobox.h>
#include <qbuttongroup.h>
#include <knuminput.h>
#include <kpassdlg.h>
#include <qtextedit.h>
#include <klineedit.h>
#include "DBConnection.h"
#include <kfiledialog.h>
/** CreateTables
@version 0.3
*/
class CreateTables  : public CreateTablesGUI {
        Q_OBJECT
    public:
        CreateTables (QWidget * parent = 0, const char *name = 0);
        virtual ~CreateTables();

    protected:
        QString getDriver () const;

        QString getLocation() const;
        /**
         * Returns the name
         */
        QString getName() const;
        /**
         * Returns the password.
         */
        QString getPasswd() const;
        /**
         * Returns the port
         */
        QString getPort() const;
        /**
         * Returns the username.
         */
        QString getUser() const;
    protected slots:
        void slotQuit();
        void slotOk();
        void slotChooseDatabaseFile();
        void slotSelectionChanged(int);
        void sqlDriverChanged(const QString &);
	protected:
		void checkRecentFiles();
    private:
        KURL url;
        QString m_sFilename;
        KConfig *m_pConfig;
        QStringList m_lRecentFiles;
        QString m_sDriverName;

};


#endif //CREATE_TABLES_H

