 /*  KRunning - DBConnection.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Sam Mai 11 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "DBConnection.h"
#include "SQLiteConnection.h"
#include "PostgreSQLConnection.h"

#include <iostream>   

using namespace std;


//--------------------------------

DBConnection::DBConnection() : m_bConnected(false)
{
#ifdef DEBUG
    cerr << "DBConnection called" << endl;  
#endif
}

DBConnection::~DBConnection()
{
}


bool DBConnection::testTables() 
{
    if (!m_bConnected) return FALSE;

    if (getTableCount()>=6)
	{
        return TRUE;
	}
    else
	{
        return FALSE;
	}
}



bool DBConnection::createEmptyTables() 
{
    if (m_bConnected) 
	{
        // Teams
		createInitialTable(new KRunningTeamObject());
		createInitialTable(new KRunningEventObject());
		createInitialTable(new KRunningTimeObject());
		createInitialTable(new KRunningRunnerObject());
		createInitialTable(new KRunningRunnerTimeObject());
		createInitialTable(new KRunningRaceObject());

      /*  if (m_eDBType==eSQLite) {
            char *zErrMsg=0;
            sqlite_exec(db, "create table teams (number INTEGER PRIMARY KEY, teamname text UNIQUE)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table events (number INTEGER PRIMARY KEY, eventname text,startnumberframes text,starttime_0 text,starttime_1 text,distance int,document int)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table times (number INTEGER PRIMARY KEY, time text,event int)", 0, 0, &zErrMsg);
            // Version 2.7.1 don't support foreign keys .. hope that it will bring it soon
            sqlite_exec(db, "create table runner (number INTEGER PRIMARY KEY, surname text,forename text,birthday int2,sex int2,event REFERENCES events(number) MATCH PARTIAL,team REFERENCES teams(number) MATCH PARTIAL,street text,city text,plz int, nation text,chipnum text, state int2,comment text,place_total int2,place_class int2, place_sex int2, place_team int2,place_nation int2)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table runnertimes (number INTEGER PRIMARY KEY,runner int references runner,event int references events,time int references times)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table documents (number INTEGER PRIMARY KEY, name text,size text)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table frames (number INTEGER PRIMARY KEY, textline text,picture text,yposition int,xposition int, align int,font text,direction int,layer int)", 0, 0, &zErrMsg);
            sqlite_exec(db, "create table documentframes (number INTEGER PRIMARY KEY, document int references documents,frame int references frames)", 0, 0, &zErrMsg);

            cerr << "Creating tables :" << zErrMsg << endl;
        } else {
            QSqlQuery query,statement;
            if (!query.exec ("select * from teams")) {
                statement.exec ("drop table teams");
                statement.exec ("create table teams (number SERIAL primary key,teamname text)");
                //            statement.exec ("create unique index team_num on team (number,teamname)");
                //            statement.exec ("create unique index verein_name on vereine (v_name)");
                statement.exec ("grant ALL on teams to public");
                statement.exec("grant ALL on  teams_number_seq to public");
            }

            // Running Events
            if (!query.exec ("select * from events")) {
                statement.exec ("drop table events");
                statement.exec ("create table events (number SERIAL primary key,eventname text,startnumberframes text,starttime_0 text, starttime_1 text,distance int,document int)");
                //  statement.exec ("create unique index event_num on events (number)");
                statement.exec ("grant ALL on events to public");
                statement.exec("grant ALL on  events_number_seq to public");
            }
            // Times
            if (!query.exec ("select * from times")) {
                statement.exec ("drop table times");

                statement.exec ("create table times (number SERIAL primary key,time text,event int references events)");
                // statement.exec ("create index time_num on times (number)");
                statement.exec ("grant ALL on times to public");
                statement.exec("grant ALL on  times_number_seq to public");

            }

            // Runner
            if (!query.exec ("select * from runner")) {
                statement.exec ("drop table runner");
                statement.exec ("create table runner (number int primary key, surname text,forename text,birthday int2,sex int2,event int references events,team int references teams,street text,city text,plz int, nation text,chipnum text, state int2,comment text,place_total int2,place_class int2, place_sex int2, place_team int2,place_nation int2)");
                //          statement.exec ("create unique index runner_num on runner (number)");
                statement.exec ("grant ALL on runner to public");
            }
            // Runnertimes
            if (!query.exec ("select * from runnertimes")) {
                statement.exec ("drop table runnertimes");
                statement.exec ("create table runnertimes (number SERIAL primary key,runner int references runner,event int references events,time int references times)");
                //      statement.exec ("create unique index runnertimes_num on runnertimes (number)");
                statement.exec ("grant ALL on runnertimes to public");
                statement.exec("grant ALL on  runnertimes_number_seq to public");
            }

            if (!query.exec ("select * from documents")) {
                statement.exec ("drop table documents");
                statement.exec ("create table documents (number SERIAL primary key,name text,size text)");
                statement.exec ("grant ALL on documents to public");
                statement.exec("grant ALL on  documents_number_seq to public");
            }
            if (!query.exec ("select * from frames")) {
                statement.exec("drop table frames");
                statement.exec("create table frames (number SERIAL primary key,textline text,picture text,yposition int,xposition int, align int,font text,direction int,layer int)");
                statement.exec("grant ALL on frames to public");
                statement.exec("grant ALL on frames_number_seq to public");
            }

            if (!query.exec("select * from  documentframes")) {
                statement.exec ("drop table documentframes");
                statement.exec("create table documentframes (number SERIAL primary key,document int references documents,frame int references frames)");
                statement.exec("grant ALL on documentframes to public");
                statement.exec("grant ALL on documentframes_number_seq to public");
            }

            // Statistic
            if (!query.exec ("select * from statistics")) {
                statement.exec ("drop view statistics");
                statement.exec ("create view statistics as select COUNT(*) from runner");
                cerr <<                statement.lastError().databaseText()<<endl;
                statement.exec ("grant ALL on statistics to public");
            }
        }
*/
    }// if m_bConnected
    return TRUE;
}


/**
@param if name ist true it resturns the surnames otherwise the forenames
@returns a String list with all names (for the completion mode)
*/
QStringList DBConnection::getNameList(bool type) 
{
    QStringList slResult;

	KRunningRunnerObject* pRunner=new KRunningRunnerObject;
	KRunningResultSet *pResult=new KRunningResultSet();
	if (type)
	{
		pRunner->addSelectIndex( "surname",true);
	}
	else
	{
		pRunner->addSelectIndex( "forename",true);
	}
	if (query(pRunner,pResult)> 0)
	{
		for (long n=0;n<pResult->getRows();n++)
		{
			if (type)
			{		
				slResult.append(pResult->getValue( n,"surname" ).toString());
			}
			else
			{
				slResult.append(pResult->getValue(n,"forename").toString());
			}
		}
	}
	delete pResult;
	delete pRunner;

    /*QString name=QString();
    if (m_bConnected) {
        if (type) {
            name=QString("surname");
        } else {
            name=QString("forename");
        }
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select distinct %q from runner",&res,&nRow,&nColumns,NULL,name.latin1());
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result.append(QString(res[i]));
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlQuery query(QString("select distinct %1 from runner").arg(name));
            while (query.next()) {
                result.append(query.value(0).toString());
            }//while
        } //else
    } //m_bConnected*/
    return slResult;
}

QStringList DBConnection::getStartNumberFrames() 
{
	QStringList result;
	EventList events=getEventList();
	EventList::Iterator it;
    for (it=events.begin();it!=events.end();++it) 
	{
		result.append((*it).getStartnumberFrames() );
	}
    return result;
}

QString DBConnection::getTeamNameByNumber (int number) {
    QString sResult;
	KRunningTeamObject* pTeam=new KRunningTeamObject;
	KRunningResultSet *pResult=new KRunningResultSet();
	pTeam->addWhereIndex( "number",number);
	if (query(pTeam,pResult)> 0)
	{
		sResult=pResult->getValue( 0,"teamname" ).toString();
	}
	delete pResult;
	delete pTeam;
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select teamname from teams where number = %d",&res,&nRow,&nColumns,NULL,number);

            if (nRow > 0) {

                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result.append(QString(res[i]));
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlQuery query(QString("select teamname from teams where number = '%1'").arg(number));
            if (query.next()) {
                result.append(query.value(0).toString());
            }else { // Now Rows returned.
                result.append(""); // maybe no team could be returned ??
            }
        }
    }*/
    return sResult;
}

QString DBConnection::getEventNameByNumber (int number) 
{
    return getEventByNumber(number)->getName();
}

KRunningEventObject *DBConnection::getEventByNumber (int number) {
    KRunningEventObject *pEvent=new KRunningEventObject();
	pEvent->addWhereIndex( "number",number);

	KRunningEventObject *pResult = getEvent(pEvent);
	delete pEvent;
    return pResult;
}
KRunningEventObject* DBConnection::getEvent(KRunningEventObject *pEvent)
{
	KRunningEventObject* pEventResult=new KRunningEventObject;
	KRunningResultSet *pResult=new KRunningResultSet();

	if (query(pEvent,pResult)> 0)
	{
		pEventResult->setName(pResult->getValue( 0,"eventname" ).toString());
		pEventResult->setNumber(pResult->getValue(0,"number").toLongLong());
		pEventResult->setDistance(pResult->getValue(0,"distance").toLongLong());
		pEventResult->setStartTime(pResult->getValue(0,"starttime_0").toTime());
		pEventResult->setStartNumberFrame(pResult->getValue(0,"startnumberframes").toString());
	}
	delete pResult;
	return pEventResult;
}

KRunningEventObject* DBConnection::getEventByName (const QString & name) {
    
	
	KRunningEventObject *pEvent=new KRunningEventObject();
	pEvent->addWhereIndex( "eventname",name);
	
	KRunningEventObject *pResult=getEvent(pEvent);
	delete pEvent;
    return pResult;
}

/** This funktion searches the event from a startnumber but there must be frames to get the event !!
@return KRunningEventObject
*/

KRunningEventObject *DBConnection::getEventByStartnumber(long long nNumber) 
{
    QStringList frames= getStartNumberFrames();
    int eventnumber=-1;
    for ( QStringList::Iterator it = frames.begin(); it != frames.end(); ++it ) {
        QString outerframe (*it);
        eventnumber= outerframe.section(',',0,0).toInt();
        QString inner=outerframe.section(',',1,1); // The inner frames
        QStringList framelist = QStringList::split( ';',inner );
        for ( QStringList::Iterator it = framelist.begin(); it != framelist.end(); ++it ) {
            QString frame (*it);
            if (frame.section('-',0,0).toInt()<=nNumber && frame.section('-',1,1).toInt()>=nNumber) {
                return getEventByNumber(eventnumber);
            }
        }
    }
    return NULL;
}

/** This functions tests if a block is used in another event.
@return eventnumber in which the block was found.
*/
int DBConnection::testStartNumberFrame(QString & frame) {
    int result=-1; // this value say ok if the frame is ok.
    int upper,lower;
    lower=frame.section('-',0,0).toInt();
    upper=frame.section('-',1,1).toInt();
    EventList events=getEventList();
    EventList::Iterator it;
    for (it=events.begin();it!=events.end();++it) {
        QStringList framelist = QStringList::split( ';',(*it).getStartnumberFrames() );
        for ( QStringList::Iterator sit = framelist.begin(); sit != framelist.end(); ++sit ) {
            QString frame (*sit);
            for (int number=lower;number<=upper;number++) {
                for (int test=frame.section('-',0,0).toInt();test<=frame.section('-',1,1).toInt();test++) {
                    if (test==number)  return (*it).getNumber();
                }
            }
        }
    }
    return result;
}



/**
lists all runners from the given event number
  @return RunnerList
*/

DBConnection::RunnerList DBConnection::getRunnerListByEvent (int event,bool bJoin) 
{
    RunnerList lResult;
 
	KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	KRunningTeamObject *pTeam = new KRunningTeamObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pRunner->addWhereIndex("event",event);
	if (bJoin)
	{
		pRunner->setTableReference(pTeam);
	}
	if (query(pRunner,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningRunnerObject oRunnerObject;
			oRunnerObject.setEvent( pResult->getValue( n,"event").toLongLong());
			oRunnerObject.setNumber( pResult->getValue( n,"number").toLongLong());
			oRunnerObject.setSurname(( pResult->getValue( n,"surname").toString()));
			oRunnerObject.setForename(( pResult->getValue( n,"forename").toString()));
			oRunnerObject.setBirthday( pResult->getValue( n,"birthday").toLongLong());
			if (bJoin)
			{
				oRunnerObject.setTeamname(pResult->getValue(n,"teamname").toString());
			}
			else
			{
				oRunnerObject.setTeam(pResult->getValue(n,"team").toLongLong());
			}
			oRunnerObject.setSex( (KRunningRunnerObject::SexNum)pResult->getValue( n,"sex").toInt());
			oRunnerObject.setStreet( pResult->getValue( n,"street").toString());
			oRunnerObject.setCity( pResult->getValue( n,"city").toString());
			oRunnerObject.setPLZ( pResult->getValue( n,"plz").toInt());
			oRunnerObject.setTotalPlace( pResult->getValue( n,"place_total").toLongLong());
			oRunnerObject.setClassPlace(pResult->getValue( n,"place_class").toLongLong());	
			oRunnerObject.setSexPlace(pResult->getValue( n,"place_sex").toLongLong());
			oRunnerObject.setTeamPlace(pResult->getValue( n,"place_team").toLongLong());
			oRunnerObject.setNationPlace(pResult->getValue( n,"place_nation").toLongLong());
			oRunnerObject.setState((KRunningRunnerObject::StateNum)pResult->getValue(n,"state").toInt());
			lResult.append(oRunnerObject);
		}
		
	}
	delete pTeam;
	delete pRunner;
	delete pResult;
    /*  ("select runner.number,name,vorname,vereine.v_name,geb_jahr, runner.sex,%s "
    	   " place_total ,place_class ,place_sex,place_team,place_nation " "from runner, vereine %s" "where runner.verein = vereine.number " "%s %s %s", show_select_string, show_from_string, show_time_string, run_number_state, sorting_string);
      */
  /*  if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            char *zErrMsg=0;
            if (join == false ) {
                sqlite_get_table_printf(db,"select number,surname,forename,birthday,sex,event,team,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation from runner where event = %d",&res,&nRow,&nColumns,&zErrMsg,event);

                if (nRow > 0) {

                    for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                        result.append( KRunningRunnerObject(QString(res[i]).toInt(),QString(res[i+1]),QString(res[i+2]),
                                                 QString(res[i+3]).toInt(),((KRunningRunnerObject::SexNum)QString(res[i+4]).toInt()),QString(res[i+5]).toInt(),QString(res[i+6]).toInt(),
                                                 QString(res[i+7]),QString(res[i+8]),QString(res[i+9]).toInt(),
                                                 QString(res[i+10]),QString(res[i+11]),((KRunningRunnerObject::StateNum)QString(res[i+12]).toInt()),QString(res[i+13]),
                                                 QString(res[i+14]).toInt(),QString(res[i+15]).toInt(),QString(res[i+16]).toInt(),QString(res[i+17]).toInt(),QString(res[i+18]).toInt()));
                    }
                    sqlite_free_table(res);
                }
            } else {
                sqlite_get_table_printf(db,"select runner.number,surname,forename,birthday,sex,teams.teamname,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation FROM runner JOIN teams ON ( runner.team = teams.number ) WHERE runner.event =  %d",&res,&nRow,&nColumns,&zErrMsg,event);
                if (nRow > 0) {
                    for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                        result.append( KRunningRunnerObject(QString(res[i]).toInt(),QString(res[i+1]),QString(res[i+2]),
                                                 QString(res[i+3]).toInt(),((KRunningRunnerObject::SexNum)QString(res[i+4]).toInt()),event,QString(res[i+5]),QString(res[i+6]),
                                                 QString(res[i+7]),QString(res[i+8]).toInt(),
                                                 QString(res[i+9]),QString(res[i+10]),((KRunningRunnerObject::StateNum)QString(res[i+11]).toInt()),QString(res[i+12]),
                                                 QString(res[i+13]).toInt(),QString(res[i+14]).toInt(),QString(res[i+15]).toInt(),QString(res[i+16]).toInt(),QString(res[i+17]).toInt()));
                    }
                    sqlite_free_table(res);
                }
            }
            //cerr << "Error :"<< zErrMsg << endl;// JOIN
        } else {  // eSQLite

            if (join == false) {
                QSqlCursor cursor( "runner" );
                filter = QString( "event = '%1' " ).arg( event );
                cursor.select(filter);
                while (cursor.next()) {
                    result.append(KRunningRunnerObject(cursor.value( "number" ).toInt(),cursor.value( "surname" ).toString(), cursor.value( "forename" ).toString(),
                                            cursor.value( "birthday" ).toInt(),((KRunningRunnerObject::SexNum)cursor.value( "sex" ).toInt()), cursor.value( "event" ).toInt(),cursor.value( "team" ).toInt(),
                                            cursor.value( "street" ).toString(),cursor.value( "city" ).toString(),cursor.value( "plz" ).toInt(),
                                            cursor.value( "nation" ).toString(),cursor.value( "chipnum" ).toString(),((KRunningRunnerObject::StateNum)cursor.value( "state" ).toInt()),cursor.value("comment").toString(),
                                            cursor.value("place_total").toInt(),cursor.value("place_class").toInt(),cursor.value("place_sex").toInt(),cursor.value("place_team").toInt(),cursor.value("place_nation").toInt()   ));
                }  // while
            } else { // if join
                querystring = QString( "select runner.number,surname,forename,birthday,sex,teams.teamname,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation from runner,teams where runner.team = teams.number and runner.event = '%1'  " ).arg( event);
                QSqlQuery query(querystring);
                while(query.next()) {
                    result.append(KRunningRunnerObject(query.value(0).toInt(),query.value(1).toString(),query.value(2).toString(),
                                            query.value(3).toInt(),((KRunningRunnerObject::SexNum)query.value(4).toInt()),event,query.value(5).toString(),
                                            query.value(6).toString(),query.value(7).toString(),query.value(8).toInt(),
                                            query.value(9).toString(),query.value(10).toString(),((KRunningRunnerObject::StateNum)query.value(11).toInt()),query.value(12).toString(),
                                            query.value(13).toInt(),query.value(14).toInt(),query.value(15).toInt(),query.value(16).toInt(),query.value(17).toInt()   ));
                }// while
            } // else
        } // eSQLite
    }  // m_bConnected*/
    return lResult;
}
/** Returns all Runners from event X with sex y. ;-)
@return RunnerList
	-- TODO deprecated use the other function and overload it ...
*/
DBConnection::RunnerList DBConnection::getRunnerListByEventAndSex(int event,KRunningRunnerObject::SexNum sex) {
    RunnerList result;

	KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pRunner->addWhereIndex( "event",event);
	pRunner->addWhereIndex( "sex",sex);
	if (query(pRunner,pResult)> 0)
	{
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningRunnerObject oRunnerObject;
		
			oRunnerObject.setEvent( pResult->getValue( n,"event").toLongLong());
			oRunnerObject.setNumber( pResult->getValue( n,"number").toLongLong());
			oRunnerObject.setSurname(( pResult->getValue( n,"surname").toString()));
			oRunnerObject.setForename(( pResult->getValue( n,"forename").toString()));
			oRunnerObject.setBirthday( pResult->getValue( n,"birthday").toLongLong());
			oRunnerObject.setSex( (KRunningRunnerObject::SexNum)pResult->getValue( n,"sex").toInt());
			oRunnerObject.setStreet( pResult->getValue( n,"street").toString());
			oRunnerObject.setCity( pResult->getValue( n,"city").toString());
			oRunnerObject.setPLZ( pResult->getValue( n,"plz").toInt());
			oRunnerObject.setTotalPlace( pResult->getValue( n,"place_total").toLongLong());
        	oRunnerObject.setClassPlace(pResult->getValue( n,"place_class").toLongLong());
        	oRunnerObject.setSexPlace(pResult->getValue( n,"place_sex").toLongLong());
        	oRunnerObject.setTeamPlace(pResult->getValue( n,"place_team").toLongLong());
        	oRunnerObject.setNationPlace(pResult->getValue( n,"place_nation").toLongLong());
			result.append(oRunnerObject);
		}
	}
	delete pRunner;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            char *zErrMsg=0;

            sqlite_get_table_printf(db,"select number,surname,forename,birthday,event,team,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation from runner where event = %d AND sex = %d",&res,&nRow,&nColumns,&zErrMsg,event,sex);

            if (nRow > 0) {

                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result.append( KRunningRunnerObject(QString(res[i]).toInt(),QString(res[i+1]),QString(res[i+2]),
                                             QString(res[i+3]).toInt(),sex,QString(res[i+4]).toInt(),QString(res[i+5]).toInt(),
                                             QString(res[i+6]),QString(res[i+7]),QString(res[i+8]).toInt(),
                                             QString(res[i+9]),QString(res[i+10]),((KRunningRunnerObject::StateNum)QString(res[i+11]).toInt()),QString(res[i+12]),
                                             QString(res[i+13]).toInt(),QString(res[i+14]).toInt(),QString(res[i+15]).toInt(),QString(res[i+16]).toInt(),QString(res[i+17]).toInt()));
                }
                sqlite_free_table(res);
            }
        } else {// eSQLite
            querystring = QString( "select number,surname,forename,birthday,team,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation from runner where event = '%1' AND sex = '%2' " ).arg( event).arg(sex);
            QSqlQuery query(querystring);
            while(query.next()) {
                result.append(KRunningRunnerObject(query.value(0).toInt(),query.value(1).toString(),query.value(2).toString(),
                                        query.value(3).toInt(),sex,event,query.value(4).toInt(),
                                        query.value(5).toString(),query.value(6).toString(),query.value(7).toInt(),
                                        query.value(8).toString(),query.value(9).toString(),((KRunningRunnerObject::StateNum)query.value(10).toInt()),query.value(11).toString(),
                                        query.value(12).toInt(),query.value(13).toInt(),query.value(14).toInt(),query.value(15).toInt(),query.value(16).toInt()   ));
            }// while
        } // else
    } // connect*/
    return result;
}
/**
@return RunnerTimeList from the event
@param (int event,bool join)
*/
DBConnection::RunnerTimeList DBConnection::getRunnerTimeListByEvent (int event) {
    RunnerTimeList lresult;

	KRunningRunnerTimeObject *pRunnerTime=new KRunningRunnerTimeObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pRunnerTime->addWhereIndex( "event",event);
	if (query(pRunnerTime,pResult)> 0)
	{
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningRunnerTimeObject oResult;
			oResult.setNumber( pResult->getValue(n,"number").toLongLong());
			oResult.setRunnerRef(pResult->getValue(n,"runner").toLongLong());
			oResult.setEventRef(pResult->getValue(n,"event").toLongLong());
			oResult.setTimeRef(pResult->getValue(n,"time").toLongLong());

			lresult.append(oResult);
		}
	}
	delete pRunnerTime;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select number,runner,time from runnertimes where event = %d",&res,&nRow,&nColumns,NULL,event);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result.append(runnerKRunningTimeObject(QString(res[i]).toInt(),event,QString(res[i+1]).toInt(),QString(res[i+2]).toInt()));
                }
                sqlite_free_table(res);
            }
        } else {
            if (join==false) {
                QSqlCursor cursor("runnertimes");
                filter = QString("event = '%1'").arg(event);
                cursor.select(filter);
                while (cursor.next()) {
                    result.append( runnerKRunningTimeObject(cursor.value("number").toInt(),cursor.value("event").toInt(),cursor.value("runner").toInt(),cursor.value("time").toInt()));
                } // while
            } else { //if join
                querystring = QString("select * from runnertimes");
                QSqlQuery query(querystring);
                while (query.next()) {
                    result.append(runnerKRunningTimeObject());
                } // while
            } // else
        } // eSQLite
    }  // m_bConnected*/
    return lresult;
}

/**
 list all times from the given event number
@return TimeList
*/
DBConnection::TimeList DBConnection::getTimeListByEvent(int event) {
    QString filter;
    TimeList lResult;
    
	KRunningTimeObject *pTime=new KRunningTimeObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pTime->addWhereIndex("event",event);
	if (query(pTime,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningTimeObject oTimeObject;
			oTimeObject.setEvent( pResult->getValue( n,"event").toLongLong());
			oTimeObject.setNumber( pResult->getValue( n,"number").toLongLong());
			oTimeObject.setTime(( pResult->getValue( n,"time").toTime()));
			lResult.append(oTimeObject);
		}
		
	}
	delete pTime;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select number,time from times where event = %d",&res,&nRow,&nColumns,NULL,event);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result.append(KRunningTimeObject(QString(res[i]).toInt(),event,QTime::fromString(QString(res[i+1]))));
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlCursor cursor("times");
            filter = QString("event = '%1'").arg(event);
            cursor.select(filter);
            while (cursor.next()) {
                result.append(KRunningTimeObject(cursor.value("number").toInt(),event,QTime::fromString(cursor.value("time").toString())));
            } // while
        } // eSQLite
    }  // if*/

    return lResult;
}
/** checks if the runnernumber is ok and the runner is stored with the given eventnumber
@param  (int runner,int event)
@return bool
*/
bool DBConnection::checkIfRunnerInEvent (int runner,int event) {
    QString filter;
    bool bResult=FALSE;
	KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pRunner->addWhereIndex("event",event);
	pRunner->addWhereIndex( "number",runner);
	if (query(pRunner,pResult)> 0)
	{	
		bResult = TRUE;
	}
	delete pRunner;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select * from runner where number = %d AND event = %d",&res,&nRow,&nColumns,NULL,runner,event);
            if (nRow > 0) {
                result=TRUE;
                sqlite_free_table(res);
            }
        } else {
            QSqlCursor cursor("runner");
            filter = QString ("number = '%1' AND event = '%2'").arg(runner).arg(event);
            cursor.select(filter);
            if (cursor.next())
                result = TRUE;
            else
                result = FALSE;
        }
    }*/
    return bResult;
}

/**  checks if the runner already has a time in this event
@param (int runner,int event)
@return bool
*/
bool DBConnection::checkIfRunnerHasTime(int runner,int event) {
    bool bResult=false;

	KRunningRunnerTimeObject *pRunnerTime=new KRunningRunnerTimeObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	pRunnerTime->addWhereIndex("runner",runner);
	pRunnerTime->addWhereIndex( "event",event);
	if (query(pRunnerTime,pResult)> 0)
	{
		bResult = true;
	}
	delete pRunnerTime;
	delete pResult;
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select * from runnertimes where runner = %d AND event = %d",&res,&nRow,&nColumns,NULL,runner,event);
            if (nRow > 0) {
                result=TRUE;
                sqlite_free_table(res);
            }
        } else {

            QSqlCursor cursor("runnertimes");
            filter = QString("runner = '%1' AND event = '%2'").arg(runner).arg(event);
            cursor.select(filter);
            if (cursor.next())
                result = TRUE;
            else
                result=FALSE;
        }
    }*/
    return bResult;
}

/**
 getRunnerByNumber
 @return KRunningRunnerObject
*/
KRunningRunnerObject DBConnection::getRunnerByNumber (int number) {
    KRunningRunnerObject result;
	KRunningResultSet *pResult=new KRunningResultSet();
	KRunningRunnerObject *pRunner=new KRunningRunnerObject();
	pRunner->addWhereIndex( "number",number );
	if (query(pRunner,pResult)> 0)
	{
		result.setNumber( pResult->getValue( 0,"number").toLongLong());
		result.setSurname( pResult->getValue( 0,"surname").toString());
		result.setForename( pResult->getValue( 0,"forename").toString());
		result.setBirthday( pResult->getValue( 0,"birthday").toLongLong());
		result.setSex( (KRunningRunnerObject::SexNum)pResult->getValue( 0,"sex").toInt());
		result.setEvent( pResult->getValue( 0,"event").toLongLong());
		result.setTeam( pResult->getValue( 0,"team").toLongLong());
		result.setStreet( pResult->getValue( 0,"street").toString());
		result.setCity( pResult->getValue( 0,"city").toString());
		result.setPLZ( pResult->getValue( 0,"plz").toInt());
		result.setNation( pResult->getValue( 0,"nation").toString());
		result.setComment( pResult->getValue( 0,"comment").toString());
	}
	delete pRunner;
	delete pResult;

 /*   if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;

            sqlite_get_table_printf(db,"select surname,forename,birthday,sex,event,team,street,city,plz,nation,chipnum,state,comment,place_total,place_class,place_sex,place_team,place_nation from runner where number = %d",&res,&nRow,&nColumns,NULL,number);

            if (nRow > 0) {

                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result= KRunningRunnerObject(number,QString(res[i]),QString(res[i+1]),
                                      QString(res[i+2]).toInt(),((KRunningRunnerObject::SexNum)QString(res[i+3]).toInt()),QString(res[i+4]).toInt(),QString(res[i+5]).toInt(),
                                      QString(res[i+6]),QString(res[i+7]),QString(res[i+8]).toInt(),
                                      QString(res[i+9]),QString(res[i+10]),((KRunningRunnerObject::StateNum)QString(res[i+11]).toInt()),QString(res[i+12]),
                                      QString(res[i+13]).toInt(),QString(res[i+14]).toInt(),QString(res[i+15]).toInt(),QString(res[i+16]).toInt(),QString(res[i+17]).toInt());
                }
                sqlite_free_table(res);
            }
        } else {

            QSqlCursor cursor( "runner" );
            QSqlIndex index = cursor.primaryIndex();
            cursor.setValue( "number", number );
            cursor.select(index,index);
            while ( cursor.next() ) {

                result=KRunningRunnerObject(cursor.value( "number" ).toInt(),cursor.value( "surname" ).toString(), cursor.value( "forename" ).toString(),
                                 cursor.value( "birthday" ).toInt(),((KRunningRunnerObject::SexNum)cursor.value( "sex" ).toInt()), cursor.value( "event" ).toInt(),cursor.value( "team" ).toInt(),
                                 cursor.value( "street" ).toString(),cursor.value( "city" ).toString(),cursor.value( "plz" ).toInt(),
                                 cursor.value( "nation" ).toString(),cursor.value( "chipnum" ).toString(),((KRunningRunnerObject::StateNum)cursor.value( "state" ).toInt()),cursor.value("comment").toString(),
                                 cursor.value("place_total").toInt(),cursor.value("place_class").toInt(),cursor.value("place_sex").toInt(),cursor.value("place_team").toInt(),cursor.value("place_nation").toInt()   ) ;
            }
        }
    }*/
    return result;
}

/**
getTimeByNumber
@return KRunningTimeObject
*/
KRunningTimeObject DBConnection::getTimeByNumber(int number) {
    KRunningTimeObject result=KRunningTimeObject();
	KRunningTimeObject *pTime=new KRunningTimeObject();
	pTime->addWhereIndex( "number",number );
	
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pTime,pResult)> 0)
	{
		result.setTime( pResult->getValue( 0,"time").toTime());
		result.setEvent( pResult->getValue( 0,"event").toLongLong());
		result.setNumber( pResult->getValue( 0,"number").toLongLong());
	}
	delete pTime;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;
            sqlite_get_table_printf(db,"select event,time from times where number = %d",&res,&nRow,&nColumns,NULL,number);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result= KRunningTimeObject(number,QString(res[i]).toInt(),QTime::fromString(QString(res[i+1])));
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlCursor cursor("times");
            QSqlIndex index = cursor.primaryIndex();
            cursor.setValue( "number", number );
            cursor.select(index,index);
            while ( cursor.next() ) {
                result=KRunningTimeObject(cursor.value("number").toInt(),cursor.value("event").toInt(),QTime::fromString(cursor.value("time").toString()));
            }
        }
    }*/
    return result;
}

QStringList DBConnection::getTeamNameList() {
  
	QStringList lResult;

	KRunningTeamObject *pEvent=new KRunningTeamObject();
	pEvent->addOrderIndex( "teamname");
	
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pEvent,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			lResult.append( pResult->getValue( n,"teamname").toString());
		}
		
	}
	delete pEvent;
	delete pResult;
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **result;
            int nRow,nColumns;
            sqlite_get_table(db,"select teamname from teams",&result,&nRow,&nColumns,NULL);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    teamList.append(QString(result[i]));
                }
                sqlite_free_table(result);
            }
        } else {

            QSqlQuery query( "select teamname from teams" );
            while ( query.next() ) {
                teamList.append( query.value(0).toString());
            }
        }
        teamList.sort();
    }*/
    return lResult;
}
QStringList DBConnection::getDriverList() 
{
    return QSqlDatabase::drivers();
}

DBConnection::EventList DBConnection::getEventList() {
    EventList lResult;
	KRunningEventObject *pEvent=new KRunningEventObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pEvent,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningEventObject oEventObject;
			oEventObject.setName( pResult->getValue( n,"eventname").toString());
			oEventObject.setNumber( pResult->getValue( n,"number").toLongLong());
			oEventObject.setDistance( pResult->getValue( n,"distance").toInt());
			oEventObject.setStartTime( pResult->getValue( n,"starttime_0").toTime());
			lResult.append(oEventObject);
		}
		
	}
	delete pEvent;
	delete pResult;
	return lResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **result;
            int nRow,nColumns;

            sqlite_get_table(db,"select * from events",&result,&nRow,&nColumns,NULL);

            if (nRow > 0) {

                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {

                    list.append(KRunningEventObject( QString(result[i]).toInt(),QString(result[i+1]),QString(result[i+2]),QTime::fromString(QString(result[i+3])),QString(result[i+5]).toInt()));
                }
                sqlite_free_table(result);
            }
        } else {
            QSqlCursor cursor( "events" );
            cursor.select();
            while ( cursor.next() ) {
                //number int2,event_name text,min_number int2,max_number int2,starttime_0 int4, starttime_1 int4,distance int2)");
                list.append(KRunningEventObject(cursor.value( "number" ).toInt(),cursor.value( "eventname" ).toString(), cursor.value( "startnumberframes" ).toString(),
                                     QTime::fromString(cursor.value( "starttime_0" ).toString()), cursor.value( "distance" ).toInt())) ;
            }
        }
    }*/
    
}

DBConnection::TeamList DBConnection::getTeamList() {
    TeamList lResult;
	KRunningTeamObject *pTeam=new KRunningTeamObject();
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pTeam,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			KRunningTeamObject oTeamObject;
			oTeamObject.setNumber( pResult->getValue( n,"number").toLongLong());
			oTeamObject.setName( pResult->getValue( n,"teamname").toString());
			lResult.append(oTeamObject);
		}
		
	}
	delete pTeam;
	delete pResult;
  /*  if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **result;
            int nRow,nColumns;

            sqlite_get_table(db,"select * from teams",&result,&nRow,&nColumns,NULL);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    list.append(KRunningTeamObject( QString(result[i]).toInt(),QString(result[i+1])));
                }
                sqlite_free_table(result);
            }
        } else {
            QSqlCursor cursor("teams");
            cursor.select();
            while (cursor.next() ) {
                list.append(KRunningTeamObject(cursor.value("number").toInt(),cursor.value("teamname").toString()));
            }
        }

    }*/
    return lResult;
}

long long DBConnection::getTeamnumberByName (const QString &sTeam) 
{
    long long nResult=-1;

	KRunningTeamObject *pTeam=new KRunningTeamObject();
	pTeam->addWhereIndex( "teamname",sTeam);
	pTeam->addSelectIndex("number");
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pTeam,pResult)> 0)
	{	
		nResult=pResult->getValue( 0,"number").toLongLong();
	}
	delete pTeam;
	delete pResult;
 /*   if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;

            sqlite_get_table_printf(db,"select number from teams where teamname = '%q'",&res,&nRow,&nColumns,NULL,team.latin1());
            if (nRow > 0) {

                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result= QString(res[i]).toInt();
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlCursor cursor( "teams" );
            filter = QString( "teamname = '%1' " ).arg( team );

            //  QSqlIndex index = cursor.index("teamname");
            //    cursor.setValue( "teamname", team );
            cursor.select(filter);
            while ( cursor.next() ) {
                result=cursor.value( "number" ).toInt() ;
            }
        }
    }*/
    return nResult;
}

long long DBConnection::getEventnumberByName (const QString &sEvent) 
{
    long long nResult=-1;

	KRunningEventObject *pEvent=new KRunningEventObject();
	pEvent->addWhereIndex( "eventname",sEvent);
	pEvent->addSelectIndex("number");
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pEvent,pResult)> 0)
	{	
		nResult=pResult->getValue( 0,"number").toLongLong();
	}
	delete pEvent;
	delete pResult;
   /* if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **res;
            int nRow,nColumns;

            sqlite_get_table_printf(db,"select number from events where eventname = '%q'",&res,&nRow,&nColumns,NULL,event.latin1());
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    result= QString(res[i]).toInt();
                }
                sqlite_free_table(res);
            }
        } else {
            QSqlCursor cursor( "events" );
            filter = QString( "eventname = '%1' " ).arg( event );
            cursor.select(filter);
            while ( cursor.next() ) {
                result=cursor.value( "number" ).toInt() ;
            }
        }
    }*/
    return nResult;
}

/**  deletes a time given by the string and the event number string must be "hh:mm:ss.zzz"
@return TRUE if a time is deleted and FALSE if no time is deleted.
*/
bool DBConnection::deleteTimeByTimestring(const QString & sTime,int nEvent) 
{
	bool bReturn = false;
	KRunningTimeObject *pTime = new KRunningTimeObject;

	pTime->addWhereIndex( "time",sTime);
	pTime->addWhereIndex("event",nEvent);

	if (deleteValues(pTime))
	{	
		bReturn = true;
	}
	delete pTime;
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            sqlite_exec_printf(db, "DELETE FROM times WHERE time = '%q' AND event = %d",  0, 0, 0, time.latin1(),event);
            // number,NULL
            return TRUE;
            //
        } else {
            QSqlCursor cursor("times");
            filter = QString("event = '%1' AND time = '%2'").arg(event).arg(time);
            cursor.select(filter);
            if ( cursor.next() ) {
                cursor.primeDelete();
                if (  cursor.del() == 0 ) {
                    cerr << cursor.lastError().databaseText() << endl;
                    return false;
                }
            }
        } // if
    } // if m_bConnected*/
    return bReturn;
}
/**
@return TRUE if the team is deleted otherwise return FALSE
*/
bool DBConnection::deleteTeamByString(const QString & sTeam) 
{
	bool bReturn = false;
	KRunningTeamObject *pTeam = new KRunningTeamObject;

	pTeam->addWhereIndex( "teamname",sTeam);

	if (deleteValues(pTeam))
	{	
		bReturn = true;
	}
	delete pTeam;
    
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            sqlite_exec_printf(db, "DELETE FROM teams WHERE teamname = '%q'",  0, 0, &zErrMsg, team.latin1());
            // Dangerous operation no constraint here !!
            cerr << zErrMsg << endl;
            return TRUE;
            //
        } else {
            QSqlCursor cursor("teams");
            filter = QString("teamname = '%1'").arg(team);
            cursor.select(filter);
            if ( cursor.next() ) {
                cursor.primeDelete();
                if (  cursor.del() == 0 ) {
                    cerr << cursor.lastError().databaseText() << endl;
                    return false;
                }
            }
        } // if
    } // if m_bConnected*/
    return true;
}

QStringList DBConnection::getEventNameList() {
    QStringList lResult;

	KRunningEventObject *pEvent=new KRunningEventObject();
	//KRunningSqlIndex iFilter=pEvent->getIndex("eventname");
	pEvent->addOrderIndex("eventname");
	
	KRunningResultSet *pResult=new KRunningResultSet();
	if (query(pEvent,pResult)> 0)
	{	
		for (long n=0;n<pResult->getRows();n++)
		{
			lResult.append( pResult->getValue( n,"eventname").toString());
		}
		
	}
	delete pEvent;
	delete pResult;
    /*if (m_bConnected) {
        if (m_eDBType==eSQLite) {
            char **result;
            int nRow,nColumns;
            sqlite_get_table(db,"select eventname from events",&result,&nRow,&nColumns,NULL);
            if (nRow > 0) {
                for (int i=(nColumns);i<((nRow+1)*nColumns);i+=nColumns) {
                    eventList.append(QString(result[i]));
                }
                sqlite_free_table(result);
            }
        } else {
            QSqlQuery query("select eventname from events");
            while (query.next() ) {
                eventList.append (query.value(0).toString());
            }
        }
        eventList.sort();
    }*/
    return lResult;
}


QString DBConnection::getCountString(const QString &sTablename) 
{
	return getTableRows(sTablename);
}


KRunningUseCase::KRunningUseCase()
{
	m_pDBConnection=NULL;
	m_pCurrentEvent=NULL;
    m_pKRunningConfig = KGlobal::config();
}

KRunningUseCase::~KRunningUseCase()
{
}

void KRunningUseCase::setCurrentEvent(const QString &sName)
{
	if (m_pCurrentEvent)
	{
		if ( sName == m_pCurrentEvent->getName()) return;
		delete m_pCurrentEvent;
	}
	
	
	m_pCurrentEvent = m_pDBConnection->getEventByName(sName);
	
}

DBConnection *KRunningUseCase::getConnection()
{
	if (m_pDBConnection)
	{
		return m_pDBConnection;
	}
	else
	{
		m_pDBConnection = new SQLiteConnection(); // TODO: Change to safed DB Connection
		return m_pDBConnection;
	}
}

bool KRunningUseCase::isConnected()
{
	bool bReturn = false;
	if (m_pDBConnection)
	{
		bReturn = m_pDBConnection->isConnected();
	}
	return bReturn;
}

