/*  KRunning - Evaluation.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Fre Mai 24 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Evaluation.h"

#include <iostream>


using namespace std;

Evaluation::Evaluation (QWidget * parent, const char *name) : EvaluationGUI(parent,name,true) {
    connect (EvaluateButton,SIGNAL(pressed()),this,SLOT(evaluateAllRunners()));
    connect (EvaluateTeamButton,SIGNAL(pressed()),this,SLOT(slotShowTeamResults()));
    connect (EvaluateClassButton,SIGNAL(pressed()),this,SLOT(slotShowClassResults()));
}

Evaluation::~Evaluation() 
{
}


void Evaluation::setDefaultSettings() 
{
    EvalTextBrowser->setTextFormat( RichText );
    EvalTextBrowser->setText(i18n("Eventname")+QString(" : ")+g_pMainUseCase->getCurrentEvent()->getName());
    EvaluateButton->setEnabled(true);
    EvalProgressBar->reset();
}

void Evaluation::slotShowTeamResults() {
    EvalTextBrowser->clear();

    resultText=QString("");
    evaluateTeamResults(KRunningRunnerObject::eMale);
    resultText.append("<hr><br><br>");
    evaluateTeamResults(KRunningRunnerObject::eFemale);
    EvalTextBrowser->setText(resultText);
}

void Evaluation::slotShowClassResults() {
    EvalTextBrowser->clear();
    resultText=QString("");
    evaluateClassResults(KRunningRunnerObject::eMale);
    resultText.append("<hr><br><br>");
    evaluateClassResults(KRunningRunnerObject::eFemale);
    EvalTextBrowser->setText(resultText);
}

void Evaluation::save() {
    //TODO save resultText with HTML Header
}

void Evaluation::print(KPrinter *printer) {
    Printing *printing = new Printing(printer);
    printing->printEvaluationTextBrowser(EvalTextBrowser);
    delete (printing);
}

/**
 getClassString
 @author Andreas Scherf
 @version 0.3
 @return the class string as defined by DLV germany
 Added feature to work with SexNum Objects
*/
QString Evaluation::getClassString (int yearOfBirth,KRunningRunnerObject::SexNum num) {
    if (num==KRunningRunnerObject::eFemale) 
	{
        return getClassString(yearOfBirth,i18n("Female"));
    } 
	else 
	{
        return getClassString(yearOfBirth,i18n("Male"));
    }
}

QString Evaluation::getClassString (int yearOfBirth,const QString &sex) 
{
    QString classString,tmp;
    QDate dateValue(QDate::currentDate());
	int nTimespan;
   
    if (yearOfBirth < 1900 || yearOfBirth >= dateValue.year()) 
	{
#ifdef DEBUG
        cerr << "Wrong date !" << endl;
#endif
        return ("XXX");
    }
    if (sex == i18n("Male") || sex== i18n("Female") )
	{
        classString=sex.upper().at(0);
	}
    else
	{
        classString='X';
	}
    nTimespan=dateValue.year()-yearOfBirth;
    if (nTimespan < 20) {
        if (nTimespan < 8) {
            classString.append("08");
        } else if (nTimespan < 16) {
            tmp.sprintf("%02d",nTimespan);
            classString.append(tmp);
        }
        if (nTimespan == 16 || nTimespan == 17)
            classString.append ("JB");
        if (nTimespan == 18 || nTimespan == 19)
            classString.append ("JA");
    }
    if (nTimespan >= 20 && nTimespan < 30) {
        classString.append("HK");
    }
    if (nTimespan >= 30) {
        if (nTimespan % 10 < 5) {
            nTimespan = (nTimespan / 10) * 10;
            tmp.sprintf("%02d",nTimespan);
            classString.append( tmp);
        } else {
            nTimespan = (nTimespan / 10) * 10 + 5;
            tmp.sprintf("%02d",nTimespan);
            classString.append(tmp);
        }
    }
    return classString;
}

void Evaluation::evaluateAllRunners() {
    int placeTotal = 1;
    int placeSexMale = 1;
    int placeSexFemale =1;
    int progress=1;
    QString classstring;
    DBConnection::TimeList timelist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;

    Evaluation::TeamCountList teamcountlist;
    Evaluation::ClassCountList classcountlist;

    EvaluateButton->setEnabled(false);
    EvalProgressBar->setProgress(progress);
    // Get all List from the database ...
	long nEvent=g_pMainUseCase->getCurrentEvent()->getNumber();
    timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(nEvent);
    runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEvent(nEvent,false); // The Runnerlist
    runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(nEvent);

    // Get the Iterator
    DBConnection::TimeList::iterator ittimelist;
    DBConnection::RunnerList::iterator itrunnerlist;
    DBConnection::RunnerTimeList::iterator itrunnertimelist;

    // Sort the timelist
    qBubbleSort(timelist);
    //qHeapSort
    g_pMainUseCase->getConnection()->startTransaction();
    EvalProgressBar->setTotalSteps(timelist.count());
    for ( ittimelist = timelist.begin(); ittimelist != timelist.end(); ++ittimelist ) {
        for ( itrunnertimelist = runnertimelist.begin();itrunnertimelist != runnertimelist.end();++itrunnertimelist) {
            if ((*itrunnertimelist).getTimeRef()==(*ittimelist).getNumber()) {
                for (itrunnerlist = runnerlist.begin();itrunnerlist != runnerlist.end();++itrunnerlist) {
                    if ((*itrunnertimelist).getRunnerRef()==(*itrunnerlist).getNumber()) {
                        // TotalCount
                        (*itrunnerlist).setTotalPlace(placeTotal);
                        placeTotal++;
                        // SexCount
                        if ((*itrunnerlist).getSex()==KRunningRunnerObject::eMale) {
                            (*itrunnerlist).setSexPlace( placeSexMale);
                            placeSexMale++;
                        } else {
                            (*itrunnerlist).setSexPlace( placeSexFemale);
                            placeSexFemale++;
                        }
                        // ClassCount
                        classstring = getClassString((*itrunnerlist).getBirthday(),(*itrunnerlist).getSex());
                        if ((*classcountlist.find(KRunningClassCountObject( classstring,0))).getCount() < 1) {
                            classcountlist.append(KRunningClassCountObject( classstring,1));
                            (*itrunnerlist).setClassPlace( 1);
                        } else {
                            ++(*classcountlist.find(KRunningClassCountObject( classstring,0)));
                            (*itrunnerlist).setClassPlace( (*classcountlist.find(KRunningClassCountObject( classstring,0))).getCount()  );
                        }
                        classstring="";
                        // TeamCount
                        if ( (*teamcountlist.find(KRunningTeamCountObject((*itrunnerlist).getTeam(),0))).getCount() < 1) {
                            teamcountlist.append(KRunningTeamCountObject((*itrunnerlist).getTeam(),1));
                            (*itrunnerlist).setTeamPlace( 1);
                        } else {
                            ++(*teamcountlist.find(KRunningTeamCountObject((*itrunnerlist).getTeam(),0)));
                            (*itrunnerlist).setTeamPlace( (*teamcountlist.find(KRunningTeamCountObject((*itrunnerlist).getTeam(),0))).getCount());
                        }

                        // Set status and update ...
                        (*itrunnerlist).setState(KRunningRunnerObject::eEvaluated);
                        (*itrunnerlist).update();
                    }
                }
            }
        }
        EvalProgressBar->setProgress(progress++);
    }
    g_pMainUseCase->getConnection()->commitTransaction();
    EvalProgressBar->setProgress(timelist.count());
}

/** Calculates the right class result list.
@version 0.5
*/
void Evaluation::evaluateClassResults(KRunningRunnerObject::SexNum sex) {
    DBConnection::TimeList timelist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;
    DBConnection::TeamList teamlist;
    QStringList classlist;
    QStringList::iterator itclasslist;

    QString oldclass;
    int position = 0;
    int progress=1;
    EvalProgressBar->setProgress(0);
    //  teamlist=g_pMainUseCase->getTeamList();
    runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEventAndSex(g_pMainUseCase->getCurrentEvent()->getNumber(),sex); // The Runnerlist
    timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    teamlist=g_pMainUseCase->getConnection()->getTeamList();
    EvalProgressBar->setProgress(5);
    // Sort the runnerlist (Birthday)
    qBubbleSort(runnerlist);
    // Sort the timelist
    qBubbleSort(timelist);
    EvalProgressBar->setProgress(10);
    // Get the Iterators
    DBConnection::TimeList::iterator ittimelist;
    DBConnection::RunnerList::iterator itrunnerlist;
    DBConnection::RunnerTimeList::iterator itrunnertimelist;
    DBConnection::TeamList::iterator itteamlist;

    resultText.append("<table cellspacing=0 cellpadding=0>");
    EvalProgressBar->setTotalSteps(runnerlist.count()*2);
    // Get all classes here and put them into the classlist
    for (itrunnerlist = runnerlist.begin();itrunnerlist != runnerlist.end();++itrunnerlist) {   // sorted ->birthday
        for ( itrunnertimelist = runnertimelist.begin();itrunnertimelist != runnertimelist.end();++itrunnertimelist) {
            if ((*itrunnertimelist).getRunnerRef()==(*itrunnerlist).getNumber()) {
                if (getClassString((*itrunnerlist).getBirthday(),sex)!=oldclass) {
                    oldclass=getClassString((*itrunnerlist).getBirthday(),sex);
                    classlist.append(oldclass);
                }
                EvalProgressBar->setProgress(progress++);
            }
        }
    }
    // Now run along the classlist and get all runners to each class (fastest first)
    for (itclasslist = classlist.begin();itclasslist != classlist.end();++itclasslist) {
        resultText.append("<tr><td colspawn=4><b>"+(*itclasslist)+"</b></td></tr><br>");
        position=1;
        for (ittimelist = timelist.begin();ittimelist != timelist.end();++ittimelist) {
            for ( itrunnertimelist = runnertimelist.begin();itrunnertimelist != runnertimelist.end();++itrunnertimelist) {
                if ((*itrunnertimelist).getTimeRef()==(*ittimelist).getNumber()) {
                    for (itrunnerlist = runnerlist.begin();itrunnerlist != runnerlist.end();++itrunnerlist) {   // sorted ->birthday
                        if ((*itrunnertimelist).getRunnerRef()==(*itrunnerlist).getNumber()) {

                            if (getClassString((*itrunnerlist).getBirthday(),sex)==(*itclasslist)) {
								KRunningTeamObject oTeam;
								oTeam.setNumber( (*itrunnerlist).getTeam() );
                                itteamlist=teamlist.find(oTeam);
                                resultText.append("<tr>");
                                resultText.append(QString("<td>%1.</td>").arg(position).rightJustify(4,' ')+
                                                  QString("<td>%1 %2</td>").arg( (*itrunnerlist).getSurname()).arg((*itrunnerlist).getForename().leftJustify(25,' ',true))+
                                                  QString("<td>%1</td>").arg((*itteamlist).getName())+
                                                  QString("<td>%1</td>").arg((*ittimelist).getTimeString("hh:mm:ss")));;
                                resultText.append("</tr>");
                                position++;
                                EvalProgressBar->setProgress(progress++);
                            } // if
                        } // if
                    } // for
                } // if
            } // for
        }  // for
    }// for
    resultText.append("</table>");
}



/** Problem is if the TimeSum is greater than 24 hrs the wrong result is calculated.
@version 0.5
*/

void Evaluation::evaluateTeamResults(KRunningRunnerObject::SexNum sex) {
    //DBConnection::TeamList teamlist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;
    DBConnection::TimeList timelist;
    int place=1;
    int progress=1;
    int teamorder=2; // If one team has more than x runners we splitt them up
    Evaluation::TeamEvalList teamevallist;

    EvalProgressBar->setProgress(0);
    //  teamlist=g_pMainUseCase->getTeamList();
    runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEventAndSex(g_pMainUseCase->getCurrentEvent()->getNumber(),sex); // The Runnerlist
    timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());

    // Sort the timelist
    qBubbleSort(timelist);

    // Get the Iterators
    DBConnection::TimeList::iterator ittimelist;
    DBConnection::RunnerList::iterator itrunnerlist;
    DBConnection::RunnerTimeList::iterator itrunnertimelist;
    // DBConnection::TeamList::iterator itteamlist;
    Evaluation::TeamEvalList::iterator itteamevallist;

    EvalProgressBar->setTotalSteps(timelist.count());
    for ( ittimelist = timelist.begin(); ittimelist != timelist.end(); ++ittimelist ) {
        for ( itrunnertimelist = runnertimelist.begin();itrunnertimelist != runnertimelist.end();++itrunnertimelist) {
            if ((*itrunnertimelist).getTimeRef()==(*ittimelist).getNumber()) {
                for (itrunnerlist = runnerlist.begin();itrunnerlist != runnerlist.end();++itrunnerlist) {
                    if ((*itrunnertimelist).getRunnerRef()==(*itrunnerlist).getNumber() && (*itrunnerlist).getTeam() != prefs->getIgnoreTeam()) {

                        itteamevallist=teamevallist.begin(); // Start here

                        itteamevallist=teamevallist.find(itteamevallist,teamEvalObj((*itrunnerlist).getTeam(),-1)); // Find the first team entry here
                        if ( teamevallist.contains ( teamEvalObj((*itrunnerlist).getTeam(),-1) ) < 1) {
                            teamevallist.append(teamEvalObj((*itrunnerlist).getTeam(),1,(*itrunnerlist),(*ittimelist)));    // Neues Objekt fr den Verein X anlegen.

                        } else {
                            itteamevallist=findLast(teamevallist,teamEvalObj((*itrunnerlist).getTeam(),-1));
                            teamorder=(*itteamevallist).getTeamOrder();
                            if ((*itteamevallist).getCount()<prefs->getTeamSize()) {
                                (*itteamevallist).addRunner((*itrunnerlist),(*ittimelist));
                            } else {
                                teamorder++;
                                teamevallist.append(teamEvalObj((*itrunnerlist).getTeam(),teamorder,(*itrunnerlist),(*ittimelist)));
                            }
                        }
                        teamorder=2;
                    }
                }//for runnerlist
            } // if timenumber == runnertimelist number
        } // for runnertimelist
        EvalProgressBar->setProgress(progress++);
    }// for timelist

    qBubbleSort(teamevallist);

    resultText.append("<table cellspacing=0 cellpadding=0>");
    for (itteamevallist = teamevallist.begin();itteamevallist != teamevallist.end(); ++itteamevallist ) {
        if (  (*itteamevallist).getCount()==prefs->getTeamSize()) {
            resultText.append("<tr>");
            if ((*itteamevallist).getTeamOrder()>1) {
                resultText.append (QString("<td><b>%1.</b></td><td colspan=3><b>%2 (%3)</b></td><td><b>%4</b></td>").arg(place).arg(g_pMainUseCase->getConnection()->getTeamNameByNumber((*itteamevallist).getTeamNumber())).arg((*itteamevallist).getTeamOrder()).arg((*itteamevallist).getTimeSum().toString()));
            } else {
                resultText.append (QString("<td><b>%1.</b></td><td colspan=3><b>%2</b></td><td><b>%3</b></td>").arg(place).arg(g_pMainUseCase->getConnection()->getTeamNameByNumber((*itteamevallist).getTeamNumber())).arg((*itteamevallist).getTimeSum().toString()));
            }
            resultText.append("</tr>");

            runnerlist=(*itteamevallist).getRunnerList();
            itrunnerlist = runnerlist.begin();
            timelist=(*itteamevallist).getTimeList();
            ittimelist=timelist.begin();
            while (itrunnerlist != runnerlist.end()) {
                resultText.append("<tr>");
                resultText.append(QString("<td></td><td>%1</td><td>%2</td><td>%3</td><td>%4</td>>").arg((*itrunnerlist).getNumber()).arg( (*itrunnerlist).getSurname()).arg(  (*itrunnerlist).getForename()).arg((*ittimelist).getTimeString("hh:mm:ss")));
                itrunnerlist++;
                ittimelist++;
                resultText.append("</tr>");
            }
            place++;
            resultText.append("<tr><td colspan=4>&nbsp; </td></tr><br>");
        }
    }
    resultText.append("</table>");

}

/** Helper function for the Team Evaluation */
teamEvalObj::teamEvalObj(int num,int c,KRunningRunnerObject &runner,KRunningTimeObject &time) {
    teamnumber=num;
    if (c > 1) {
        count=1;
        teamorder=c;
    }   else {
        count=c;
        teamorder=1;
    }
    place=-1;
    runners.append(runner);
    times.append(time);
    timesum=QTime(time.getTime());
}

bool teamEvalObj::addRunner(KRunningRunnerObject &runner,KRunningTimeObject &time) {
    if (count < prefs->getTeamSize()) {
        //teamorder++;
        count++;
        runners.append(runner);
        times.append(time);
        timesum=timesum.addSecs(QTime().secsTo(time.getTime()));
    }
    return true;
}

QValueListIterator<teamEvalObj> Evaluation::findLast(TeamEvalList & list,const teamEvalObj & teo) {
    TeamEvalList::iterator result,it;
    for (it = list.begin();it !=list.end();++it) {
        if (teo.getTeamNumber()==(*it).getTeamNumber())
            result=it;
    }
    return result;
}
//---------------

/** == for find functions ...
*/
bool operator==(const KRunningClassCountObject& a,const KRunningClassCountObject& b) {
    if (a.getClassName()==b.getClassName()) return true;
    else return false;
}

bool operator==(const KRunningTeamCountObject& a,const KRunningTeamCountObject& b) {
    if (a.getTeamNumber()==b.getTeamNumber()) return true;
    else return false;
}

bool operator==(teamEvalObj a,teamEvalObj b) {
    if (a.getTeamNumber()==b.getTeamNumber()) return true;
    else return false;
}
// Class list to find the right team for each runner ...
bool operator==(const KRunningTeamObject& a,const KRunningTeamObject& b) {
    if (a.getNumber()==b.getNumber()) return true;
    else return false;
}
/** < for Sort functions ...
*/
bool operator<(teamEvalObj &a,teamEvalObj &b) {
    if (a.getTimeSum()<b.getTimeSum()) return true;
    else return false;
}

KRunningCountObject::KRunningCountObject() : m_nCount(0)
{
}
KRunningCountObject::~KRunningCountObject()
{
}

KRunningClassCountObject::KRunningClassCountObject() : KRunningCountObject()
{
}

KRunningClassCountObject::KRunningClassCountObject( const QString& sClass,long nCount)
{
 	m_sClassname=sClass;
	setCount(nCount);
}

KRunningTeamCountObject::KRunningTeamCountObject() : KRunningCountObject() , m_nTeamnumber(0)
{
}

KRunningTeamCountObject::KRunningTeamCountObject(long nTeamnumber,long nCount)
{
	setTeamnumber(nTeamnumber);
	setCount( nCount);
}

