/*  KRunning - Evaluation.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Fre Mai 24 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef EVALUATION_H
#define EVALUATION_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// QT Stuff
#include <qdatetime.h>
#include <qprogressbar.h>
// KDE STuff
#include <ktextbrowser.h>
#include <kpushbutton.h>
#include <kprinter.h>


#include "DBConnection.h"
#include "EvaluationGUI.h"
#include "Printing.h"

class KRunningCountObject
{
	public:
		KRunningCountObject();
	virtual ~KRunningCountObject();
		void setCount(long nCount){m_nCount=nCount;}
		long getCount() const {return m_nCount;}
		KRunningCountObject & operator++() {m_nCount++;return *this;}
	private:
		long m_nCount;
};

class KRunningClassCountObject : public  KRunningCountObject
{
    public:
        KRunningClassCountObject();
        KRunningClassCountObject(const QString &sClassname,long nCount); 
        QString getClassName() const {return m_sClassname;}
    private :
        QString m_sClassname;
 
};

class KRunningTeamCountObject : public  KRunningCountObject
{
    public:
        KRunningTeamCountObject();
        KRunningTeamCountObject(long nTeamnumber,long nCount);// : teamnumber(num),count(c) {}
        void setTeamnumber(long nTeamnumber){m_nTeamnumber=nTeamnumber;}
		int getTeamNumber() const {return m_nTeamnumber;}
    private :
        long m_nTeamnumber;
};

class teamEvalObj {
    public:
        teamEvalObj() : count(0) {}
        teamEvalObj(int num,int c) : teamnumber(num),count(c) {}  // find ...
        teamEvalObj(int num,int c,KRunningRunnerObject &,KRunningTimeObject &);
        void setTeamPlace(int p) {place=p;}
        bool addRunner(KRunningRunnerObject &runner,KRunningTimeObject &time);

        int getTeamPlace() const {return place;}
        int getTeamNumber() const {return teamnumber;}
        int getCount() const {return count;}
        teamEvalObj & operator++() {count++; return *this;}
        QTime getTimeSum() const {return timesum;}
        DBConnection::TimeList getTimeList() const {return times;}
        DBConnection::RunnerList getRunnerList() const {return runners;}
        int getTeamOrder() const {return teamorder;}

    private :
        int teamnumber;
        int teamorder;
        int count; // number of runners, ...
        int place;
        DBConnection::RunnerList runners;
        DBConnection::TimeList times;
        QTime timesum;
};
// This is for qBubbleSort and qHeapSort functions
extern bool operator<(teamEvalObj &,teamEvalObj &);

// For the find functions
extern bool operator==(const KRunningTeamCountObject& ,const KRunningTeamCountObject&);
extern bool operator==(const KRunningClassCountObject&,const KRunningClassCountObject&);
extern bool operator==(teamEvalObj,teamEvalObj);
extern bool operator==(const KRunningTeamObject&,const KRunningTeamObject&);

/** Evaluation
@version 0.7
*/
class Evaluation  : public EvaluationGUI {
        Q_OBJECT
    public:
        Evaluation (QWidget * parent = 0, const char *name = 0);
        virtual ~Evaluation();
        void setDefaultSettings();
        void print(KPrinter *printer);
        void save();
        static   QString getClassString (int yearOfBirth,const QString &sex);
        static   QString getClassString (int yearOfBirth,KRunningRunnerObject::SexNum num);
        typedef QValueList<KRunningClassCountObject> ClassCountList;
        typedef QValueList<KRunningTeamCountObject> TeamCountList;
        // For the Team Evaluation
        typedef QValueList<teamEvalObj> TeamEvalList;
        QValueListIterator<teamEvalObj> findLast(TeamEvalList &,const teamEvalObj &);
    protected:

    protected slots:
        void slotShowTeamResults();
        void slotShowClassResults();
        void evaluateAllRunners();
        void evaluateClassResults(KRunningRunnerObject::SexNum sex);
        void evaluateTeamResults(KRunningRunnerObject::SexNum sex);
    private:
        QString resultText;
};

#endif // EVALUATION_H
