/*  KRunning - EventEdit.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Jul 8 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "EventEdit.h"
#include "EventView.h"

using namespace std;

EventEdit::EventEdit (QWidget * parent, const char *name) : AddEventDialog(parent,name,true) , m_pEventObject(NULL),m_pParent(parent) 
{
    UnitCombo->clear();
    UnitCombo->insertItem(i18n("km"),-1);
    UnitCombo->insertItem(i18n("m"),-1);
    UnitCombo->insertItem(i18n("miles"),-1);
    BlockGroupBox->setEnabled(false);
    //connect ((QObject*)DistanceEdit,SIGNAL(returnPressed()),this, SLOT(distanceReturnPressed()) );
    //    connect ((QObject*)StartNumberCheck,SIGNAL(toggled(bool)),this, SLOT(startNumberCheckToggled(bool)) );
   	
	connect ((QObject*)AddBlockButton,SIGNAL(clicked()),this,SLOT(addBlockClicked()));
    connect((QPushButton *)buttonOk, SIGNAL(clicked()), SLOT(slotOk()));
    connect((QCheckBox *)cbAddBlock, SIGNAL(clicked()),SLOT(cbAddBlockClicked()));
    
   
    QToolTip::add(DistanceEdit,i18n("Enter the distance of the course\nand press enter to save the new event."));

   	EventNameEdit->setFocus();
}

EventEdit::~EventEdit() {
	if (m_pEventObject)
	{
		delete m_pEventObject;
		m_pEventObject=0;
	}
}


void EventEdit::distanceReturnPressed() 
{
    if (checkInputWidgets())
    {
        buttonOk->setEnabled(true);
    }
}

bool EventEdit::checkInputWidgets()
{
	bool bReturn = false;
    if (!EventNameEdit->text().isEmpty() && TimeEdit->time().isValid() && !DistanceEdit->text().isEmpty())
    {
        bReturn=true;
    }
	return bReturn;
}

void EventEdit::addBlockClicked() 
{
	QString sFrame = QString("%1-%2").arg(FromNumInput->value()).arg(ToNumInput->value());
	if (g_pMainUseCase->getConnection()->testStartNumberFrame(sFrame) != -1) return;  // Check if this frame exists or a number from this frame ...
	if (FromNumInput->value() < ToNumInput->value())
	{
		if (m_pEventObject)
		{
			m_pEventObject->setStartNumberFrame(sFrame);
			m_pEventObject->update();
		}
	}
	else
	{
		
	}
}

void EventEdit::cbAddBlockClicked()
{
    
    if ( cbAddBlock )
    {
        BlockGroupBox->setEnabled(cbAddBlock->isChecked());
    }
}

void EventEdit::clear()
{
	EventNameEdit->clear();
	DistanceEdit->clear();
	TimeEdit->setTime(QTime::currentTime());
}

void EventEdit::show()
{
	AddEventDialog::show();

	clear();
	if (m_pEventObject)
	{
		EventNameEdit->setText(m_pEventObject->getName());
		TimeEdit->setTime(m_pEventObject->getEventStarttime());
		
		DistanceEdit->setText(QString("%1").arg(m_pEventObject->getEventDistance()));
		UnitCombo->setCurrentItem(m_pEventObject->getDistanceUnit());
		// TODO Select correct entrys here ...
		buttonOk->setEnabled(true);
	}
	EventNameEdit->setFocus();
}




void EventEdit::setEnableEditFields(bool state) 
{
    EventNameEdit->setEnabled(state);
    TimeEdit->setEnabled(state);
    DistanceEdit->setEnabled(state);
    UnitCombo->setEnabled(state);
}

void EventEdit::slotOk() 
{
	if (checkInputWidgets())
    {
		if (m_pEventObject)
		{
			m_pEventObject->setName(EventNameEdit->text());
			m_pEventObject->setDistance(DistanceEdit->text().toInt());
			m_pEventObject->setStartTime(TimeEdit->time());
			m_pEventObject->setDistanceUnit(KRunningEventObject::DistanceUnit(0));
			m_pEventObject->update();
		}
		else
		{ 
			m_pEventObject=new KRunningEventObject;
			m_pEventObject->setName(EventNameEdit->text());
			m_pEventObject->setDistance(DistanceEdit->text().toInt());
			m_pEventObject->setStartTime(TimeEdit->time());
			m_pEventObject->setDistanceUnit(KRunningEventObject::DistanceUnit(0));
			m_pEventObject->save();
		}
        delete m_pEventObject;
		m_pEventObject=NULL;
    }
    ((EventView *)m_pParent)->updateListView();
}

