/*  KRunning - EventEdit.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Jul 8 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef EVENTEDIT_H
#define EVENTEDIT_H

#include "AddEventGUI.h"
#include "DBConnection.h"
#include "krunning.h"

class EventEdit : public AddEventDialog
{
	Q_OBJECT
public:
	EventEdit (QWidget * parent = 0, const char *name = 0);
	virtual ~ EventEdit ();
	void setEventObject(KRunningEventObject *pEvent){m_pEventObject=pEvent;};
	virtual void show();
public slots: // Public slots
	// void eventSelected(QListViewItem *i);
	

private slots:
	void cbAddBlockClicked();
	void addBlockClicked();
	void distanceReturnPressed();
	void slotOk ();
protected:
	void setEnableEditFields(bool state);
	bool checkInputWidgets();
	void clear();
private:
	KRunningEventObject *m_pEventObject;
	QWidget *m_pParent;
};

#endif // EVENTEDIT_H
