/*  KRunning - EventView.h
 *  Copyright (C) 2005 by Andreas Scherf
 *  Begin Mon Feb 22 2005 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef EVENTVIEW_H
#define EVENTVIEW_H

#include "EventEditGUI.h"
#include "DBConnection.h"
#include "Evaluation.h"
#include "krunning.h"

#include <qpushbutton.h>
// KDE Stuff
#include <kcombobox.h>
#include <klistview.h>
#include <klocale.h>

#include <iostream>

class EventEdit;

class EventListItem : public QListViewItem
{
        //Q_OBJECT
    public:
        EventListItem( QListViewItem *parent, KRunningEventObject *pEvent );

        /*    virtual void paintCell( QPainter *p, const QColorGroup &cg,
        			    int column, int width, int alignment );*/
        virtual ~EventListItem();
        KRunningEventObject *event() { return m_pEventObj; }
        void replaceEvent (KRunningEventObject *pEvent) {m_pEventObj=pEvent;}
    public slots:
    protected:
        KRunningEventObject *m_pEventObj;

};

class EventView : public EventEditGUI
{
        Q_OBJECT
    public:
        EventView (QWidget * parent = 0, const char *name = 0);
        virtual ~EventView ();
        void setDefaultSettings();
        void initListView();
		void updateListView();
    signals:
        void newEventCreated(); /** This Signal is emitted with every created event.*/
    public slots: // Public slots
        void changeEvent(QListViewItem *i, const QPoint &, int );
    private slots:
        void slotEventChanged(QListViewItem *,const QString &,int);
        void newEventClicked();

    protected:
        //  void setEnableEditFields(bool state);
    private:
        QListViewItem *mainItem,*currentItem;
        QListViewItem *findListItem(const QString &name);
        EventListItem *newItem;
        KRunningEventObject *m_pEventObject;
        EventEdit* m_pEventEdit;
};

#endif // EVENTEDIT_H
