/*  KRunning - KDateEdit.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Sep 16 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// from KOrganizer http://korganizer.kde.org

#ifndef KDATEEDIT_H
#define KDATEEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// KDE Stuff
#include <kdatepicker.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>
// QTStuff
//#include <qpainter.h>
#include <qpixmap.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qlineedit.h>


class KDateEdit : public QHBox
{
        Q_OBJECT
    public:
        KDateEdit(QWidget *parent=0, const char *name=0);
        virtual ~KDateEdit();

        bool inputIsValid();

    signals:
        void dateChanged(QDate);

    public slots:
        void setDate(QDate date);
        QDate getDate() const;
        void setEnabled(bool on);

    protected slots:
        void toggleDatePicker();
        void lineEnterPressed();

    private:
        QPushButton *mDateButton;
        QLineEdit *mDateEdit;
        KDatePicker *mDatePicker;
        QVBox *mDateFrame;
};


#endif // KDATEEDIT
