/*  KRunning - PositionControl.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Die Aug 13 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef POSITIONCONTROL_H
#define POSITIONCONTROL_H

#include "PositionControlGUI.h"
#include "DBConnection.h"
#include "krunning.h"
#include "ShowRunner.h"
// QT Stuff
#include <qdatetimeedit.h>
#include <qpopupmenu.h>
#include <qdragobject.h>
// KDE Stuff
#include <knuminput.h>
#include <krestrictedline.h>
#include <kcombobox.h>
#include <klistview.h>
#include <klocale.h>
#include <kpushbutton.h>

class KTimeList;
class KRunnerList;

class PositionControl : public PositionControlGUI
{
        Q_OBJECT
    public:
        PositionControl (QWidget * parent = 0, const char *name = 0);
        virtual ~PositionControl ();
        void setDefaultSettings();
        void initListView();

    public slots: // Public slots
        // void eventSelected(QListViewItem *i);
    protected:
        void selectNextEmptyTime();
    protected slots:
        void deleteSelectedTime();
        void insertNewTime();
        void changeSelectedTime();
        void showPopupMenu(QListViewItem*,const QPoint &,int);
        void timeChanged(const QTime &);
        void timeChangeSave();
        void runnerNumberInput();
        void deleteSelectedRunner();
    private:
        QPopupMenu  * timePopupMenu;
        KTimeList *TimeList;
        KRunnerList *RunnerList;
        bool updateTime;
    private slots:
};


class KRunnerList : public KListView
{
        Q_OBJECT
    public:
        KRunnerList(QWidget *parent = 0,const char * name =0);
        virtual ~KRunnerList();
    protected:
        virtual void startDrag();
        //  void mousePressEvent(QMouseEvent *);
};

class KTimeList : public KListView
{
        Q_OBJECT
    public:
        KTimeList (QWidget * parent=0, const char *name=0) ;
        virtual ~KTimeList();
    signals:
        void dragComplete();
    protected:
        virtual  void contentsDragEnterEvent(QDragEnterEvent *e);
        virtual void contentsDropEvent( QDropEvent* e );
        //void dragMoveEvent( QDragMoveEvent * /*e*/ );
        virtual bool acceptDrag(QDropEvent* event) const;
};

class TimeListItem : public KListViewItem
{
    public:
        TimeListItem( KListView *parent, KRunningTimeObject *to );
        TimeListItem( KListView *parent,KRunningTimeObject *timeobj,KRunningRunnerObject *runnerobj );
        TimeListItem( KListView *parent,KRunningTimeObject timeobj,KRunningRunnerObject runnerobj );
        //     TimeListItem (KListView *parent,const QTime & time,int number = -1);
        int compare( QListViewItem * i, int col, bool ascending ) const;
    protected:
};



#endif // POSITIONCONTROL_H

