//
// C++ Implementation: PostgreSQLConnection
//
// Description: 
//
//
// Author: Andreas Scherf <scherfa@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "PostgreSQLConnection.h"

PostgreSQLConnection::PostgreSQLConnection() : DBConnection()
{
	//krunningConfig->readEntry("Driver","QPSQL7"));
	m_pDB = QSqlDatabase::addDatabase("QPSQL7");
}
PostgreSQLConnection::~PostgreSQLConnection()
{
	delete m_pDB;
	m_pDB = NULL;
}

void PostgreSQLConnection::setConnectionParameter(const QString &databasename,const QString &username,const QString &dbpasswd,const QString &dbhost) {
    
	if ( m_pDB ) 
	{
        m_pDB->setDatabaseName( databasename);
        m_pDB->setUserName( username );
        m_pDB->setPassword( dbpasswd );
        m_pDB->setHostName( dbhost );
    }
}

QString PostgreSQLConnection::getDBVersion()
{
	QString sResult;
 	QSqlQuery query("select version()");
    while (query.next() ) 
	{
         sResult.append(query.value(0).toString());	
	}
	return sResult;
}

void PostgreSQLConnection::connect()
{
	if (m_pDB)
	{ 
		if (!m_pDB->isOpen()) 
		{
            m_bConnected=m_pDB->open();
		}
		else
		{
			m_bConnected=false;
		}

		if ( ! m_bConnected ) {
            qWarning( "PostgreSQLConnection\nFailed to open default database: %s.\n",  m_pDB->lastError().driverText().latin1() );
        }
	}
	/*m_pDefaultDB->setDatabaseName(krunningConfig->readEntry( "Databasename","lauf" ));
        m_pDefaultDB->setUserName(krunningConfig->readEntry( "Username","" ));
        m_pDefaultDB->setPassword(krunningConfig->readEntry( "Password","" ));
        m_pDefaultDB->setHostName(krunningConfig->readEntry( "Hostname","localhost" ));
        //        m_pDefaultDB->setPort(krunningConfig->readEntry( "Port","5432" ).toInt(&port,10));*/
}

void PostgreSQLConnection::disconnect()
{
	if (m_bConnected)
	{
		m_pDB->close();
		m_bConnected=false;
    }
}

bool PostgreSQLConnection::startTransaction() 
{
    if (m_bConnected) 
	{
        return m_pDB->transaction();
    }
	return false;
}

bool PostgreSQLConnection::commitTransaction() 
{
    if (m_bConnected) 
	{
        return m_pDB->commit();
    }
	return false;
}	

bool PostgreSQLConnection::rollbackTransaction()
{
	if (m_bConnected) 
	{
        return m_pDB->rollback();
    }
	return false;
}

long PostgreSQLConnection::getTableCount()
{
	long nTableCount=0;
	if (m_bConnected) 
	{
 		QStringList list = m_pDB->tables();
		QStringList::Iterator it = list.begin();
		while( it != list.end() ) 
		{
			nTableCount++;
			++it;
		}
	}
	return nTableCount;
}

int PostgreSQLConnection::query(KRunningObject *pObject,KRunningResultSet *pResultSet )
{
	QString sStatement= QString ("select * from %1").arg(pObject->getTableName());
	QSqlCursor cursor( pObject->getTableName() );
    QString filter = QString( "event = '%1' " ).arg( 22 );
    cursor.select(filter);
	

	return pResultSet->getColumns();
}




