/*  KRunning - Preferences.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 6 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "Preferences.h"

// GUI Stuff
#include <kiconloader.h>
#include <qlayout.h>
#include <qlabel.h>

// debug
#include <iostream>

using namespace std;

Preferences::Preferences() {
    krunningConfig = KGlobal::config();
}

Preferences::~Preferences()
{
}


void Preferences::init() {
    krunningConfig->setGroup( "Input" );
    /*  startTime = QTime::fromString(krunningConfig->readEntry("Starttime","12:00:00"));
      filename = krunningConfig->readEntry( "Filename","times.lzt");*/
    acrunners=krunningConfig->readBoolEntry( "ACRunnerNames",true);
    rememberevent=krunningConfig->readBoolEntry( "RememberEvent",true);
    eventfromstartnumber=krunningConfig->readBoolEntry("GetEventFromStartNumber",true);
    krunningConfig->setGroup( "Times" );
    timeFormat=  krunningConfig->readEntry("TimeFormat","hh:mm:ss.zzz");
    krunningConfig->setGroup("GlobalEventSettings");
    eventnumber=krunningConfig->readNumEntry("EventNumber",1);
    eventname=krunningConfig->readEntry("EventName","");
    subeventname=krunningConfig->readEntry("SubEventName","");
    organisation=krunningConfig->readEntry("Organisation","");
    eventlocation=krunningConfig->readEntry("Location","");
    eventdate=QDate::fromString(krunningConfig->readEntry("Date",""));
    krunningConfig->setGroup( "Evaluation" );
    teamsize= krunningConfig->readNumEntry("TeamSize",3);
    ignoreteam=krunningConfig->readNumEntry("IgnoreTeam",-1);
    seperator=krunningConfig->readEntry("Seperator",",");
    stringindent=krunningConfig->readEntry("StringIndent","\"");
    krunningConfig->setGroup("Printing");
    printRunnerSpeed=krunningConfig->readBoolEntry("PrintAverageSpeed",false);

}
QString Preferences::getSeperator() 
{
    if (seperator == "<SPACE>") 
	{
        return QString(" ");
    } 
	else if (seperator=="<TAB>") 
	{
        return QString("\t");
    } 
	else 
	{
        return seperator;
    }
}


PreferencesDialog::PreferencesDialog (QWidget * parent, const char *name)
        : KDialogBase(IconList, i18n("Configure"), Help|Apply|Ok|Cancel, Ok, parent, name, true, true ),Preferences()
{
    this->setMinimumHeight( 480 );
    this->setMinimumWidth( 640 );
    init();  // GUI muss weg !!!!
    this->makeGlobalEventPage ();
    this->makeInputPage();
    this->makeTimesPage();
    this->makeEvaluationPage();
    this->makePrintingPage();
    this->makeExportPage();
    this->makeDatabasePage();
    this->adjustSize();
}

PreferencesDialog::~PreferencesDialog ()
{
}


/** No descriptions */
void PreferencesDialog::setFilename (const QString & fn) {
    //filename = fn;
    //    _general.LineEdit1->setText (fn);
}

void PreferencesDialog::setStartTime (const QString & time) {
    //timestring = time;
    //  _general.TimeEdit1->setTime (QTime::fromString (time, Qt::TextDate));
}

void PreferencesDialog::setFormat (const QString & format) {
    /* if (number==Preferences::RTLFormat)
         _general.ComboBox1->setCurrentText("RTLFormat");
     else
         _general.ComboBox1->setCurrentText("TimeFormat");*/
}

void PreferencesDialog::setFormatStrings () {
    //    _general.ComboBox1->insertItem("RTLFormat",Preferences::RTLFormat);
    //  _general.ComboBox1->insertItem("TimeFormat",Preferences::TimeFormat);
}

QString PreferencesDialog::getFilename () {
    // return _general.LineEdit1->text ();
    return "";
}

QTime PreferencesDialog::getStartTime () {
    // return _general.TimeEdit1->time ();
    return QTime::currentTime();
}

bool PreferencesDialog::getAutoConnect() {
    return _database.autoConnect->isChecked();
}




void PreferencesDialog::makeGlobalEventPage () {
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------
    QFrame* page = addPage(
                       i18n("GlobalEvent"),
                       i18n("Global event options"),
                       KGlobal::iconLoader()->loadIcon( "edit",
                                                        KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _global_event.idx = pageIndex( page );



    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "GlobalEventSettings");
    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------


    QGridLayout* grid = new QGridLayout( page, 11,6,1, 5, "grid");
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
    grid->addItem( spacer, 5, 2 );

    _global_event.TextLabel1 = new QLabel( page, "TextLabel1" );
    _global_event.TextLabel1->setText( tr2i18n( "main eventname" ) );

    grid->addWidget( _global_event.TextLabel1, 0, 0 );

    _global_event.TextLabel1_2_2 = new QLabel( page, "TextLabel1_2_2" );
    _global_event.TextLabel1_2_2->setText( tr2i18n( "sub eventname" ) );

    grid->addWidget( _global_event.TextLabel1_2_2, 1, 0 );

    _global_event.LineEdit2 = new QLineEdit( page, "LineEdit2" );
    _global_event.LineEdit2->setText( krunningConfig->readEntry( "SubEventName",""));
    grid->addMultiCellWidget( _global_event.LineEdit2, 1, 1, 1, 2 );

    _global_event.TextLabel1_2 = new QLabel( page, "TextLabel1_2" );
    _global_event.TextLabel1_2->setText( tr2i18n( "Organisation" ) );

    grid->addWidget( _global_event.TextLabel1_2, 2, 0 );

    _global_event.TextLabel1_2_3 = new QLabel( page, "TextLabel1_2_3" );
    _global_event.TextLabel1_2_3->setText( tr2i18n( "Location" ) );

    grid->addWidget( _global_event.TextLabel1_2_3, 3, 0 );

    _global_event.LineEdit4 = new QLineEdit( page, "LineEdit4" );
    _global_event.LineEdit4->setText( krunningConfig->readEntry( "Location",""));
    grid->addMultiCellWidget( _global_event.LineEdit4, 3, 3, 1, 2 );

    _global_event.LineEdit3 = new QLineEdit( page, "LineEdit3" );
    _global_event.LineEdit3->setText( krunningConfig->readEntry( "Organisation",""));
    grid->addMultiCellWidget( _global_event.LineEdit3, 2, 2, 1, 2 );

    _global_event.TextLabel1_2_3_2 = new QLabel(page, "TextLabel1_2_3_2" );
    _global_event.TextLabel1_2_3_2->setText( tr2i18n( "Date" ) );

    grid->addWidget( _global_event.TextLabel1_2_3_2, 4, 0 );

    _global_event.TextLabel1_2_3_4= new QLabel(page,"TextLabel1_2_3_4");
    _global_event.TextLabel1_2_3_4->setText(krunningConfig->readEntry("Date",""));
    grid->addWidget(_global_event.TextLabel1_2_3_4,4,1);

    _global_event.KDatePicker1 = new KDateEdit( page ,"KDateEdit" );
    _global_event.KDatePicker1->setDate(QDate::fromString(krunningConfig->readEntry( "Date","")));
    grid->addMultiCellWidget(_global_event.KDatePicker1, 4, 4,1,1 );

    _global_event.LineEdit1= new QLineEdit( page, "LineEdit1" );
    _global_event.LineEdit1->setText( krunningConfig->readEntry( "EventName",""));
    grid->addWidget(_global_event.LineEdit1, 0, 2 );

    _global_event.SpinBox1 = new QSpinBox( page, "SpinBox1" );
    _global_event.SpinBox1->setValue( krunningConfig->readEntry( "EventNumber",0).toInt());
    grid->addWidget( _global_event.SpinBox1, 0, 1 );


}

void PreferencesDialog::makeEvaluationPage ()
{
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------
    QFrame* page = addPage(
                       i18n("Evaluation"),
                       i18n("Evaluation options"),
                       KGlobal::iconLoader()->loadIcon( "kcalc", KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _evaluation.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------
    QGridLayout* grid = new QGridLayout( page, 4, 2, 1, 5, "grid" );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "Evaluation" );

    // ------------------------------------------------------------------------
    // Create the widgets.
    // ------------------------------------------------------------------------

    _evaluation.teamGroupBox = new QGroupBox( page, "GroupBox1" );


    _evaluation.teamGroupBox->setTitle( tr2i18n( "Team Evaluation Properties" ) );
    _evaluation.teamGroupBox->setColumnLayout(0, Qt::Vertical );
    grid->addWidget(    _evaluation.teamGroupBox,0,0);
    //    QGridLayout ( QLayout * parentLayout, int nRows = 1, int nCols = 1, int spacing = -1, const char * name = 0 )
    QGridLayout * teamBoxLayout = new QGridLayout(     _evaluation.teamGroupBox->layout(),2,3,5,"GridLayout2" );
    teamBoxLayout->setAlignment( Qt::AlignTop );
    teamBoxLayout->addRowSpacing(1,5);
    _evaluation.ignoretext = new QLabel(_evaluation.teamGroupBox,"QLabel");
    _evaluation.ignoretext->setText(i18n("Ignore Team"));
    teamBoxLayout->addWidget(_evaluation.ignoretext,0,0);
    _evaluation.teamSelectBox=new KComboBox(_evaluation.teamGroupBox ,"KComboBox");
    _evaluation.teamSelectBox->insertItem("",-1);
    _evaluation.teamSelectBox->insertStringList(g_pMainUseCase->getConnection()->getTeamNameList());
    if (ignoreteam!=-1) {
        _evaluation.teamSelectBox->setCurrentText(g_pMainUseCase->getConnection()->getTeamNameByNumber(ignoreteam));
    }
    teamBoxLayout->addMultiCellWidget(  _evaluation.teamSelectBox, 0, 0, 1, 2 );

    _evaluation.sizetext = new QLabel(_evaluation.teamGroupBox,"QLabel2");
    _evaluation.sizetext->setText(i18n("Team Size"));
    teamBoxLayout->addWidget(_evaluation.sizetext,1,0);
    _evaluation.teamSizeInput=new KIntNumInput(teamsize,_evaluation.teamGroupBox,10,"KIntNumInput");
    teamBoxLayout->addMultiCellWidget( _evaluation.teamSizeInput, 1, 1, 1, 2 );

}

void PreferencesDialog::makePrintingPage ()
{
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------
    QFrame* page = addPage(
                       i18n("Printing"),
                       i18n("Printing options"),
                       KGlobal::iconLoader()->loadIcon( "klpq", KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _printing.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------
    QGridLayout* grid = new QGridLayout( page, 4, 2, 1, 5, "grid" );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "Printing" );

    // ------------------------------------------------------------------------
    // Create the widgets.
    // ------------------------------------------------------------------------
    _printing.certificationEditButton=new QPushButton(page,"CertificationButton");
    _printing.certificationEditButton->setText(i18n("Edit Certificates"));
    grid->addWidget(     _printing.certificationEditButton,0,0);

    _printing.printRunnerSpeed=new QCheckBox(page,"QCheckBox");
    _printing.printRunnerSpeed->setText(i18n("Print Average Speed"));
    //krunningConfig->readEntry("PrintAverageSpeed",false);
    cout << "printRunnerSpeed " << printRunnerSpeed << endl;
    _printing.printRunnerSpeed->setChecked(printRunnerSpeed);
    grid->addWidget(_printing.printRunnerSpeed,0,1);
    //  connect (_printing.certificationEditButton, SIGNAL (pressed()), this, SLOT (showCertifcationEditor()));
}

void PreferencesDialog::makeExportPage ()
{
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------
    QFrame* page = addPage(
                       i18n("Export"),
                       i18n("Export options"),
                       KGlobal::iconLoader()->loadIcon( "mime_html", KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _export.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "Export" );
    QGridLayout* grid = new QGridLayout(page, 4, 3, 1, 5, "grid" );
    // ------------------------------------------------------------------------
    // Create the widgets.
    // ------------------------------------------------------------------------
    QGroupBox *gbox = new QGroupBox (i18n ("CSV Export Options"), page);
    QGridLayout * grid2 = new QGridLayout(gbox,2,2,5,5);
    _export.label = new QLabel(gbox,"Label");
    _export.label->setText(i18n("Please select separator"));
    grid2->addWidget(_export.label,0,0);
    _export.separatorComboBox = new QComboBox(gbox,"Combo");
    _export.separatorComboBox->insertItem(",");
    _export.separatorComboBox->insertItem(";");
    _export.separatorComboBox->insertItem(":");
    _export.separatorComboBox->insertItem("<TAB>");
    _export.separatorComboBox->insertItem("<SPACE>");
    grid2->addWidget(_export.separatorComboBox,0,1);

    _export.label2 = new QLabel(gbox,"Label2");
    _export.label2->setText(i18n("Please select Textseparator"));
    grid2->addWidget(_export.label2,1,0);
    _export.textsepComboBox = new QComboBox(gbox,"Combo2");
    _export.textsepComboBox->insertItem("\"");
    _export.textsepComboBox->insertItem("\'");
    grid2->addWidget(_export.textsepComboBox,1,1);    //    _evaluation.teamGroupBox = new QGroupBox( page, "GroupBox1" );
    grid->addWidget(gbox,0,0);

}


void PreferencesDialog::makeInputPage ()
{
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------
    QFrame* page = addPage(
                       i18n("Input"),
                       i18n("Input options"),
                       KGlobal::iconLoader()->loadIcon( "ktouch", KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _input.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------
    QGridLayout* grid = new QGridLayout( page, 4, 2, 1, 5, "grid" );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------
    krunningConfig->setGroup( "Input" );
    // ------------------------------------------------------------------------
    // Create the widgets.
    // ------------------------------------------------------------------------

    _input.runnerGroupBox = new QGroupBox( page, "GroupBox1" );

    _input.runnerGroupBox->setTitle( tr2i18n( "Runner Edit Properties" ) );
    _input.runnerGroupBox->setColumnLayout(0, Qt::Vertical );
    grid->addWidget(_input.runnerGroupBox,0,0);
    QGridLayout * runnerBoxLayout = new QGridLayout( _input.runnerGroupBox->layout() );
    runnerBoxLayout->setAlignment( Qt::AlignTop );

    _input.runnerACheckBox=new QCheckBox(_input.runnerGroupBox,"QCheckBox");
    _input.runnerACheckBox->setText( i18n( "Autocomplete Runnernames" ) );
    _input.runnerACheckBox->setChecked( acrunners);
    runnerBoxLayout->addMultiCellWidget( _input.runnerACheckBox, 0, 0, 0, 1 );

    _input.runnerRememberEBox = new QCheckBox(_input.runnerGroupBox,"QCheckBox2");
    _input.runnerRememberEBox->setText(i18n("Remember last Event"));
    _input.runnerRememberEBox->setChecked(rememberevent);
    runnerBoxLayout->addMultiCellWidget( _input.runnerRememberEBox, 1, 1, 0, 1 );

    _input.runnerStartNumberFramesBox = new QCheckBox(_input.runnerGroupBox,"QCheckBox3");
    _input.runnerStartNumberFramesBox->setText(i18n("Get event from Startnumber"));
    _input.runnerStartNumberFramesBox->setChecked(eventfromstartnumber);
    runnerBoxLayout->addMultiCellWidget(_input.runnerStartNumberFramesBox, 2, 2, 0, 1 );
}

void PreferencesDialog::makeTimesPage()
{
    QFrame* page = addPage(
                       i18n("Times"),
                       i18n("Time settings"),
                       KGlobal::iconLoader()->loadIcon("clock",
                                                       KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _times.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------

    QGridLayout* grid = new QGridLayout( page, 4, 2, 1, 5, "grid" );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "Times" );
    _times.formatGroupBox = new QGroupBox( page, "GroupBox11" );

    _times.formatGroupBox->setTitle( tr2i18n( "Time Format Properties" ) );
    _times.formatGroupBox->setColumnLayout(0, Qt::Vertical );
    grid->addWidget(_times.formatGroupBox,0,0);
    QGridLayout * formatBoxLayout = new QGridLayout( _times.formatGroupBox->layout() );
    formatBoxLayout->setAlignment( Qt::AlignTop );

    _times.timeFormatCombo= new QComboBox( _times.formatGroupBox,"QComboBox");
    _times.timeFormatCombo->insertItem("hh:mm:ss.zzz");
    _times.timeFormatCombo->insertItem("hh:mm:ss");
    _times.timeFormatCombo->setCurrentText(timeFormat);
    formatBoxLayout->addMultiCellWidget( _times.timeFormatCombo, 0, 0, 0, 1 );
}

void PreferencesDialog::makeDatabasePage ()
{
    // ------------------------------------------------------------------------
    // Create the frame for the page and hold onto its index.
    // ------------------------------------------------------------------------

    QFrame* page = addPage(
                       i18n("Database"),
                       i18n("Database settings"),
                       KGlobal::iconLoader()->loadIcon("connect_creating",
                                                       KIcon::NoGroup, KIcon::SizeMedium )
                   );
    _database.idx = pageIndex( page );

    // ------------------------------------------------------------------------
    // Create a layout within the page to manage all of the widgets we're going
    // to create.
    // ------------------------------------------------------------------------

    QGridLayout* grid = new QGridLayout(page, 4, 3, 1, 5, "grid" );

    // ------------------------------------------------------------------------
    // Get a handle to the config object we're pulling values out of.
    // ------------------------------------------------------------------------

    krunningConfig->setGroup( "Database" );

    // ------------------------------------------------------------------------
    // Create the widgets.
    // ------------------------------------------------------------------------
    _database.headerLbl = new QLabel( page, "_database.backgroundLbl" );
    _database.headerLbl->setText( i18n("Database settings"));

    grid->addWidget( _database.headerLbl, 0, 0 );

    _database.databaseLstv = new KListView(page,"Tree");
    _database.databaseLstv->setSorting(-1);
    _database.databaseLstv->addColumn(i18n("Name"));
    _database.databaseLstv->addColumn(i18n("Value"));

    QListViewItem *item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Version"));
    item->setText( 1,g_pMainUseCase->getConnection()->getDBVersion());

	item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Events"));
    item->setText( 1,g_pMainUseCase->getConnection()->getCountString("events"));
	
	item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Races"));
    item->setText( 1,g_pMainUseCase->getConnection()->getCountString("races"));

    item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Times"));
    item->setText( 1,g_pMainUseCase->getConnection()->getCountString("times"));

    item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Runners"));
    item->setText( 1,g_pMainUseCase->getConnection()->getCountString("runner"));

    item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Teams"));
    item->setText( 1,g_pMainUseCase->getConnection()->getCountString("teams"));
    

    item = new QListViewItem( _database.databaseLstv );
    item->setText( 0,i18n("Database Name"));
    item->setText( 1,g_pMainUseCase->getConnection()->getDatabaseName());

    grid->addWidget( _database.databaseLstv,1,0);

    // autoconnect?
    QGroupBox *gbox = new QGroupBox (i18n ("Auto Connect"), page);
    QGridLayout *grid2 = new QGridLayout (gbox, 2, 1, 5,5);
    grid2->setMargin (DIALOG_MARGIN);
    _database.autoConnect = new QCheckBox (i18n ("&Auto Connect on Startup"),gbox);
    _database.autoConnect->setChecked( krunningConfig->readBoolEntry( "AutoConnect",TRUE));
    QToolTip::add (_database.autoConnect, i18n ("Check here if you want to automatically connect to the default database on startup."));
    QWidget *test = new QWidget (gbox);
    // _database.autodb = new g_pMainUseCase->getConnection()ectWidget (test, 5); // Wir erben von diesem Teil !!!
    grid2->addWidget (_database.autoConnect, 0, 0);
    grid2->addWidget (test, 1, 0);
    grid->addWidget (gbox,2,0);

    //    connect (_database.autoConnect, SIGNAL (toggled (bool)), _database.autodb, SLOT (enable (bool)));
}

void PreferencesDialog::showCertifcationEditor() {
    CertificationEditDialog *dlg=new CertificationEditDialog(this,"");
    if (dlg->exec()==KDialog::Accepted) {
    }
}

// ----------------------------------------------------------------------------
// Function:    slotOk ()
// ----------------------------------------------------------------------------
// Called whenever the user presses the "Ok" button.  Applies all changes made
// in the preferences dialog and closes the dialog.
// ----------------------------------------------------------------------------
void PreferencesDialog::slotOk ()
{
    this->slotApply();
    accept();
}

// ----------------------------------------------------------------------------
// Function:    slotApply ()
// ----------------------------------------------------------------------------
// Called whenever the user presses the "Cancel" button.  Applies all changes
// made in the preferences dialog.
// ----------------------------------------------------------------------------
void PreferencesDialog::slotApply ()
{
    // ------------------------------------------------------------------------
    // "Input" options.
    // ------------------------------------------------------------------------
    krunningConfig->setGroup( "Input" );
    krunningConfig->writeEntry( "ACRunnerNames", _input.runnerACheckBox->isChecked() );
    krunningConfig->writeEntry( "RememberEvent", _input.runnerRememberEBox->isChecked() );
    krunningConfig->writeEntry("GetEventFromStartNumber",_input.runnerStartNumberFramesBox->isChecked() );
    // ------------------------------------------------------------------------
    // "Evaluation" options.
    // ------------------------------------------------------------------------
    krunningConfig->setGroup( "Evaluation" );
    krunningConfig->writeEntry("TeamSize", _evaluation.teamSizeInput->value());
    if (_evaluation.teamSelectBox->currentItem()>0) {
        krunningConfig->writeEntry("IgnoreTeam",g_pMainUseCase->getConnection()->getTeamnumberByName(_evaluation.teamSelectBox->currentText()));
    } else {
        krunningConfig->writeEntry("IgnoreTeam",-1);
    }
    // ------------------------------------------------------------------------
    // "Print" options.
    // ------------------------------------------------------------------------
    krunningConfig->setGroup( "Printing" );
    krunningConfig->writeEntry( "PrintAverageSpeed", _printing.printRunnerSpeed->isChecked() );
    // ------------------------------------------------------------------------
    // "Database" options.
    // ------------------------------------------------------------------------
       krunningConfig->setGroup( "Database" );
       krunningConfig->writeEntry("Type","Unknown");
//        krunningConfig->writeEntry( "Databasename", _database.autodb->getName() );
//        krunningConfig->writeEntry( "Username",_database.autodb->getUser() );
//        krunningConfig->writeEntry( "Password",  KCodecs::base64Encode(_database.autodb->getPasswd().latin1()).data())  ;
//        krunningConfig->writeEntry( "Location", _database.autodb->getLocation() );
//        krunningConfig->writeEntry( "Port", _database.autodb->getPort() );
//        krunningConfig->writeEntry( "Driver", _database.autodb->getDriver() );
       krunningConfig->writeEntry( "AutoConnect",getAutoConnect());
    //-------------------------------------------------------------------------
    // "Time" options
    //-------------------------------------------------------------------------
    krunningConfig->setGroup("Times");
    krunningConfig->writeEntry("TimeFormat", _times.timeFormatCombo->currentText());
    //-------------------------------------------------------------------------
    // "Export" options
    //-------------------------------------------------------------------------
    krunningConfig->setGroup("Export");
    krunningConfig->writeEntry("Seperator",_export.separatorComboBox->currentText());
    krunningConfig->writeEntry("StringIndent",_export.textsepComboBox->currentText());

    //-------------------------------------------------------------------------
    //  "Global" Options
    //-------------------------------------------------------------------------
    krunningConfig->setGroup("GlobalEventSettings");
    krunningConfig->writeEntry("EventNumber",_global_event.SpinBox1->value());
    krunningConfig->writeEntry("EventName",_global_event.LineEdit1 ->text());
    krunningConfig->writeEntry("SubEventName",_global_event.LineEdit2 ->text());
    krunningConfig->writeEntry("Organisation",_global_event.LineEdit3 ->text());
    krunningConfig->writeEntry("Location",_global_event.LineEdit4 ->text());
    krunningConfig->writeEntry("Date",_global_event.KDatePicker1->getDate().toString());
    // ------------------------------------------------------------------------
    // Done saving, sync the changes to disk.
    // ------------------------------------------------------------------------
    krunningConfig->sync();
    prefs->init();
}

