/*  KRunning - Preferences.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 6 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <qlineedit.h>
#include <qfile.h>
#include <qdir.h>
#include <qdatetimeedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qspinbox.h>
#include <qpushbutton.h>
// KDE Stuff
#include <kdialogbase.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klistview.h>
#include <kdatepicker.h>
#include <kdatewidget.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kmdcodec.h> // Password encoding

#include "DBConnection.h"
#include "krunning.h"
#include "KDateEdit.h"
#include "CertificationEdit.h"


#define DEFAULTTIMEFILE "zeiten.lst"

class Preferences
{
    public:
        enum Format { RTLFormat=0,TimeFormat };
        Preferences ();
        virtual ~ Preferences ();
        /** Public Functions ...*/
        bool readPreferences ();
        bool writePreferences ();
        void init();
        QTime getStartTime() const {return startTime;}
        QString getFilename() const {return filename;}
        QString getTimeFormat()  const {return timeFormat;}
        int getEventnumber() const {return eventnumber;}
        QString getEventname() const {return eventname;}
        QString getSubEventname () const {return subeventname;}
        QString getOrganistaion() const {return organisation;}
        QString getEventLocation() const {return eventlocation;}
        QDate getEventDate() const{return eventdate;}
        bool getACRunnerNames() const {return acrunners;}
        bool getRemeberEvent() const {return rememberevent;}
        bool getEventFromStartNumber () const {return eventfromstartnumber;}
        bool getPrintRunnerSpeed() const {return printRunnerSpeed;}
        int getTeamSize() const {return teamsize;}
        int getIgnoreTeam() const{return ignoreteam;}
        QString getStringIndent() const {return stringindent;}
        QString getSeperator();
    protected:
        KConfig* krunningConfig;
        QTime           startTime;
        QString         filename;
        int eventnumber;
        int teamsize;
        int ignoreteam;
        QString eventname;
        QString subeventname;
        QString organisation;
        QString eventlocation;
        QDate eventdate;

        QString seperator;
        QString stringindent;

        QString timeFormat;
        bool acrunners; //AutoCompletion for the Runner Edit Dialog
        bool rememberevent;
        bool eventfromstartnumber; // Use Startnumberframes to check the right event
        bool printRunnerSpeed;
    private:


};

class PreferencesDialog :  public KDialogBase,public Preferences //public PreferencesGUI
{
        Q_OBJECT
    public:
        PreferencesDialog (QWidget * parent = 0, const char *name = 0);
        virtual ~ PreferencesDialog ();
        /** Public Functions ...*/
        void            setFilename (const QString &);
        void            setStartTime (const QString &);
        void            setFormat (const QString &);
        void            setFormatStrings();
        QString         getFilename ();
        QTime           getStartTime ();
        QString         getTimeFormat();
        bool            getAutoConnect();

    private slots:
        /**
         * Called whenever the user presses the "Ok" button.  Applies all
         * changes made in the preferences dialog and closes the dialog.
         */
        void slotOk ();

        /**
         * Called whenever the user presses the "Apply" button.  Applies all
         * changes made in the preferences dialog.
         */
        void slotApply ();

        void showCertifcationEditor();

    private:

        /**
         * Makes all of the widgets for the "Reports" page in the preferences
         * dialog.
         */
        void makeGlobalEventPage();
        void makeInputPage ();
        void makeTimesPage();
        void makeEvaluationPage();
        void makeDatabasePage ();
        void makePrintingPage();
        void makeExportPage();

        /**
         * Structure for the "Input" preferences page and the widgets on that
         * page.
         */
        struct InputWidget
        {
            int             idx;
            QLabel* TextLabel1;
            QGroupBox *runnerGroupBox;
            QCheckBox *runnerACheckBox;
            QCheckBox *runnerRememberEBox;
            QCheckBox *runnerStartNumberFramesBox;
        };

        struct EvaluationWidget
        {
            int idx;
            QLabel *ignoretext;
            QLabel *sizetext;
            QGroupBox *teamGroupBox;
            KComboBox *teamSelectBox;
            KIntNumInput *teamSizeInput;
        };

        /**
         * Structure for the "Database" preferences page and widgets on that
         * page.
         */
        struct DatabaseWidget
        {
            int             idx;
            QLabel*         headerLbl;
            KListView*    databaseLstv;
            QCheckBox *autoConnect;
        };

        struct GlobalEventWidget
        {
            int idx;
            QLabel* TextLabel1;
            QLabel* TextLabel1_2_2;
            QLineEdit* LineEdit2;
            QLabel* TextLabel1_2;
            QLabel* TextLabel1_2_3;
            QLineEdit* LineEdit4;
            QLineEdit* LineEdit3;
            QLabel* TextLabel1_2_3_2;
            KDateEdit* KDatePicker1;
            QLabel* TextLabel1_2_3_4;
            QLineEdit* LineEdit1;
            QSpinBox* SpinBox1;
        };

        struct TimesWidget
        {
            int idx;
            QGroupBox *formatGroupBox;
            QComboBox *timeFormatCombo;
        };

        struct PrintWidget
        {
            int idx;
            QButton *certificationEditButton;
            QCheckBox *printRunnerSpeed;
        };

        struct ExportWidget
        {
            int idx;
            QComboBox *separatorComboBox;
            QComboBox *textsepComboBox;
            QLabel *label, *label2;
        };

        /**
         * Pages within our preferences dialog.
         */
        InputWidget       _input;
        DatabaseWidget      _database;
        GlobalEventWidget _global_event;
        TimesWidget _times;
        EvaluationWidget _evaluation;
        PrintWidget _printing;
        ExportWidget _export;
};

extern Preferences *prefs;

#endif //PREFERENCES_H
