/*  KRunning - Printing.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Son Aug 11 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Printing.h"


using namespace std;
// USe KHTML::Part && KHTML::View to generate HTML and
//<khtml_part.h>
/*    QString myHTMLCode = ...;
 KHTMLPart *w = new KHTMLPart();
 w->begin();
 w->write(myHTMLCode);
w->view()->print(); ...
 w->end();
  */

Printing::Printing (KPrinter * p) : metrics (p) {
    printer= p;
    if (  !myPainter.begin( printer ) )    {
        currentPage=-1;
    }
    currentPage=1;
    minYValue=10;
    maxYValue=metrics.height()-10;
    marginLeft=10;
    marginRight=10;
    marginTop=10;
    marginBottom=10;
    bottomString=QString(i18n("Printed by %1 with KRunning Version %2 (c) 2002-2007 Andreas Scherf").arg(getenv("USER")).arg(VERSION));;
}

Printing::~Printing (){
    myPainter.end();
}

void Printing::printHeader() {
    int abs=0;
    if (myPainter.isActive()) {
        myPainter.setFont( QFont("Arial", 10, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();
        myPainter.drawText(10,marginTop+fm.height(),QString("%1. %2 %3").arg(prefs->getEventnumber()).arg(prefs->getEventname()).arg(prefs->getSubEventname()));
        myPainter.drawText( 10,marginTop+(2*fm.height()),QString("%1").arg(g_pMainUseCase->getCurrentEvent()->getName()));
        myPainter.setFont( QFont("Arial", 8, QFont::Normal) );

        myPainter.drawLine(10,marginTop+(2*fm.height())+4,metrics.width(),marginTop+(2*fm.height())+4);
        abs=metrics.width()/13;
        int nOffset=2;
        myPainter.drawText( 10,marginTop+(3*fm.height()),i18n("Number"));
        myPainter.drawText( abs*nOffset,marginTop+(3*fm.height()),i18n("Name"));
        nOffset+=3;
        myPainter.drawText( abs*nOffset,marginTop+(3*fm.height()),i18n("Team"));
        nOffset+=2;
        myPainter.drawText( abs*nOffset,marginTop+(3*fm.height()),QString("%1 / %2").arg( i18n("Birthday")).arg(i18n("Class")));
        nOffset+=2;
        myPainter.drawText( abs*nOffset,marginTop+(3*fm.height()),i18n("Time"));
        nOffset+=2;
        if (prefs->getPrintRunnerSpeed()){
            myPainter.drawText(abs*nOffset,marginTop+(3*fm.height()), i18n( "Speed"));
            nOffset+=2;
        }
        myPainter.drawText( abs*nOffset,marginTop+(3*fm.height()),i18n("Place"));

        myPainter.drawLine(10,marginTop+(3*fm.height())+5,metrics.width(),marginTop+(3*fm.height())+5);
        minYValue=marginTop+((2*fm.height())+10);
    }
}

void Printing::printFooter() {
    if (myPainter.isActive()) {
        myPainter.setFont( QFont("Arial", 10, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();
        myPainter.drawLine(marginLeft/2,metrics.height()-24,metrics.width()-(marginLeft/2),metrics.height()-24);
        myPainter.drawText(10,metrics.height()-10,bottomString);
        QString page=QString(i18n("Page")+QString(" %1").arg(currentPage));
        myPainter.drawText(getXPositionRight(myPainter.fontMetrics(),page),metrics.height()-10,page);
        maxYValue=metrics.height()-27;
    }
}

void Printing::printHeader(const QRect &view) {  // here we must set the minimum y value for printing results
    if (myPainter.isActive()) {
        myPainter.setFont( QFont("Arial", 10, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();
        myPainter.drawText(10,view.top()-fm.height(),QString("%1. %2 %3").arg(prefs->getEventnumber()).arg(prefs->getEventname()).arg(prefs->getSubEventname()));
        myPainter.drawText( 10,view.top()-(2*fm.height()),QString("%1").arg(g_pMainUseCase->getCurrentEvent()->getName()));;
        myPainter.drawLine(10,view.y()-5,view.width(),view.y()-5);
        minYValue=view.y()-((2*fm.height())+10);
    }

}

void Printing::printFooter(const QRect &view) {   // here we must set the maximum y value for printing results
    if (myPainter.isActive()) {
        myPainter.setFont( QFont("Arial", 10, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();
        myPainter.drawLine(0,view.y(),view.width(),view.y());
        myPainter.drawText(10,view.y()+fm.height(),bottomString);
        QString page=QString(i18n("Page")+QString(" %1").arg(currentPage));
        myPainter.drawText(getXPositionRight(myPainter.fontMetrics(),page),view.y()+fm.height(),page);
    }
    //   maxYValue=metrics.height()-27;
    maxYValue=view.top();
}


void Printing::printRunnerListView(KListView * listview) {
    QString string;
    RunnerListItem *item;
    const int Margin = 20;

    if (myPainter.isActive()) {
        int yPos	= minYValue;			// y-position for each line
        myPainter.setFont( QFont("Courier", 10, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();

        for( int i = 0 ; i < listview->childCount() ; i++ ) {
            if ( Margin + yPos > maxYValue-50 ) {

                printFooter(); // if ??
                printer->newPage();		// no more room on this page
                currentPage++;
                printHeader();

                myPainter.setFont( QFont("Courier", 10, QFont::Normal) );
                yPos = minYValue;			// back to top of page
            }
            item =(RunnerListItem *) listview->itemAtIndex(i);
            int nPos=0;
            string.append(item->text(nPos++).rightJustify(3,' ',true)+" "); // Number 3 enough ?
            string.append(item->text(nPos++).leftJustify(10,' ',true)+" "); // Surename
            string.append(item->text(nPos++).leftJustify(10,' ',true)+" ");  //Forename
            string.append(item->text(nPos++).leftJustify(20,' ',true)+" ");  // Team
            string.append(item->text(nPos++)+" ");                               // Birthday
            string.append(item->text(nPos++)+" ");                               // Class
            string.append(item->text(nPos++)+" ");                               // Time
            if (prefs->getPrintRunnerSpeed()){
                string.append(item->text(nPos++)+" ");				// Speed
            }
            string.append("|"); // separator
            string.append(item->text(nPos++).rightJustify(3,' ',true)+" ");  // Total Place
            string.append(item->text(nPos++).rightJustify(3,' ',true)+" "); // ClassPlace
            string.append(item->text(nPos++).rightJustify(3,' ',true)+" ");  // SexPlace
            string.append(item->text(nPos++).rightJustify(3,' ',true)+" ");  //TeamPlace
            //  string.append(item->text(11).rightJustify(3,' ',true)+" "); // PlaceNation (not used today)
            myPainter.drawText( Margin, Margin + yPos,
                                metrics.width(), fm.lineSpacing(),
                                Qt::ExpandTabs | Qt::DontClip,
                                string);
            yPos = yPos + (fm.lineSpacing()-4);
            //    cerr << fm.lineSpacing()<< endl; //17
            string="";
        }
    }
}

void Printing::printTeamList( KListView * listview) {
    TeamListItem *item;
    QString string;

    const int Margin = 10;      // Rand

    if(myPainter.isActive() ) {
        myPainter.setFont( QFont("Courier", 10, QFont::Normal) );
        int yPos	= minYValue;			// y-position for each line
        QFontMetrics fm = myPainter.fontMetrics();


        for( int i = 0 ; i < listview->childCount() ; i++ ) {

            //            if ( Margin + yPos > metrics.height() - Margin ) {
            if ( Margin + yPos > maxYValue ) {

                printer->newPage();		// no more room on this page
                yPos = minYValue;			// back to top of page
            }
            item =(TeamListItem *) listview->itemAtIndex(i);
            string.append(item->text(0).rightJustify(4,' ',true)+" "); // Number
            string.append(item->text(1).leftJustify(30,' ',true)+" "); // Teamname
            myPainter.drawText( Margin, Margin + yPos,
                                metrics.width(), fm.lineSpacing(),
                                Qt::ExpandTabs | Qt::DontClip,
                                string);
            yPos = yPos + (fm.lineSpacing()-4); // make this global !!
            //  cerr << fm.lineSpacing()<< endl;
            string="";
        }
    }

}
void Printing::printEvaluationTextBrowser(KTextBrowser * textbrowser) {
    if(myPainter.isActive() ) {
        const int margin = 20; // pt  72

        QRect body(margin,/*minYValue*/60,metrics.width()-margin,maxYValue-100);
        QFont font(textbrowser->QWidget::font() );
        font.setPointSize( 10 ); // we define 10pt to be a nice base size for printing

        QSimpleRichText richText( textbrowser->text(), font,
                                  textbrowser->context(),
                                  textbrowser->styleSheet(),
                                  textbrowser->mimeSourceFactory(),
                                  body.height() );
        richText.setWidth( &myPainter, body.width() );
        QRect view( body );
        do {
            printHeader(view); //
            richText.draw( &myPainter, body.left(), body.top(), view, QColorGroup() );
            view.moveBy( 0, body.height() );

            /*         myPainter.setFont( font );
                     myPainter.drawText( view.right() - myPainter.fontMetrics().width( QString::number( currentPage ) ),
                                         view.bottom() + myPainter.fontMetrics().ascent() + 5, QString::number( currentPage ) );*/

            if ( view.top()  >= body.top() + richText.height() ) {
                printFooter(view); // if ??
                break;
            }

            printFooter(view); // if ??
            myPainter.translate( 0 , -body.height() );
            printer->newPage();
            currentPage++;

        } while (TRUE);
    }
}

void Printing::printCertificationList(KListView *listview) {
    CertificationListItem *item;
    bool firstItem=true;
    if(myPainter.isActive() ) {
        myPainter.setFont( QFont("Times", 14, QFont::Normal) );
        QFontMetrics fm = myPainter.fontMetrics();
        for( int i = 0 ; i < listview->childCount() ; i++ ) {
            item =(CertificationListItem *) listview->itemAtIndex(i);
            if (item->isSelected()) {
                if (!firstItem) {
                    printer->newPage();
                }

                QString event=QString("%1. %2 %3").arg(prefs->getEventnumber()).arg(prefs->getEventname()).arg(prefs->getSubEventname());
                myPainter.drawText( getXPositionCenter(fm,event), 150,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    event);

                QString organisation=QString("%1").arg(prefs->getOrganistaion());
                myPainter.drawText( getXPositionCenter(fm,organisation), 190,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    organisation);

                QString name=QString(item->text(2)+", "+item->text(3));
                myPainter.drawText( getXPositionCenter(fm,name), 250,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    name);

                QString sTeam=QString(item->text(4));
                myPainter.drawText( getXPositionCenter(fm,sTeam), 280,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    sTeam);


                QString klasse = QString (i18n("Got at %1 in class %2 the").arg(g_pMainUseCase->getCurrentEvent()->getName()).arg(item->text(6)));
                myPainter.drawText( getXPositionCenter(fm,klasse), 310,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    klasse);
                QString place = QString (item->text(9)+". "+i18n("Place"));   // Klassenwertung
                myPainter.drawText( getXPositionCenter(fm,place), 330,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,     place);


                QString sTime=QString(i18n("Time")+" : "+item->text(7));
                myPainter.drawText( getXPositionCenter(fm,sTime), 360,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    sTime);
                if (prefs->getPrintRunnerSpeed()){
                    QString sSpeed=QString(i18n("Speed")+" : "+item->text(9));
                    myPainter.drawText( getXPositionCenter(fm,sSpeed),360, metrics.width(),fm.lineSpacing(),
                                        Qt::ExpandTabs | Qt:: DontClip,
                                        sSpeed);
                }
                // Date
                QString date=QString(prefs->getEventLocation()+", "+i18n("the")+" "+KGlobal::locale()->formatDate(prefs->getEventDate(),true)); // true==short !
                myPainter.drawText( getXPositionRight(fm,date), metrics.height()-40,
                                    metrics.width(), fm.lineSpacing(),
                                    Qt::ExpandTabs | Qt::DontClip,
                                    date);

                firstItem=false;
            }
        }
    }
}

int Printing::getXPositionCenter(const QFontMetrics &fm,const QString &str) {
    int stringwidth=-1;
    //QFontMetrics fm=QFontMetrics(f); // Or the fm from the Painter ??
    stringwidth=fm.width(str)/2;
    return ((metrics.width()/2)-stringwidth);
}

int Printing::getXPositionRight(const QFontMetrics &fm,const QString &str) {
    //QFontMetrics fm=QFontMetrics(f); // Or the fm from the Painter ??
    return (metrics.width()-fm.width(str));
}
