/*  KRunning - Printing.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Son Aug 11 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PRINTING_H
#define PRINTING_H

// QT Stuff
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qsqlcursor.h>
#include <qsimplerichtext.h>
#include <qpalette.h>
#include <qcanvas.h>

// KDE Stuff
#include <kprinter.h>
#include <kmessagebox.h>
#include <klistview.h>

#include "krunning.h"
#include "Preferences.h"
#include "ShowRunner.h" // printRunnerView
#include "TeamEdit.h" // printTeamList
#include "Evaluation.h" // print Team / Class Result Lists
#include "Certification.h" //print Certifications

#include <stdlib.h> // getenv

class Printing
{
        //        Q_OBJECT
    public:
        Printing ( KPrinter * printer);
        virtual ~Printing ();

        void setDefaultSettings();
        void printRunnerListView( KListView * listview);
        void printTeamList( KListView * listview);
        void printCertificationList(KListView *listview);
        void printEvaluationTextBrowser(KTextBrowser * textbrowser);
        void printHeader();
        void printHeader(const QRect &view);
        void printFooter();
        void printFooter(const QRect &view);
    protected:
        //       void            keyPressEvent (QKeyEvent *);
        //        void startPrinting(KPrinter *printer);
        int getXPositionCenter(const QFontMetrics &fm,const QString &str);
        int getXPositionRight(const QFontMetrics &fm,const QString &str);
    private:
        bool status;
        int  currentPage;
        int  pageNumber;
        QPainter myPainter;
        KPrinter * printer;
        QPaintDeviceMetrics metrics;
        QCanvas *certificationCanvas;
        int minYValue;  // For Header & Footer ...
        int maxYValue;
        int  marginLeft;
        int    marginRight;
        int    marginTop;
        int    marginBottom;
        QString bottomString;
};


#endif // PRINTING_H
