/*  KRunning - RunnerEdit.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mit Mai 22 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef RUNNEREDIT_H
#define RUNNEREDIT_H

#include "RunnerEditGUI.h"
#include "DBConnection.h"
#include "Evaluation.h"
#include "krunning.h"

#include <kmessagebox.h>
#include <knuminput.h>
#include <krestrictedline.h>
#include <kcombobox.h>
#include <kcompletion.h>
#include <kglobalsettings.h>
#include <qdatatable.h>

#include <klocale.h>

#include <iostream>

class RunnerEdit : public RunnerEditGUI {
        Q_OBJECT
    public:
        RunnerEdit (QWidget * parent = 0, const char *name = 0);
        virtual ~ RunnerEdit ();
        void setDefaultSettings();
    public slots: // Public slots
        void startNumberEntered();
        void sexCharEntered(int);
        void changeStartnumber();
    protected:
        void keyPressEvent (QKeyEvent *);
    private:
        bool checkAllEntrys();
        void insertNewRunner();
        void setupNewRunner();
        long m_nLastRunner;
        long m_nLastEvent;
        bool m_bUpdateRunner;
};

class ChangeNumberDialog : public KDialogBase {
        Q_OBJECT

    public:
        ChangeNumberDialog( QWidget* parent = 0, const char* name = 0 );
        ~ChangeNumberDialog();

        QLabel* TextLabel2_2;
        QLabel* OldNumberLabel;
        QLabel* TextLabel4_2;
        QLabel* NameLabel;
        QLabel* TextLabel3_2;
        KIntNumInput* NewNumberInput;
        void setOldNumber(int num);
        void setName(const QString &name);
        int getNewNumber();
    public slots:
        void startNumberChanged();
    protected:
        QVBoxLayout* Layout4;
        QHBoxLayout* Layout2_2;
        QHBoxLayout* Layout3_3;
        QHBoxLayout* Layout3_4;
    private:
        QLabel *   pixLabel;
};

#endif // RUNNEREDIT_H
