/*  KRunning - ShowRunner.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Jul 22 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

 #ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ShowRunner.h"

using namespace std;

ShowRunner::ShowRunner (QWidget * parent, const char *name) : ShowRunnerGUI(parent,name,true){
    lastRunnerNum=-1;
    mainListView-> setRootIsDecorated ( false);

    showResultColumns(!showAllRunnerCBox->isChecked());

    mainListView->setShowSortIndicator(true);
    mainListView->setAllColumnsShowFocus ( true );
    mainListView->setItemMargin(2);
    connect((QObject*)showAllRunnerCBox,SIGNAL(clicked()),this, SLOT(slotShowAllClicked()) );
    /*  connect((QObject*)SexCharEdit,SIGNAL(returnPressed()),this, SLOT(sexCharEntered()) );*/
}

ShowRunner::~ShowRunner() {
}

void ShowRunner::setDefaultSettings() {
    showResultColumns(!showAllRunnerCBox->isChecked());
}

void ShowRunner::showRunnerResults() {
    RunnerListItem *item;
    DBConnection::TimeList timelist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;

	if (g_pMainUseCase->getCurrentEvent())
	{
		runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber(),true);
		runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
		timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
		DBConnection::RunnerList::iterator it;
		DBConnection::TimeList::iterator ittl;
		DBConnection::RunnerTimeList::iterator itrtl;
		// Maybee Performance leaks ....
		for ( it = runnerlist.begin(); it != runnerlist.end(); ++it ) {
			if ((*it).getState() == KRunningRunnerObject::eEvaluated) {
				for (itrtl=runnertimelist.begin();itrtl!=runnertimelist.end();++itrtl) {
					if ((*itrtl).getRunnerRef()==(*it).getNumber()) {
						for (ittl=timelist.begin();ittl!=timelist.end();++ittl) {
							if ((*ittl).getNumber()==(*itrtl).getTimeRef()) {
								item=new RunnerListItem(mainListView,&(*it),&(*ittl));
								mainListView->insertItem(item);
							}
						}
					}
				}
			} else {
				item = new RunnerListItem(mainListView,&(*it));
				mainListView->insertItem(item);
			}
		}
	}
}

void ShowRunner::showAllRunners() {
    RunnerListItem *item;
    DBConnection::RunnerList runnerlist;
    DBConnection::EventList eventlist;

    eventlist=g_pMainUseCase->getConnection()->getEventList();
    DBConnection::EventList::iterator ei;
    DBConnection::RunnerList::iterator it;
    // Ugly see above !!
    for (ei=eventlist.begin();ei!=eventlist.end();++ei) {
        runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEvent((*ei).getNumber(),true);
        for ( it = runnerlist.begin(); it != runnerlist.end(); ++it ) {
            item=new RunnerListItem(mainListView,&(*it),(*ei).getName());
            mainListView->insertItem(item);
        }
    }
}

void ShowRunner::slotShowAllClicked() {
    showResultColumns(!showAllRunnerCBox->isChecked());
}

void ShowRunner::showResultColumns(bool show) {
    mainListView->clear();
    while (mainListView->columns()!=0) {
        mainListView->removeColumn(0);
    }

    if (show) {
        mainListView->addColumn    ( i18n( "Number" ));
        mainListView->setColumnAlignment ( 0, Qt::AlignRight );
        mainListView->addColumn    ( i18n( "Name" ));
        mainListView->addColumn    ( i18n( "Forename" ));
        mainListView->addColumn    ( i18n( "Team" ));
        mainListView->addColumn    ( i18n( "Birthday" ));
        mainListView->addColumn    ( i18n( "Class" ));

        mainListView->addColumn    ( i18n( "Time" ));
        if (prefs->getPrintRunnerSpeed()){
            mainListView->addColumn	   ( i18n( "Speed"));
        }
        //Qt::AlignHCenter
        mainListView->addColumn    ( i18n( "Total" ));
        mainListView->addColumn    ( i18n( "Class" ));
        mainListView->addColumn    ( i18n( "Sex" ));
        mainListView->addColumn    ( i18n( "Team" ));
        mainListView->addColumn    ( i18n( "Nation" ));
        for (int i=6;i<=11;i++) {
            mainListView->setColumnAlignment ( i, Qt::AlignRight );
        }
        mainListView->addColumn    ( i18n( "State" ));
        showRunnerResults();
    } else {
        mainListView->addColumn    ( i18n( "Number" ));
        mainListView->setColumnAlignment ( 0, Qt::AlignRight );
        mainListView->addColumn    ( i18n( "Name" ));
        mainListView->addColumn    ( i18n( "Forename" ));
        mainListView->addColumn    ( i18n( "Team" ));
        mainListView->addColumn    ( i18n( "Birthday" ));
        mainListView->addColumn    ( i18n( "Class" ));
        mainListView->addColumn    ( i18n( "Event" ));
        showAllRunners();
    }
    mainListView->triggerUpdate();
}

// -----------------------------------------------------------------
int RunnerListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
    RunnerListItem *other = (RunnerListItem *)i;
    switch ( col ) {
    case 0:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
        if ( text(col).toInt() == other->text(col).toInt() )
            return 0;
        else
            return text(col).toInt() < other->text(col).toInt() ? -1 : 1;
        break;
    default:
        // use default method for colum 0 and others added in the future
        return QListViewItem::compare( i, col, ascending );
    };
}

RunnerListItem::RunnerListItem( KListView *parent,KRunningRunnerObject *runnerobj)
        : KListViewItem( parent )
{
    m_pRunner = runnerobj;
    setText(0, QString::number(runnerobj->getNumber()) );
    setText(1, runnerobj->getSurname() );
    setText(2, runnerobj->getForename() );
    setText(3, runnerobj->getTeamname());
    setText(4, QString::number(runnerobj->getBirthday()) );
    setText(5, Evaluation::getClassString(runnerobj->getBirthday(),runnerobj->getSex()));
    setText(6,"");
}

RunnerListItem::RunnerListItem( KListView *parent,KRunningRunnerObject *runnerobj,KRunningTimeObject * to)
        : KListViewItem( parent )
{
    m_pRunner = runnerobj;
    int nColumn=0;
    setText(nColumn++, QString::number(runnerobj->getNumber()) );
    setText(nColumn++, runnerobj->getSurname() );
    setText(nColumn++, runnerobj->getForename() );
    setText(nColumn++, runnerobj->getTeamname());
    setText(nColumn++, QString::number(runnerobj->getBirthday()) );
    setText(nColumn++, Evaluation::getClassString(runnerobj->getBirthday(),runnerobj->getSex()));
    if (to->getNumber()!=-1) {
        setText(nColumn++,to->getTimeString("hh:mm:ss.zzz"));
    }

    if (prefs->getPrintRunnerSpeed()) {
        double fAvgSpeed=0.0;
        double dTimeSum = ((to->getTime().hour()*3600)+(to->getTime().minute()*60)+(to->getTime().second()))/3600.0;
        if (dTimeSum > 0.0)	{
            fAvgSpeed=(g_pMainUseCase->getCurrentEvent()->getEventDistance())/dTimeSum;
        }

        QString sAvgSpeed = QString("%1").arg(fAvgSpeed);
        sAvgSpeed+=" "+g_pMainUseCase->getCurrentEvent()->getDistanceString()+"/h";
        setText(nColumn++,sAvgSpeed);
    }
    if (runnerobj->getState()==KRunningRunnerObject::eEvaluated) {
        setText(nColumn++,QString::number(runnerobj->getTotalPlace()));
        setText(nColumn++,QString::number(runnerobj->getClassPlace()));
        setText(nColumn++,QString::number(runnerobj->getSexPlace()));
        setText(nColumn++,QString::number(runnerobj->getTeamPlace()));
        setText(nColumn++,QString::number(runnerobj->getNationPlace()));
        setText(nColumn++,i18n("Evaluated"));
    }

}

RunnerListItem::RunnerListItem( KListView *parent,KRunningRunnerObject *runnerobj,const QString & event)
        : KListViewItem( parent )
{
	m_pRunner= runnerobj;
    setText(0, QString::number(runnerobj->getNumber()) );
    setText(1, runnerobj->getSurname() );
    setText(2, runnerobj->getForename() );
    setText(3, runnerobj->getTeamname());
    setText(4, QString::number(runnerobj->getBirthday()) );
    setText(5, Evaluation::getClassString(runnerobj->getBirthday(),runnerobj->getSex()));
    setText(6, event);
}
RunnerListItem::RunnerListItem( KListView *parent,KRunningRunnerObject *runnerobj,int size)
        : KListViewItem( parent )
{
	m_pRunner=runnerobj;
    setText(0, QString::number(runnerobj->getNumber()) );
    setText(1, runnerobj->getSurname() );
    setText(2, runnerobj->getForename() );
}


// -----------------------------------------------------------------

/** Funktion to print Runnerlists
  @version 0.2
  @param a KPrinter Object
*/
void ShowRunner::print(KPrinter * printer) {
    Printing *printing = new Printing(printer);
    printing->printHeader();
    printing->printRunnerListView(mainListView);
    printing->printFooter();
    delete (printing);
}


/** Funktion to export Runnerlists as HTML file
@version 0.3
*/

void ShowRunner::exportHTMLHeader(QTextStream &stream) {
    stream << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" ";
    stream << "\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n";
    stream << "<!-- KRunning Save File -->\n";
    stream << QString("<!-- generated by KRunning Version %1 -->\n").arg(VERSION);
    stream << QString("<!-- Date : %1 Time : %2 -->\n").arg(QDate::currentDate().toString()).arg(QTime::currentTime().toString());
    stream << "<html>\n<head>\n";
    stream << " <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" <<  QTextCodec::codecForLocale()->mimeName() << "\">\n";
    stream << "<meta name=\"krunning_data\" content=\"KRunning HTML export file\">\n<title>";
    stream << QString("%1 ...</title>\n").arg(g_pMainUseCase->getCurrentEvent()->getName());
    stream <<  "<style type=\"text/css\">\n<!-- body { font-family: arial, sans-serif}\n";
    stream <<  "a { text-decoration: none }\n";
    stream <<  "a:hover { text-decoration: underline }\n";
    stream <<  "a:visited:hover { text-decoration: underline }\n";
    stream <<  "td { font-family: arial, sans-serif; font-size: 12px }\n";
    stream <<  "p { font-family: arial, sans-serif; font-size: 12px }\n";
    stream <<  "div { font-family: arial, sans-serif; font-size: 12px }\n";
    stream <<  "header { font-size: 14px; font-weight: bold; color: #FF6600 }\n";
    stream <<  "header2 { font-size: 12px; font-weight: bold; color: #FF6600 }\n";
    stream <<  "small { font-size: 10px; }\n";
    stream <<  "smallbold { font-size: 11px; font-weight: bold }\n";
    stream <<  "--></style>\n";
    stream << "</head>\n";
}

void ShowRunner::exportFile(const KURL& url, const char *format /*=0*/) {
    cerr << format << endl;
    RunnerListItem *item;
    QFile file( url.path());
    if ( file.open( IO_WriteOnly ) ) {
        QTextStream stream( &file );
        exportHTMLHeader(stream);
        stream << QString("<body bgcolor=\"%1\" >\n").arg("#ffffff");
        stream << QString("<strong class=\"header\">%1</strong><br>\n").arg(g_pMainUseCase->getCurrentEvent()->getName());
        stream << "<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\" width=\"90%\">\n";
        stream << QString("<tr bgcolor=\"%1\">\n").arg("#ff00ff");
        stream << "<td>Nummer</td><td>Name</td><td>Vorname</td><td align=\"center\">Verein</td><td>Geburtsjahr</td><td>Klasse</td><td align=\"center\">Zeit</td><td>Gesamt</td><td>Klasse</td><td>Geschlecht</td><td>Verein</td>\n";
        stream << "</tr>\n";
        for( int i = 0 ; i < mainListView->childCount() ; i++ ) {
            item =(RunnerListItem *) mainListView->itemAtIndex(i);
            stream << "<tr>";
            stream<< "<td align=\"right\">" << item->text(0).rightJustify(3,' ',true) << "</td>";
            stream<< "<td>" << item->text(1).left(15) << "</td>";
            stream<< "<td>" << item->text(2).left(15) << "</td>";
            stream<< "<td>" << item->text(3).left(20) << "</td> ";
            stream<< "<td align=\"center\">" << item->text(4) << "</td> ";
            stream<< "<td align=\"center\">" << item->text(5) << "</td> ";
            stream<< "<td align=\"center\">" << item->text(6) << "</td> "; // Time
            stream<< "<td align=\"right\">" << item->text(7) << "</td> ";
            stream<< "<td align=\"right\">" << item->text(8) << "</td> "; // Class
            stream<< "<td align=\"right\">" << item->text(9) << "</td> "; // Sex
            stream<< "<td align=\"right\">" << item->text(10) << "</td> "; // Team
            stream << "</tr>" << "\n";
        }
        stream <<  "</table>\n";
        stream << "<br>\n";
        stream << QString("<p>Diese Liste wurde generiert mit <a href=\"%1\">%2</a> Version %3</p>\n").arg("http://krunning.sourceforge.net").arg("KRunning").arg(VERSION);
        stream << "</body>\n</html>";
        file.close();
    }
}



