/*  KRunning - ShowRunner.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Jul 22 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SHOWRUNNER_H
#define SHOWRUNNER_H

#include "ShowRunnerGUI.h"
#include "DBConnection.h"
#include "Evaluation.h"
#include "Printing.h"
// KDE Stuff
#include <klistview.h>
#include <kprinter.h>

// QT Stuff
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
// HTML
#include <qtextcodec.h>


#include "krunning.h"

class ShowRunner : public ShowRunnerGUI
{
        Q_OBJECT

    public:
        ShowRunner (QWidget * parent = 0, const char *name = 0);
        virtual ~ ShowRunner ();
        void setDefaultSettings();
        void print(KPrinter *printer);
        void exportFile(const KURL& url, const char *format);
        void exportHTMLHeader(QTextStream &stream);
    public slots: // Public slots
        void slotShowAllClicked();
        //    void sexCharEntered();
    protected:
        void showResultColumns(bool show);
        void showAllRunners();
        void showRunnerResults();
    private:
        int lastRunnerNum;
};

class RunnerListItem : public KListViewItem
{
    public:
        RunnerListItem( KListView *parent, KRunningRunnerObject *ro );
        RunnerListItem( KListView *parent, KRunningRunnerObject *ro ,const QString & event);
        RunnerListItem( KListView *parent, KRunningRunnerObject *ro ,int size); // put this into position dialog ...
        RunnerListItem( KListView *parent,KRunningRunnerObject *ro,KRunningTimeObject * to);
        /*  virtual void paintCell( QPainter *p, const QColorGroup &cg,
        	    int column, int width, int alignment );*/

        KRunningRunnerObject *runner() { return m_pRunner; }
        int compare( QListViewItem * i, int col, bool ascending ) const;
    protected:
        KRunningRunnerObject *m_pRunner;

};

#endif //SHOWRUNNER_H
