/*  KRunning - TeamEdit.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 20 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TeamEdit.h"

TeamEdit::TeamEdit (QWidget * parent, const char *name) : TeamsEditGUI(parent,name,true) {
    teamListView-> setRootIsDecorated ( false);
    teamListView->addColumn    ( i18n( "Number" ));
    teamListView->setColumnAlignment ( 0, Qt::AlignRight );
    teamListView->addColumn    ( i18n( "Teamname" ));
    teamListView->setResizeMode ( QListView::LastColumn);
    //Qt::AlignHCenter
    teamListView->setShowSortIndicator(true);
    teamListView->setAllColumnsShowFocus ( true );
    teamListView->setItemsRenameable(true);
    teamListView->setRenameable (0,false);
    teamListView->setRenameable (1,true);

    teamPopupMenu = new QPopupMenu(teamListView,"popupMenu");
    teamPopupMenu->setCaption("Team Menu");
    // This is because foreign keys didn't work in SQLite Version 2.7.1
    int id= teamPopupMenu->insertItem( i18n("delete Team"), this, SLOT(slotDeleteSelectedTeam()) );
    teamPopupMenu->setItemEnabled(id,false);
    // ---

    // Tool Tip
    QToolTip::add(teamNameEdit,i18n("Insert new Teams here and press (Enter) to save them ..."));
    // Connects
    connect (teamListView,SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint & ,int ) ),this,SLOT(slotShowPopupMenu(QListViewItem*,const QPoint &,int)));
    connect( teamNameEdit, SIGNAL( returnPressed() ), this, SLOT( slotNewTeam() ) );
    connect( teamListView,SIGNAL(itemRenamed (QListViewItem *,const QString &,int)),this,SLOT(slotTeamRenamed(QListViewItem *,const QString &,int)));

}

TeamEdit::~TeamEdit() {
}
void TeamEdit::slotShowPopupMenu(QListViewItem* item,const QPoint & point,int col) {
    teamPopupMenu->exec(point);
}

void TeamEdit::slotDeleteSelectedTeam() {
    if ( g_pMainUseCase->getConnection()->deleteTeamByString( teamListView->currentItem()->text(1)))
        teamListView->takeItem( teamListView->currentItem());
}


void TeamEdit::setDefaultSettings() {
    teamListView->clear();
    TeamListItem *item;

    DBConnection::TeamList teamlist;

    teamlist=g_pMainUseCase->getConnection()->getTeamList();
    DBConnection::TeamList::iterator it;

    for ( it = teamlist.begin(); it != teamlist.end(); ++it ) {
        item=new TeamListItem(teamListView,&(*it));
        teamListView->insertItem(item);
    }
    teamNameEdit->clear();
    teamNameEdit->setFocus();
}

void TeamEdit::slotNewTeam() {
    KRunningTeamObject oTeam;
	oTeam.setName(teamNameEdit->text());
	oTeam.save();
    setDefaultSettings();
}

void TeamEdit::slotTeamRenamed(QListViewItem *item,const QString &name,int col) 
{
    KRunningTeamObject oTeam;
	oTeam.setNumber(item->text(0).toInt());
	oTeam.setName(name);
	oTeam.update();
}

void TeamEdit::print (KPrinter * printer) {
    Printing *printing = new Printing(printer);
    printing->printHeader();
    printing->printTeamList(teamListView);
    printing->printFooter();
    delete (printing);
}

//-----------------------
TeamListItem::TeamListItem( KListView *parent,KRunningTeamObject *to)
        : KListViewItem( parent )
{ teamobj = to;
    setText(0, QString::number(teamobj->getNumber()) );
    setText(1, teamobj->getName() );
}

int TeamListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
    TeamListItem *other = (TeamListItem *)i;
    switch ( col ) {
    case 0:
        if ( text(0).toInt() == other->text(0).toInt() )
            return 0;
        else
            return text(0).toInt() < other->text(0).toInt() ? -1 : 1;
        break;
    default:
        // use default method for colum 0 and others added in the future
        return QListViewItem::compare( i, col, ascending );
    };
}

//-----------------------
