/*  KRunning - Time.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai 6 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Time.h"

Time::Time (QWidget * parent, const char *name) : TimeGUI (parent, name, true)
{
    AnalogClock1->setLabelText( i18n("Current time"));
    AnalogClock2->setLabelText( i18n("Finished Runners"));
    AnalogClock3->setLabelText( i18n("Actual Running Time"));
    AnalogClock3->setTimeFormat(prefs->getTimeFormat()); //Configure ??
    AnalogClock1->setShowCTime(TRUE);
    AnalogClock1->start();
    AnalogClock3->start();
    AnalogClock2->setDisplayTime("00:00:00");
    AnalogClock2->setMessageText(0);
    // Set the Message font size to 20 ...
    QFont font=KApplication::font();
    font.setPointSize(20);
    AnalogClock2->setMessageFont(font);

    TimeListView->clear();

    LineEdit1->setReadOnly ( TRUE );
    NumberInput->setValidChars("0123456789"); // Only Numbers could be entered ..
    if (g_pMainUseCase->isConnected()) {
        m_sFilename=g_pMainUseCase->getConnection()->getDatabaseName();
    } else {
        m_sFilename = QString ("");
        m_nTimesum = 1;
    }
    TimeListView->setResizeMode(QListView::AllColumns);
    TimeListView->addColumn      ( i18n( "Time" ));
    TimeListView->addColumn     ( i18n( "Number" ));
    m_pPopupMenu = new QPopupMenu(TimeListView,"popupMenu");
    m_pPopupMenu->setCaption("Time Menu");
    m_pPopupMenu->insertItem( i18n("delete Time"), this, SLOT(deleteSelectedTime()) );

    m_pFullScreenMenu = new QPopupMenu(this,"fullScreenMenu");
    m_pFullScreenMenu->insertItem( i18n("Show Full Screen"), this, SLOT(slotShowFullScreen()) );

    connect (TimeListView,SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &,int ) ),this,SLOT(showPopupMenu(QListViewItem*,const QPoint &,int)));
    //  connect(this,SIGNAL(mousePressEvent()),this,SLOT(mousePressEvent()));
    m_pTime=NULL;
}

Time::~Time ()
{
	delete m_pTime;
	m_pTime=NULL;
	delete m_pFullScreenMenu;
	m_pFullScreenMenu=NULL;
	delete m_pPopupMenu;
	m_pPopupMenu=NULL;
}

//
// Stores aktual time to file ... ?? Im Time Code ???
//
void Time::keyPressEvent (QKeyEvent * k) {
    QTime time;
    int timenumber=-1,runnernumber=-1;
    bool runnernumbervalid=FALSE;
    if (k->key () == Qt::Key_Return || k->key() == Qt::Key_Enter) 
	{
		QString sTimeFormat=AnalogClock3->getTimeFormat();
        time=AnalogClock3->getTimeDiff (QTime::currentTime ());
        if (g_pMainUseCase->isConnected()) {
            if (NumberInput->text().length()>0)
                runnernumber=NumberInput->text().toInt();

            KRunningTimeObject *pTime=new KRunningTimeObject;
			pTime->setEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
			pTime->setTime(time);
            pTime->save();
            timenumber=pTime->getNumber();
            delete (pTime);
            if (g_pMainUseCase->getConnection()->checkIfRunnerInEvent(runnernumber,g_pMainUseCase->getCurrentEvent()->getNumber())) { // Check here if the runner exists and if the runner is in this event
                // CheckIfRunnerhas a time ??
                if (g_pMainUseCase->getConnection()->checkIfRunnerHasTime(runnernumber,g_pMainUseCase->getCurrentEvent()->getNumber())) {
                    runnernumbervalid=FALSE;
                } else {
                    KRunningRunnerTimeObject oRunnerTime;
					oRunnerTime.setEventRef(g_pMainUseCase->getCurrentEvent()->getNumber());
					oRunnerTime.setRunnerRef(runnernumber);
					oRunnerTime.setTimeRef(timenumber);
                    oRunnerTime.save();
                    runnernumbervalid=TRUE;
                }
            } else {
                runnernumbervalid=FALSE;
            }
        }/* else {
            QDir::setCurrent (QDir::homeDirPath ());
            fstream         FS (filename, ios::in | ios::out);
            FS.seekp (0, ios::end);
            FS << timenumber << " " << time.toString("hh:mm:ss.zzz") << endl;
            FS.close ();
        }  */

        // Do some output
        if (runnernumbervalid)   
		{
            TimeListView->insertItem(new TimeViewItem(TimeListView,time,sTimeFormat,NumberInput->text().toInt()));
        } 
		else
		{
            TimeListView->insertItem(new TimeViewItem(TimeListView,time,sTimeFormat));   // Configure ??
        }

        m_nTimesum++; // Starts with 0 !!
        AnalogClock2->setDisplayTime(time.toString());
        AnalogClock2->setMessageText (m_nTimesum);
        TimeListView->ensureItemVisible ( TimeListView->lastItem()) ; // SO we could see always the last time
        NumberInput->clear();
    }
}


void Time::setTimeList() 
{
    DBConnection::TimeList list;
    DBConnection::RunnerTimeList rtlist;
    long long runnernumber=-1;
    TimeListView->clear();
    m_nTimesum=0;
    list=g_pMainUseCase->getConnection()->getTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    rtlist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
	QString sTimeFormat=AnalogClock3->getTimeFormat();
    for (  DBConnection::TimeList::Iterator it = list.begin(); it != list.end(); ++it ) {
        KRunningTimeObject *time=new KRunningTimeObject(*it);
        for (DBConnection::RunnerTimeList::Iterator itr=rtlist.begin();itr!=rtlist.end();itr++) {    // Searching for the runnernumber in the runnertimes relation
            KRunningRunnerTimeObject *pRunnerTime=new KRunningRunnerTimeObject(*itr);
            if (time->getNumber()==pRunnerTime->getTimeRef()) {
                runnernumber=pRunnerTime->getRunnerRef();
            }
            delete (pRunnerTime);
			pRunnerTime=NULL;
        }
        if (runnernumber==-1) 
		{
            TimeListView->insertItem(new TimeViewItem(TimeListView,time->getTime(),sTimeFormat));   // Configure ??
        }
		else 
		{
            TimeListView->insertItem(new TimeViewItem(TimeListView,time->getTime(),sTimeFormat,runnernumber));
        }
        runnernumber=-1;
        m_nTimesum++;
        AnalogClock2->setDisplayTime(time->getTimeString("hh:mm:ss"));
        delete (time);
    }
    AnalogClock2->setMessageText (m_nTimesum);
    TimeListView->ensureItemVisible ( TimeListView->lastItem()) ;
}

void Time::setDefaultSettings() {
    this->setStartTime(g_pMainUseCase->getCurrentEvent()->getEventStarttime());
    if (g_pMainUseCase->isConnected()) {
        this->setFilename(g_pMainUseCase->getConnection()->getDatabaseName());
    } else {
        this->setFilename(prefs->getFilename());
    }
    setTimeList();
    NumberInput->setFocus();
}

void Time::showPopupMenu (QListViewItem* item,const QPoint & point,int col) 
{
	if (col==0 && item)
	{
    	m_pPopupMenu->exec(point);
	}
}

void Time::mousePressEvent (QMouseEvent * e) {
    if (e->button () == QMouseEvent::RightButton)	{// right button pressed
        //        QPoint point =
        m_pFullScreenMenu->exec(e->globalPos());
    }
}

void Time::slotShowFullScreen() {
    if (parentWidget()!=0) 
	{
        if (m_pTime==NULL)
		{
            m_pTime = new Time(0,"TimeWidget");
		}

        m_pTime->showFullScreen();
        m_pTime->setFocusPolicy( QWidget::StrongFocus );
        m_pTime->setDefaultSettings();
        m_pTime->show();
    } 
	else 
	{
        this->close();
    }
}

void Time::deleteSelectedTime() {

    if ( g_pMainUseCase->getConnection()->deleteTimeByTimestring( TimeListView->currentItem()->text(0),g_pMainUseCase->getCurrentEvent()->getNumber() )) {
        TimeListView->takeItem( TimeListView->currentItem());
        m_nTimesum--;
        AnalogClock2->setMessageText (m_nTimesum);
        AnalogClock2->setDisplayTime( TimeListView->lastItem()->text(0).left(8));
    }
}


/** getRTLCode - Decodes the Time that it matches the Timecode from RTL
 ** below there is the decode Sequence from KRunning ...
 ** seconds = (atoi (string[1]) / 100) % 100;                          // Sekunden
 ** seconds = seconds + (((atoi (string[1]) / 10000) % 60) * 60);      // Minuten
 ** seconds = seconds + (((atoi (string[1]) / 10000) / 60) * 3600);    // Stunden
 ** @author Andreas Scherf
 ** @version 1.0
 */
uint Time::getRTLCode (const QTime & t) {
    uint            result;
    result = t.second () * 100;
    result += t.minute () * 10000;
    result += (t.hour () * 600000);	///3600;  //ERROR
    return result;
}
uint Time::getSeconds (const QTime &t) {
    uint result;
    result = (t.hour()*3600);
    result += t.minute() *60;
    result += t.second();
    return result;
}

void Time::setFilename(const QString &sFilename) 
{
    m_sFilename=sFilename;
    LineEdit1->setText(sFilename);
}

void Time::setStartTime(const QTime &time) 
{
    AnalogClock3->setStartTime(time.toString());
}


//TODO: Select Runner 
TimeViewItem::TimeViewItem (KListView *parent,const QTime & time,const QString& sTimeFormat,int number)
        :KListViewItem(parent)
{
    setText(0, time.toString(sTimeFormat ));
    if (number > 0)
        setText(1, QString::number(number) );
    else
        setText(1, "---");
}

int TimeViewItem::compare( QListViewItem * i, int col, bool ascending ) const
{
    TimeViewItem *other = (TimeViewItem *)i;
    switch ( col ) {
    case 1:
        if ( text(0).toInt() == other->text(0).toInt() )        // --
            return 0;
        else
            return text(0).toInt() < other->text(0).toInt() ? -1 : 1;
        break;
    default:
        // use default method for colum 0 and others added in the future
        return QListViewItem::compare( i, col, ascending );
    };
}
//------------------------------------------
