/*  KRunning - UITools.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Aug 12 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

 #include "UITools.h"

//
// Code for the icon list box
//

MainIconListBox::MainIconListBox( QWidget *parent, const char *name,
                                  WFlags f )
        :KListBox( parent, name, f ), mShowAll(false), mHeightValid(false),
        mWidthValid(false)
{
}


void MainIconListBox::updateMinimumHeight() {
    if( mShowAll == true && mHeightValid == false ){
        int h = frameWidth()*2;
        for( QListBoxItem *i = item(0); i != 0; i = i->next() ) {
            h += i->height( this );
        }
        setMinimumHeight( h );
        mHeightValid = true;
    }
}


void MainIconListBox::updateWidth() {
    if( mWidthValid == false ) {
        int maxWidth = 10;
        for( QListBoxItem *i = item(0); i != 0; i = i->next() ) {
            int w = ((MainIconListItem *)i)->width(this);
            maxWidth = QMAX( w, maxWidth );
        }

        for( QListBoxItem *i = item(0); i != 0; i = i->next() ){
            ((MainIconListItem *)i)->expandMinimumWidth( maxWidth );
        }

        if( verticalScrollBar()->isVisible() )  {
            maxWidth += verticalScrollBar()->sizeHint().width();
        }

        setFixedWidth( maxWidth + frameWidth()*2 );
        mWidthValid = true;
    }
}


void MainIconListBox::invalidateHeight() {
    mHeightValid = false;
}


void MainIconListBox::invalidateWidth() {
    mWidthValid = false;
}


void MainIconListBox::setShowAll( bool showAll ) {
    mShowAll = showAll;
    mHeightValid = false;
}



MainIconListItem::MainIconListItem( QListBox *listbox, const QPixmap &pixmap,
                                    const QString &text,int idx )
        : QListBoxItem( listbox )
{
    mPixmap = pixmap;
    if( mPixmap.isNull() == true )
    {
        mPixmap = defaultPixmap();
    }
    setText( text );
    mMinimumWidth = 0;
    index=idx;
}

int MainIconListItem::getIndex() {
    return index;
}


int MainIconListItem::expandMinimumWidth( int width ) {
    mMinimumWidth = QMAX( mMinimumWidth, width );
    return( mMinimumWidth );
}


const QPixmap &MainIconListItem::defaultPixmap() {
    static QPixmap *pix=0;
    if( pix == 0 )
    {
        pix = new QPixmap( 32, 32 );
        QPainter p( pix );
        p.eraseRect( 0, 0, pix->width(), pix->height() );
        p.setPen( Qt::red );
        QFont font( "Helvetica", 6 );
        p.setFont( font );
        QFontMetrics fm = p.fontMetrics();
        p.drawText((pix->width()-fm.width("No"))/2, 14,"No");
        p.drawText((pix->width()-fm.width("Icon"))/2, pix->height()-fm.height(),"Icon");
        p.drawRect ( 0, 0, pix->width(), pix->height() );
        p.end();

        /*   QBitmap mask( pix->width(), pix->height(), true );
           mask.fill( Qt::black );
           p.begin( &mask );
           p.setPen( Qt::white );
           p.drawRect ( 0, 0, pix->width(), pix->height() );
           p.end();*/

        //        pix->setMask( mask );
    }
    return( *pix );
}


void MainIconListItem::paint( QPainter *painter ) {
    QFontMetrics fm = painter->fontMetrics();
    int wt = fm.boundingRect(text()).width();
    int wp = mPixmap.width();
    // int ht = fm.lineSpacing();
    int hp = mPixmap.height();
    int lbw = width(listBox())/2;

    painter->drawPixmap( (mMinimumWidth-wp)/2, 5, mPixmap );
    if( text().isEmpty() == false ) {
        // painter->drawText( 0, hp+7, mMinimumWidth, ht, Qt::AlignCenter, text() );
        painter->drawText( (lbw-wt/2), hp+20,  text(), Qt::AlignCenter );
    }
}

int MainIconListItem::height( const QListBox *lb ) const {
    if( text().isEmpty() == true )   {
        return( mPixmap.height() );
    }
    else {
        return( mPixmap.height() + lb->fontMetrics().lineSpacing()+10 );
    }
}


int MainIconListItem::width( const QListBox *lb ) const {
    int wt = lb->fontMetrics().boundingRect(text()).width()+10;
    int wp = mPixmap.width() + 10;
    int w  = QMAX( wt, wp );
    return( QMAX( w, mMinimumWidth ) );
}

