/*  KRunning - krunningdoc.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef KRUNNINGDOC_H
#define KRUNNINGDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>

// include files for KDE
#include <kurl.h>

// forward declaration of the KRunning classes
class KRunningView;

/**	KRunningDoc provides a document object for a document-view model.
  *
  * The KRunningDoc class provides a document object that can be used in conjunction with the classes KRunningApp and KRunningView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KRunningApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KRunningView objects. Also, KRunningDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KRunningDoc : public QObject
{
        Q_OBJECT
    public:
        /** Constructor for the fileclass of the application */
        KRunningDoc(QWidget *parent, const char *name=0);
        /** Destructor for the fileclass of the application */
        ~KRunningDoc();

        /** adds a view to the document which represents the document contents. Usually this is your main view. */
        void addView(KRunningView *view);
        /** removes a view from the list of currently connected views */
        void removeView(KRunningView *view);
        /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
        void setModified(bool _m=true){ modified=_m; };
        /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
        bool isModified(){ return modified; };
        /** "save modified" - asks the user for saving if the document is modified */
        bool saveModified();
        /** deletes the document's contents */
        void deleteContents();
        /** initializes the document generally */
        bool newDocument();
        /** closes the acutal document */
        void closeDocument();
        /** loads the document by filename and format and emits the updateViews() signal */
        bool openDocument(const KURL& url, const char *format=0);
        /** saves the document under filename and format.*/
        bool saveDocument(const KURL& url, const char *format=0);
        /** returns the KURL of the document */
        const KURL& URL() const;
        /** sets the URL of the document */
        void setURL(const KURL& url);

    public slots:
        /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
         * As this view normally repaints itself, it is excluded from the paintEvent.
         */
        void slotUpdateAllViews(KRunningView *sender);

    public:
        /** the list of the views currently connected to the document */
        static QPtrList<KRunningView> *pViewList;

    private:
        /** the modified flag of the current document */
        bool modified;
        KURL doc_url;
};

#endif // KRUNNINGDOC_H
