/*  KRunning - krunningview.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mon Mai  6 11:16:42 CEST 2002 write to scherfa@web.de if you found a bug.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <kcombobox.h>
#include <qvbox.h>
// application specific includes
#include "krunningview.h"
#include "krunningdoc.h"
#include "krunning.h"

// DEBUG
#include <iostream>

using namespace std;

static const char * mainOptionNames [] [3]={
            { I18N_NOOP("Edit Events"),"contents.png"},
            { I18N_NOOP("Edit Teams"),"teamedit.png"},
            { I18N_NOOP("Edit Runners"),"runneredit.png"},
            { I18N_NOOP("Time count"),"timecount.png"},
            //       { I18N_NOOP("Time count"),"clock"},
            { I18N_NOOP("Edit Positions"),"positioncontrol.png"},
            { I18N_NOOP("Evaluation"),"evaluate.png"},
            { I18N_NOOP("Show Results"),"results.png"},
            { I18N_NOOP("Certifications"),"printer.png"}
        };

static const int optionNamesSize = sizeof (mainOptionNames) / sizeof (mainOptionNames[0]);



KRunningView::KRunningView(QWidget *parent, const char *name) : QWidget(parent, name)
{
    setBackgroundMode(PaletteBase);
    initMainWindow();
}

KRunningView::~KRunningView() {
    delete (teamEditWidget);
    delete(runnerEditWidget);
    delete(timeCountWidget);
    delete(eventViewWidget );
    delete(showRunnerWidget);
    delete(positionControlWidget );
    delete(evaluationWidget);
    delete(certificationWidget);
}



void KRunningView::initMainWindow() {
    mainGridLayout = new QGridLayout( this, 1,2 );
    mainGridLayout->setColStretch(0,0);
    mainGridLayout->setColStretch(1,1);
    mainIconBox = new MainIconListBox(this,"modules");

    QFont listFont( mainIconBox->font() );
    listFont.setBold( true );
    mainIconBox->setFont( listFont );
    mainIconBox->verticalScrollBar()->installEventFilter( this );

    //    QPixmap pm("/home/scherfa/rl38-006.jpg","JPEG",0);
    //    mainIconBox->setPaletteBackgroundPixmap(pm);
    mainContentWidget = new QWidgetStack(this,"contentStack");
    mainGridLayout->addWidget( mainIconBox,0,0 );
    mainGridLayout->addWidget( mainContentWidget,0,1 );

    teamEditWidget = new TeamEdit (this,"Team");
    runnerEditWidget = new RunnerEdit (this,"Runner");
    timeCountWidget = new Time( this,"TimeCount");
    eventViewWidget = new EventView (this,"EventView");
    createConnections(eventViewWidget); // The Connection that updates the toolbar -> events

    showRunnerWidget = new ShowRunner (this,"ShowRunner");
    positionControlWidget = new PositionControl (this,"PositionControl");
    evaluationWidget = new Evaluation(this,"Evaluation");
    certificationWidget = new Certification(this,"Certification");
    mainContentWidget->addWidget(eventViewWidget,eventViewWidgetId);
    mainContentWidget->addWidget(teamEditWidget,teamEditWidgetId);
    mainContentWidget->addWidget(runnerEditWidget,runnerEditWidgetId);
    mainContentWidget->addWidget(timeCountWidget, timeCountWidgetId);
    mainContentWidget->addWidget(positionControlWidget,positionControlWidgetId);
    mainContentWidget->addWidget(showRunnerWidget,showRunnerWidgetId);
    mainContentWidget->addWidget(evaluationWidget,evaluationWidgetId);
    mainContentWidget->addWidget(certificationWidget,certificationWidgetId);

    //    if (mainEventCombo->count() < 1) {
    // if No Event is Created wer could bind the times to events ... (disable)     A Function would be better (to turn on off)
    //    timeCountWidget->setEnabled(FALSE);
    //  }
    addOptionsToIconView();
    connect((QObject *)mainIconBox,SIGNAL(executed(QListBoxItem*)),this,SLOT(onSelectModule(QListBoxItem*)));
    //  connect((QObject *)mainGridLayout,SIGNAL(resize()),this,SLOT(widgetResized()));
}

void KRunningView::setEnabled (bool enabled) {
    mainIconBox->setEnabled(enabled);
    mainContentWidget->setEnabled(enabled);
}

void KRunningView::slotFillEventToolBar() {
    KRunningApp *theApp=(KRunningApp *) parentWidget();
    theApp->toolBar("mainToolBar")->getCombo(0)->clear();
    theApp->toolBar("mainToolBar")->getCombo(0)->insertStringList (g_pMainUseCase->getConnection()->getEventNameList());
#ifdef DEBUG
    std::cout << "event :" << theApp->toolBar("mainToolBar")->getCombo(0)->currentText() << std::endl;
#endif
    g_pMainUseCase->setCurrentEvent(theApp->toolBar("mainToolBar")->getCombo(0)->currentText()); // To ensure that the selected event is stored.
}

void KRunningView::createConnections( EventView *e ) {
    connect( e, SIGNAL( newEventCreated( ) ),
             this, SLOT( slotFillEventToolBar()) );
}


void KRunningView::addOptionsToIconView() {
    MainIconListItem* item=0;
    for (int i=0;i<optionNamesSize;i++) {
        item=new MainIconListItem(mainIconBox, QPixmap(KGlobal::dirs()->findResourceDir("pictures", mainOptionNames [i][1])+mainOptionNames [i][1]),tr( mainOptionNames [i][0]),i);
        //item = new   MainIconListItem(mainIconBox, KGlobal::iconLoader()->loadIcon(  mainOptionNames [i][1], KIcon::NoGroup, KIcon::SizeMedium) ,tr( mainOptionNames [i][0]),i);
    }
    mainIconBox->invalidateHeight();
    mainIconBox->invalidateWidth();
    mainIconBox-> updateWidth();
}

void KRunningView::dbDisconnected() {
    if ( mainContentWidget->visibleWidget()!=0) {

    }
}

void KRunningView::globalEventChanged() {
    if ( mainContentWidget->visibleWidget()!=0) {
        switch (mainContentWidget->id(  mainContentWidget->visibleWidget())) {
        case  timeCountWidgetId:   // TimeCount Widget
            ((Time *)mainContentWidget->widget( timeCountWidgetId))->setDefaultSettings();
            break;
        case showRunnerWidgetId: // ShowRunner Widget
            // Call a funktion to redraw the main View
            ((ShowRunner *)mainContentWidget->widget(showRunnerWidgetId))->setDefaultSettings();
            break;
        case  positionControlWidgetId: // PositionControlWidget
            ((PositionControl *)mainContentWidget->widget(positionControlWidgetId))->setDefaultSettings();
            break;
        case evaluationWidgetId: // EvaluationWidget
            ((Evaluation *)mainContentWidget->widget(evaluationWidgetId))->setDefaultSettings();
            break;
        case certificationWidgetId: // CertificationWidget
            ((Certification *)mainContentWidget->widget(certificationWidgetId))->setDefaultSettings();
            break;
        default:
            break;
        }
    }
}


void KRunningView::onSelectModule( QListBoxItem *item )
{
    if (!item) return;

    int index = ((MainIconListItem *)item)->getIndex();
    if (index<0) return;
    switch (index) {
    case eventViewWidgetId:   // Event View Widget
        mainContentWidget->raiseWidget(eventViewWidgetId);
        ((EventView *)mainContentWidget->widget(eventViewWidgetId))->setDefaultSettings();
        mainContentWidget->widget(eventViewWidgetId)->updateGeometry();
        break;
    case teamEditWidgetId: // TeamEdit Widget
        mainContentWidget->raiseWidget(teamEditWidgetId);
        ((TeamEdit *)mainContentWidget->widget(teamEditWidgetId))->setDefaultSettings();
        mainContentWidget->widget(teamEditWidgetId)->updateGeometry();
        mainContentWidget->widget(teamEditWidgetId)->polish();
        break;
    case runnerEditWidgetId: // RunnerEdit Widget
        mainContentWidget->raiseWidget(runnerEditWidgetId);
        ((RunnerEdit *)mainContentWidget->widget(runnerEditWidgetId))->setDefaultSettings();
        mainContentWidget->widget(runnerEditWidgetId)->updateGeometry();
        break;
    case  timeCountWidgetId:  // TimeCount Widget
        mainContentWidget->raiseWidget( timeCountWidgetId);
        ((Time *)mainContentWidget->widget( timeCountWidgetId))->setDefaultSettings();
        mainContentWidget->widget( timeCountWidgetId)->updateGeometry();
        break;
    case positionControlWidgetId: // PositionControl Widget
        mainContentWidget->raiseWidget(positionControlWidgetId);
        ((PositionControl *)mainContentWidget->widget(positionControlWidgetId))->setDefaultSettings();
        mainContentWidget->widget(positionControlWidgetId)->updateGeometry();
        break;
    case showRunnerWidgetId: // ShowRunner Widget
        mainContentWidget->raiseWidget(showRunnerWidgetId);
        ((ShowRunner *)mainContentWidget->widget(showRunnerWidgetId))->setDefaultSettings();
        mainContentWidget->widget(showRunnerWidgetId)->updateGeometry();
        break;
    case evaluationWidgetId: // EvaluationWidget
        mainContentWidget->raiseWidget(evaluationWidgetId);
        ((Evaluation *)mainContentWidget->widget(evaluationWidgetId))->setDefaultSettings();
        mainContentWidget->widget(evaluationWidgetId)->updateGeometry();
        break;
    case certificationWidgetId: // CertificationWidget
        mainContentWidget->raiseWidget(certificationWidgetId);
        ((Certification *)mainContentWidget->widget(certificationWidgetId))->setDefaultSettings();
        mainContentWidget->widget(certificationWidgetId)->updateGeometry();
        break;
    default:
        break;
    }
}


KRunningDoc *KRunningView::getDocument() const
{
    KRunningApp *theApp=(KRunningApp *) parentWidget();

    return theApp->getDocument();
}

void KRunningView::print(KPrinter *pPrinter)
{
    /* QPainter printpainter;
     printpainter.begin(pPrinter);*/
    switch (mainContentWidget->id(mainContentWidget->visibleWidget())) {
    case teamEditWidgetId:
        ((TeamEdit *)mainContentWidget->widget(teamEditWidgetId))->print(pPrinter);
        break;
    case showRunnerWidgetId:
        ((ShowRunner *) mainContentWidget->widget(showRunnerWidgetId))->print(pPrinter);
        break;
    case evaluationWidgetId:
        ((Evaluation *)mainContentWidget->widget(evaluationWidgetId))->print(pPrinter);
        break;
    case certificationWidgetId:
        ((Certification *)mainContentWidget->widget(certificationWidgetId))->print(pPrinter);
        break;
    default:
        KMessageBox::sorry(this,i18n("Sorry, printing not yet implemented for this function."),i18n("Sorry"));
        break;
    }
    // TODO: add your printing code here
}

void KRunningView::exportFile(const char * format) {
    KURL url;
    switch (mainContentWidget->id(mainContentWidget->visibleWidget())) {
    case showRunnerWidgetId:
        url=KFileDialog::getSaveURL(QDir::currentDirPath(), i18n("text/html"), this, i18n("Save as..."));
        if(!url.isEmpty())    {
            ((ShowRunner *) mainContentWidget->widget(showRunnerWidgetId))->exportFile(url,format);
        }
        break;
    default:
        KMessageBox::sorry(this,i18n("Sorry, exporting not yet implemented for this function."),i18n("Sorry"));
        break;
    }
}
