# Macro to add for using sane + kscan libraries!
# @author@: Jrgen Vigna

AC_DEFUN(CHECK_WITH_SANE,
[
	AC_MSG_CHECKING([for sane support])
	USE_SANE="yes"
    AC_ARG_WITH(sane,
      [  --without-sane          don't include scanner support],[
        if test "$withval" != "yes"; then
          USE_SANE="no"
        fi
      ])

    if test "$USE_SANE" = "yes"; then
		AC_FIND_FILE(kscan.h, $ac_kde_includes, ac_kscan_includes)
		kscan_includes="-I$ac_kscan_includes"

		AC_FIND_FILE(libkscan.so, $ac_kde_libraries, ac_kscan_libraries)
		if test -z "$ac_kscan_libraries" || test ! -r "$ac_kscan_libraries/libkscan.so";then
			AC_FIND_FILE(libkscan.a, $ac_kde_libraries, ac_kscan_libraries)
			if test -n "$ac_kscan_libraries" && test -r "$ac_kscan_libraries/libkscan.a";then
				kscan_library="-lkscan"
			fi
		else
			kscan_library="-lkscan"
		fi

		sane_incdirs="/usr/include/sane /usr/local/include/sane /usr/include"
		AC_FIND_FILE(sane.h, $sane_incdirs, ac_sane_includes)
		sane_includes="-I$ac_sane_includes"
		sane_libdir=""

		if test -n "$ac_sane_includes" && test -r "$ac_sane_includes/sane.h" \
		&& test -n "$ac_kscan_includes" && test -r "$ac_kscan_includes/kscan.h" \
		&& test -n "$kscan_library"; then
			AC_SUBST(sane_includes)
			sane_libdirs="/usr/lib /usr/local/lib /usr/lib/sane /usr/local/lib/sane"
			for dir in $sane_libdirs; do
				try="ls -1 $dir/libsane.*"
				if test -n "`$try 2> /dev/null`"; then sane_libdir=$dir; break; fi
			done
		fi

		if test -n "$sane_libdir"; then
			SANE_LDFLAGS="-L$sane_libdir"
			AC_SUBST(SANE_LDFLAGS)
			LIB_SANE="-lsane"
			AC_SUBST(LIB_SANE)
			LIB_KSCAN="-lkscan"
			AC_SUBST(LIB_KSCAN)
			AC_MSG_RESULT([yes])
			AC_DEFINE_UNQUOTED(HAVE_SANE, 1, [Defines if your system has the sane libraries])
		else
			AC_MSG_RESULT([something missing -- buildin scanner support disabled])
		fi
	else
		AC_MSG_RESULT([disabled])
	fi
])
