#!/bin/sh
#
if [ "$1" = "-p" ]
then
	nopatch="yes"
	shift
fi
hname=`basename $1 .ui`.h
cname=`basename $1 .ui`.cpp
uic -o $hname $1
uic -i $hname -o $cname $1
sed	-e 's/tr( "" )/""/g' -e 's/Created: .*/Created: /g' < $cname  > tmp_$cname
mv tmp_$cname $cname
sed	-e 's/Created: .*/Created: /g' < $hname  > tmp_$hname
mv tmp_$hname $hname
if [ "$nopatch" != "yes" ]
then
	if [ -f ${cname}.patch ]
	then
		echo "Applying patch ${cname}.patch"
		patch --no-backup-if-mismatch -p0 <${cname}.patch >/dev/null
	fi
	if [ -f ${hname}.patch ]
	then
		echo "Applying patch ${hname}.patch"
		patch --no-backup-if-mismatch -p0 <${hname}.patch >/dev/null
	fi
fi
