/***************************************************************************
                          formedit.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2000 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>
#include <keditcl.h>
#include <kfiledialog.h>
#include <kstddirs.h>
#include <ktempfile.h>

#include "formedit.h"

#define Inherited FormEditData

extern QString debugFlag;

FormEdit::FormEdit(QWidget * parent, const char * name, bool modal, WFlags fl)
	:Inherited(parent, name, modal, fl)
{
	if (name)
		setCaption(name);

	QFont wkedit_font(wkedit->font());
    wkedit_font.setFamily("courier");
    wkedit_font.setPointSize(12);
    wkedit->setFont(wkedit_font); 

	KConfig * conf = kapp->config();
	
	QString logdir = conf->readEntry("log_directory");
	if (logdir.isEmpty()) {
		KStandardDirs ksd;
		logdir = ksd.findResourceDir("tmp","");
		if (logdir.isEmpty())
			logdir = "/tmp";
	}
	QFileInfo fi2(logdir + "/ksfedit");
	KTempFile * ktf2 = new KTempFile(fi2.absFilePath(), "tmp");
	ktf2->setAutoDelete(true);
	tmpWorkDir.setPath(ktf2->name());
	delete ktf2;
	if (!tmpWorkDir.mkdir(tmpWorkDir.absPath()))
		QMessageBox::critical(this,"KSendFax","Cannot create temporary directory");
}


FormEdit::~FormEdit()
{
	if (!debugFlag.isEmpty())
		printf("%s\n", tmpWorkDir.absPath().data());
	if (!tmpWorkDir.rmdir(tmpWorkDir.absPath())) {
		const QFileInfoList * list = tmpWorkDir.entryInfoList();
		QFileInfoListIterator it(*list);      // create list iterator
		QFileInfo * fi;                       // pointer for traversing
		QString fname;

		while ((fi=it.current())) {           // for each file...
			fname = tmpWorkDir.absPath() + "/" + fi->fileName();
			tmpWorkDir.remove(fname);
			if (!debugFlag.isEmpty())
				printf( "%s\n", fname.data());
			++it;                             // goto next list element
		}
		tmpWorkDir.rmdir(tmpWorkDir.absPath());
	}
}

void FormEdit::load(QString const filename)
{
    wkedit->clear();
	tmpfile = filename;
	if (filename.isEmpty()) {
		createTmpFile();
		return;
	}
	QFile f(tmpfile);
    if (!f.open(IO_ReadOnly)) {
		createTmpFile();
        return;
	}
    QTextStream t(&f);
	wkedit->insertText(&t);
    f.close();
}

QString const FormEdit::fileName() const
{
	return tmpfile;
}

void FormEdit::selectFont()
{
	wkedit->selectFont();
}

void FormEdit::okCB()
{
	QFile f(tmpfile);
	if (!f.open( IO_ReadWrite)) {
		QString str;
		str.sprintf("Cannot open %s for write",tmpfile.data());
		QMessageBox::critical(this,"KSendFax",str);
		return;
	}
	QTextStream t(&f);
	wkedit->saveText(&t);
	f.close();
	accept();
}

void FormEdit::replace()
{
	wkedit->replace();
}

void FormEdit::saveas()
{
	KConfig * conf = kapp->config();
	
	QString appdir = conf->readEntry("scanner_workdir");
	if (appdir.isEmpty()) {
		KStandardDirs ksd;
		appdir =  ksd.saveLocation("data", "ksendfax");
	}
	QDir workdir;
	workdir.setPath(appdir);
	QString fname = KFileDialog::getSaveFileName(
		workdir.absPath(),".txt", this, i18n("Save as textfile"));
	if (fname.isNull())   /* cancelled */
		return;

	QFile f(fname);
	if (!f.open( IO_ReadWrite)) {
		QString str;
		str.sprintf("Cannot open %s for write",fname.data());
		QMessageBox::critical(this,"KSendFax",str);
		return;
	}
	QTextStream t(&f);
	wkedit->saveText(&t);
	f.close();
	tmpfile = fname;
	buttonSave->setEnabled(true);
}


void FormEdit::createTmpFile()
{
	KTempFile ktf(tmpWorkDir.absPath() + "/file", ".txt");
	tmpfile = ktf.name();
}


int FormEdit::exec()
{
	if (tmpfile.isEmpty()) {
		wkedit->clear();
		createTmpFile();
	}
	QFile f(tmpfile);
	if (!f.open( IO_ReadWrite)) {
		buttonSave->setEnabled(false);
	}
	f.close();
	return QDialog::exec();
}

void FormEdit::removeTmpFile()
{
	tmpWorkDir.remove(tmpfile);
	tmpfile = QString();
}

void FormEdit::init()
{
	tmpfile = QString();
	wkedit->clear();
}
