/***************************************************************************
                          helpers.cpp  -  description
                             -------------------
    begin                : Tue Nov 20 10:39:00 MET 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <cstdio>

#include <locale.h>
#include <time.h>

#include <qstring.h>
#include <qfile.h>
#include <qstringlist.h>
#include <qtextstream.h>
#include <qregexp.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

#include "prefstate.h"
#include "helpers.h"

extern QString debugFlag;

using std::vector;

QString const Helpers::getActualDate()
{
	char str[255];
	QString fmt = kapp->config()->readEntry("date_format");
	QString ret;
	struct tm tm;
	time_t time_value;

	if (fmt.isEmpty())
		fmt = "%a %b %d %T %Y";
	(void)time(&time_value);
	(void)setlocale(LC_TIME, "");
	tm = *localtime(&time_value);
	if ((int)strftime(str, 255, fmt.data(), &tm))
		ret = str;
	return ret;
}


void Helpers::removeTempFiles(const QStringList & filenames)
{
	if (filenames.isEmpty())
		return;

	QStringList::ConstIterator it;

	for(it = filenames.begin(); it != filenames.end(); ++it) {
		if (!debugFlag.isEmpty())
			fprintf(stderr, "RM: %s\n", (*it).data());
		remove((*it).data());
	}
}


void Helpers::filters_load(vector<PrefFiltersState::Filters> & filters)
{
	QFile	f(locate("data","ksendfax/faxfilters"));
	if (f.exists() && f.open(IO_ReadOnly))
	{
		QTextStream	t(&f);
		QString line;
		int p = -1;
		PrefFiltersState::Filters item;
		
		while (!t.eof()) {
			line = t.readLine().stripWhiteSpace();
			if ((p=line.find(QRegExp("\\s"))) != -1) {
				item.mimetype = line.left(p);
				item.mimecmd = line.right(line.length()-p-1).stripWhiteSpace();
				if (!item.mimetype.isEmpty() && !item.mimecmd.isEmpty())
					filters.push_back(item);
			}
		}
	}
}


void Helpers::filters_save(vector<PrefFiltersState::Filters> const & filters)
{
	QFile f(locateLocal("data","ksendfax/faxfilters"));
	if (f.open(IO_WriteOnly)) {
		QTextStream	t(&f);
		vector<PrefFiltersState::Filters>::const_iterator it;
		for(it = filters.begin(); it != filters.end(); ++it) {
			t << (*it).mimetype << ' ' << (*it).mimecmd << endl;
		}
	}
}


void Helpers::special_exclude_load(QStringList & exlist)
{
	QFile	f(locate("data","ksendfax/convert_exclude"));
	if (f.exists() && f.open(IO_ReadOnly)) {
		QTextStream	t(&f);
		QString line;

		while (!t.eof()) {
			line = t.readLine().stripWhiteSpace();
			if (!line.isEmpty())
				exlist.append(line);
		}
	}
}


void Helpers::special_exclude_save(QStringList const & exlist)
{
	QFile f(locateLocal("data","ksendfax/convert_exclude"));
	if (f.open(IO_WriteOnly)) {
		QTextStream	t(&f);
		QStringList::ConstIterator it;
		for(it = exlist.begin(); it != exlist.end(); ++it) {
			t << (*it) << endl;
		}
	}
}

void Helpers::special_always_load(QStringList & allist)
{
	QFile	f(locate("data","ksendfax/convert_always"));
	if (f.exists() && f.open(IO_ReadOnly)) {
		QTextStream	t(&f);
		QString line;
		
		while (!t.eof()) {
			line = t.readLine().stripWhiteSpace();
			if (!line.isEmpty())
				allist.append(line);
		}
	}
}


void Helpers::special_always_save(QStringList const & allist)
{
	QFile f(locateLocal("data","ksendfax/convert_always"));
	if (f.open(IO_WriteOnly)) {
		QTextStream	t(&f);
		QStringList::ConstIterator it;
		for(it = allist.begin(); it != allist.end(); ++it) {
			t << (*it) << endl;
		}
	}
}


void Helpers::readConfig(PrefState & state, bool nocmd)
{
    KConfig *config = kapp->config();
    QString str;

    config->setGroup("ksendfax");
	///
	// Fax part
	///
	if (nocmd) {
		state.fax.sendcmd = config->readEntry("send_command");
		state.fax.showcmd = config->readEntry("show_command");
		state.fax.removecmd = config->readEntry("remove_command");
	} else {
		state.fax.sendcmd = config->readEntry("send_command",
		                                      state.fax.sendcmd);
		state.fax.showcmd = config->readEntry("show_command",
		                                      state.fax.showcmd);
		state.fax.removecmd = config->readEntry("remove_command",
		                                        state.fax.removecmd);
	}
	state.fax.updatesecs = config->readNumEntry("update_seconds",
												state.fax.updatesecs);
	state.fax.useps = config->readBoolEntry("convert_ps", state.fax.useps);
	state.fax.coverfile = config->readEntry("coverpage_file",
											state.fax.coverfile);
	///
	// general stuff
	///
	state.faxpackage = config->readEntry("fax_package", state.faxpackage);
	if (state.faxpackage.isEmpty()) {
		QString cmd = state.fax.sendcmd;
		int i;
		if ((i=cmd.find(' ')) >= 0)
			cmd = cmd.left(i);
		if ((i=cmd.findRev('/'))  >= 0)
			cmd = cmd.mid(i);
		if (cmd.left(8) == "faxspool")
			state.faxpackage = "MGetty";
		else if (cmd.left(3) == "fax" >= 0)
			state.faxpackage = "EFax";
		else {
			cmd = state.fax.showcmd;
			if ((i=str.find(' ')) >= 0)
				cmd = cmd.left(i);
			if ((i=cmd.findRev('/')) >= 0)
				cmd = cmd.mid(i);
			if (cmd.left(7) == "faxstat")
				state.faxpackage = "HylaFax";
			else if (!nocmd)
				state.faxpackage = "Other";
		}
	}
	///
	// special part
	///
	state.special.excludeps = config->readBoolEntry("convert_exclude",
													state.special.excludeps);
	state.special.alwaysps = config->readBoolEntry("convert_always",
												   state.special.alwaysps);
	special_exclude_load(state.special.exlist);
	special_always_load(state.special.allist);
	///
	// personal part
	///
	state.personal.name = config->readEntry("personal_name");
	state.personal.enterprise = config->readEntry("personal_enterprise");
	state.personal.phone = config->readEntry("personal_phone");
	///
	// scanner part
	///
#ifdef HAVE_SANE
	state.scanner.use_external = config->readBoolEntry("use_xsane",
													   state.scanner.use_external);
#else
	state.scanner.use_external = true;
#endif
	if (nocmd) {
		state.scanner.cmd = config->readEntry("xsane_command");
	} else {
		state.scanner.cmd = config->readEntry("xsane_command", state.scanner.cmd);
	}
	if (state.scanner.type == PrefScannerState::tiff)
		str = config->readEntry("scan_type", "tiff");
	else
		str = config->readEntry("scan_type", "ps");
	if (str == "tiff")
		state.scanner.type = PrefScannerState::tiff;
	else
		state.scanner.type = PrefScannerState::postscript;
	///
	// phonebook part
	///
#ifdef USE_KAB
	str = config->readEntry("phonebook_type");
	if (str == "kab")
		state.phonebook.type = PrefPhonebookState::kaddressbook;
	else if (str == "kaddressbook")
		state.phonebook.type = PrefPhonebookState::kaddressbook;
	else
		state.phonebook.type = PrefPhonebookState::ksendfax;
#else
	state.phonebook.type = PrefPhonebookState::ksendfax;
#endif
    state.phonebook.file = config->readEntry("phonebook",state.phonebook.file);
	///
	// misc part
	///
	str = config->readEntry("log_directory");
	if (!str.isEmpty())
		state.misc.logdir = str;
	if (nocmd) {
		state.misc.previewcmd = config->readEntry("preview_command");
	} else {
		state.misc.previewcmd = config->readEntry("preview_command",
		                                          state.misc.previewcmd);
	}
	str = config->readEntry("date_format");
	if (!str.isEmpty())
		state.misc.datefmt = str;
	str = config->readEntry("convert_command");
	if (!str.isEmpty())
		state.misc.convertcmd = str;
	///
	// filters part
	///
	filters_load(state.filters.filters);
}


bool Helpers::writeConfig(PrefState const & state)
{
	KConfig *config = kapp->config();

	config->setGroup("ksendfax");
	///
	// general part
	///
	config->writeEntry("fax_package", state.faxpackage);
	///
	// fax part
	///
	config->writeEntry("send_command", state.fax.sendcmd);
	config->writeEntry("show_command", state.fax.showcmd);
	config->writeEntry("remove_command", state.fax.removecmd);
	config->writeEntry("update_seconds", state.fax.updatesecs);
	config->writeEntry("convert_ps", state.fax.useps);
	config->writeEntry("coverpage_file", state.fax.coverfile);
	///
	// special part
	///
	config->writeEntry("convert_exclude", state.special.excludeps);
	config->writeEntry("convert_always", state.special.alwaysps);
	special_exclude_save(state.special.exlist);
	special_always_save(state.special.allist);
	///
	// personal part
	///
	config->writeEntry("personal_name", state.personal.name);
	config->writeEntry("personal_enterprise", state.personal.enterprise);
	config->writeEntry("personal_phone", state.personal.phone);
	///
	// scanner part
	///
#ifdef HAVE_SANE
	config->writeEntry("use_xsane", state.scanner.use_external);
#endif
	config->writeEntry("xsane_command", state.scanner.cmd);
	switch(state.scanner.type) {
	case PrefScannerState::tiff:
		config->writeEntry("scan_type", "tiff");
		break;
	case PrefScannerState::postscript:
	default:
		config->writeEntry("scan_type", "ps");
		break;
	}
	///
	// phonebook part
	///
	bool pbchanged = false;

#ifdef USE_KAB
	QString str = config->readEntry("phonebook_type");
	switch (state.phonebook.type) {
	case PrefPhonebookState::kaddressbook:
		config->writeEntry("phonebook_type", "kaddressbook");
		pbchanged = (str != "kaddressbook") && (str != "kab");
		break;
	case PrefPhonebookState::ksendfax:
	default:
		config->writeEntry("phonebook_type", "ksendfax");
		pbchanged = (str != "ksendfax");
		break;
	}
#endif
	pbchanged = pbchanged ||
		(state.phonebook.file != config->readEntry("phonebook"));
	config->writeEntry("phonebook", state.phonebook.file);
	///
	// misc part
	///
	config->writeEntry("log_directory", state.misc.logdir);
	config->writeEntry("preview_command", state.misc.previewcmd);
	config->writeEntry("date_format", state.misc.datefmt);
	config->writeEntry("convert_command", state.misc.convertcmd);
	///
	// filters part
	///
	filters_save(state.filters.filters);
	
	config->sync();
	
	return pbchanged;
}


QString const Helpers::findProgram(const QString & name, bool asdesc)
{
	if (name.left(1) == "/" && QFile::exists(name)) {
		if (asdesc)
			return name + "..." + i18n("found");
		return name;
	}
	
	QString complete_path = getenv("PATH");
	QStringList paths = QStringList::split (":", complete_path, false);
	for (QStringList::Iterator it = paths.begin(); it != paths.end(); ++it) {
		if (QFile::exists((*it) + "/" + name)) {
			QString file = (*it) + "/" + name;
			if (asdesc)
				return name + " ... " + file;
			return file;
		}
	}
	if (asdesc)
		return name + " ... " + i18n("not found");
	
	return QString();
}
