/***************************************************************************
                          ksendfax.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlayout.h>

// include files for KDE
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kio/netaccess.h>
#include <kstatusbar.h>

// application specific includes
#include "ksendfax.h"
#include "ksendfaxview.h"
#include "preferences.h"

#define ID_STATUS_MSG 1

KSendFaxApp::KSendFaxApp(QWidget* , const char* name)
		: KMainWindow(0, name)
{
	config=kapp->config();

	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	initStatusBar();
	initActions();
	initView();
	readOptions();
	toolBar()->show();

	preferences = new Preferences(topLevelWidget(), 0, false);
	connect(preferences, SIGNAL(PBChanged()),this, SLOT(slotPbReload()));

	///////////////////////////////////////////////////////////////////
	// disable actions at startup
	//fileSendFax->setEnabled(false);
	showFileList->setChecked(view->showFL);
	pbShow->setChecked(view->showPB);
	if (view->pbType() != "ksendfax") {
		pbAdd->setEnabled(false);
		pbModify->setEnabled(false);
		pbRemove->setEnabled(false);
		pbSave->setEnabled(false);
	} else {
		pbEdit->setEnabled(false);
	}
	
	slotPbShow();
}

KSendFaxApp::~KSendFaxApp()
{
	delete preferences;
	delete view;
}

void KSendFaxApp::initActions()
{
	// File Menu
	fileSendFax = new KAction(i18n("&Send Fax"), "faxsend", 0, this,
		SLOT(slotFileSendFax()), actionCollection(), "file_send_fax");
	fileShowJobs = new KAction(i18n("Show &Jobs"), "faxshow", 0, this,
		SLOT(slotFileShowJobs()), actionCollection(), "file_show_jobs");
	fileRemoveJob = new KAction(i18n("&Remove Job"), "faxremove", 0, this,
		SLOT(slotFileRemoveJob()), actionCollection(), "file_remove_job");
	fileScanDoc = new KAction(i18n("&Scan Document"), "scandoc", 0, this,
		SLOT(slotFileScanDoc()), actionCollection(), "file_scan_doc");
	filePreviewDoc = new KAction(i18n("&Preview Document"), "previewdoc", 0,
		this, SLOT(slotFilePreviewDoc()), actionCollection(),
		"file_preview_doc");
	fileEditDoc = new KAction(i18n("&Edit Document"), "editdoc", 0,
		this, SLOT(slotFileEditDoc()), actionCollection(), "file_edit_doc");
	fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
	// Options Menu
	showPreferences = new KAction(i18n("&Preferences"), "preferences", 0, this,
		SLOT(slotShowPreferences()), actionCollection(), "show_preferences");
	showToolBar = KStdAction::showToolbar(this,
		SLOT(slotShowToolBar()), actionCollection());
	showStatusBar = KStdAction::showStatusbar(this,
		SLOT(slotShowStatusBar()), actionCollection());
	showFileList = new KToggleAction(i18n("&Show File List"), 0, this,
		SLOT(slotShowFileList()), actionCollection(), "show_file_list");

	// Phonebook Menu
	pbShow = new KToggleAction(i18n("Show &Phonebook"), "phonebook", 0, this,
		SLOT(slotPbShow()), actionCollection(), "pb_show");
	pbEdit = new KAction(i18n("&Edit Phonebook"), "pb_edit", 0, this,
		SLOT(slotPbEdit()), actionCollection(), "pb_edit");
	pbAdd = new KAction(i18n("&Add Entry"), "pb_add", 0, this,
		SLOT(slotPbAdd()), actionCollection(), "pb_add");
	pbModify = new KAction(i18n("&Modify Entry"), "pb_modify", 0, this,
		SLOT(slotPbModify()), actionCollection(), "pb_modify");
	pbRemove = new KAction(i18n("&Remove Entry"), "pb_remove", 0, this,
		SLOT(slotPbRemove()), actionCollection(), "pb_remove");
	pbSave = new KAction(i18n("&Save Phonebook"), "pb_save", 0, this,
		SLOT(slotPbSave()), actionCollection(), "pb_save");
	pbReload = new KAction(i18n("&Reload Phonebook"), "pb_reload", 0, this,
		SLOT(slotPbReload()), actionCollection(), "pb_reload");

	fileSendFax->setStatusText(i18n("Send the fax"));
	fileShowJobs->setStatusText(i18n("Show send queue"));
	fileRemoveJob->setStatusText(i18n("Remove a job from the queue"));
	fileScanDoc->setStatusText(i18n("Scan a new document"));
	filePreviewDoc->setStatusText(i18n("Preview the document"));
	fileEditDoc->setStatusText(i18n("Edit the document"));
	fileQuit->setStatusText(i18n("Quits the application"));

	showToolBar->setStatusText(i18n("Enables/disables the toolbar"));
	showStatusBar->setStatusText(i18n("Enables/disables the statusbar"));
	showFileList->setStatusText(i18n("Show/Hide the file list"));

	pbShow->setStatusText(i18n("Show/Hide the phonebook"));
	pbEdit->setStatusText(i18n("Edit the phonebook"));
	pbAdd->setStatusText(i18n("Add entry to phonebook"));
	pbModify->setStatusText(i18n("Modify entry in phonebook"));
	pbRemove->setStatusText(i18n("Remove entry from phonebook"));
	pbSave->setStatusText(i18n("Save phonebook"));
	pbReload->setStatusText(i18n("Reload phonebook"));

	// use the absolute path to your ksendfaxui.rc file for testing purpose
	// in createGUI();
	createGUI();
}


void KSendFaxApp::initStatusBar()
{
	///////////////////////////////////////////////////////////////////
	// STATUSBAR
	// TODO: add your own items you need for displaying application status.
	statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KSendFaxApp::initView()
{ 
	////////////////////////////////////////////////////////////////////
	// create the main widget here that is managed by KTMainWindow's
	// view-region and connect the widget to your document to display
	// document contents.

	view = new KSendFaxView(this);
	resize(view->sizeHint());
	setCentralWidget(view);	
	setCaption("KSendFax V" VERSION, false);
}

void KSendFaxApp::openDocumentFile(const QString & file)
{
	QFileInfo qfi(file);

	if (!qfi.exists()) { // we don't add it if it doesn't exist!
		slotStatusMsg(i18n("File does not exist!"));
		return;
	}
	
	slotStatusMsg(i18n("Opening file..."));
	view->setFileName(qfi.absFilePath());
	slotStatusMsg(i18n("Ready."));
}


void KSendFaxApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size());
	config->writeEntry("Show Toolbar", showToolBar->isChecked());
	config->writeEntry("Show Statusbar",showStatusBar->isChecked());
	config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
	view->saveOptions();
}


void KSendFaxApp::readOptions()
{
	config->setGroup("General Options");

	// bar status settings
	bool bShowToolbar = config->readBoolEntry("Show Toolbar", true);
	showToolBar->setChecked(bShowToolbar);
	slotShowToolBar();

	bool bShowStatusbar = config->readBoolEntry("Show Statusbar", true);
	showStatusBar->setChecked(bShowStatusbar);
	slotShowStatusBar();

	// bar position settings
	KToolBar::BarPosition toolBarPos;
	toolBarPos = (KToolBar::BarPosition)config->readNumEntry("ToolBarPos",
															 KToolBar::Top);
	toolBar("mainToolBar")->setBarPos(toolBarPos);
	
	QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty()) {
		resize(size);
	}
}


bool KSendFaxApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KSendFaxApp::slotFileSendFax()
{
	slotStatusMsg(i18n("Sending the actual document(s)..."));
	view->sendFax();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFileShowJobs()
{
	slotStatusMsg(i18n("Show actual send queue..."));
	view->showJobs();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFileRemoveJob()
{
	slotStatusMsg(i18n("Remove a already sent job..."));
	view->removeJob();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFileScanDoc()
{
	slotStatusMsg(i18n("Scan a new document ..."));
	view->scanDoc();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFilePreviewDoc()
{
	slotStatusMsg(i18n("Preview the document ..."));
	view->previewDoc();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFileEditDoc()
{
	slotStatusMsg(i18n("Edit the document ..."));
	view->editDoc();
	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotFileQuit()
{
	slotStatusMsg(i18n("Exiting..."));
	saveOptions();
	slotStatusMsg(i18n("Ready."));
	kapp->exit();
}

void KSendFaxApp::slotShowPreferences()
{
	if (!preferences->isVisible()) {
		preferences->restoreState();
		preferences->show();
	}
}

void KSendFaxApp::slotShowToolBar()
{
	slotStatusMsg(i18n("Toggling toolbar..."));

	// turn Toolbar on or off
	if(!showToolBar->isChecked()) {
		toolBar("mainToolBar")->hide();
	} else {
		toolBar("mainToolBar")->show();
	}

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotShowStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));

	//turn Statusbar on or off
	if(!showStatusBar->isChecked()) {
		statusBar()->hide();
	} else {
		statusBar()->show();
	}

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotShowFileList()
{
	slotStatusMsg(i18n("Toggle the file list..."));

	//turn Filelist on or off
	if (!view->showFileList(showFileList->isChecked()))
		;
#if 0
		showFileList->setChecked(!showFileList->isChecked());
#endif

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbShow()
{
	slotStatusMsg(i18n("Toggle the phonebook..."));

	//turn PhoneBook on or off
	if (!view->pbShow(pbShow->isChecked()))
		pbShow->setChecked(pbShow->isChecked());

	if (view->pbType() == "ksendfax") {
		pbAdd->setEnabled(view->showPB);
		pbModify->setEnabled(view->showPB);
		pbRemove->setEnabled(view->showPB);
		pbSave->setEnabled(view->showPB);
	}

	pbReload->setEnabled(view->showPB);

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbEdit()
{
	slotStatusMsg(i18n("Toggle the phonebook..."));

	(void)view->pbEdit();

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbAdd()
{
	slotStatusMsg(i18n("Add entry to phonebook..."));

	if (!view->pbAdd())
		KMessageBox::sorry(0, i18n("Couldn't add this entry to the phonebook"));

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbModify()
{
	slotStatusMsg(i18n("Modify entry in phonebook..."));

	if (!view->pbModify())
		KMessageBox::sorry(0, i18n("Couldn't modify this entry in the phonebook"));

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbRemove()
{
	slotStatusMsg(i18n("Remove entry from phonebook..."));

	if (!view->pbRemove())
		KMessageBox::sorry(0, i18n("Couldn't remove this entry from the phonebook"));

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbSave()
{
	slotStatusMsg(i18n("Saving the phonebook..."));

	if (!view->pbSave())
		KMessageBox::sorry(0, i18n("Couldn't save the phonebook"));

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotPbReload()
{
	slotStatusMsg(i18n("Reloading phonebook..."));

	if (!view->pbLoad())
		KMessageBox::sorry(0, i18n("Couldn't reload the phonebook"));

	if (view->pbType() == "ksendfax") {
		pbAdd->setEnabled(view->showPB);
		pbModify->setEnabled(view->showPB);
		pbRemove->setEnabled(view->showPB);
		pbSave->setEnabled(view->showPB);
		pbEdit->setEnabled(false);
	} else {
		pbAdd->setEnabled(false);
		pbModify->setEnabled(false);
		pbRemove->setEnabled(false);
		pbSave->setEnabled(false);
		pbEdit->setEnabled(true);
	}

	slotStatusMsg(i18n("Ready."));
}

void KSendFaxApp::slotStatusMsg(const QString &text)
{
	// change status message permanently
	statusBar()->clear();
	statusBar()->changeItem(text, ID_STATUS_MSG);
}
