/***************************************************************************
                          ksendfax.h  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSENDFAX_H
#define KSENDFAX_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>

// forward declaration of the KSendFax classes
class KSendFaxDoc;
class KSendFaxView;
class Preferences;

/**
 *  The base class for KSendFax application windows. It sets up the main
 *  window and reads the config file as well as providing a menubar, toolbar
 *  and statusbar. An instance of KSendFaxView creates your center view,
 *  which is connected to the window's Doc object.
 *  KSendFaxApp reimplements the methods that KMainWindow provides for
 *  main window handling and supports full session management as well as
 *  using KActions.
 *  @see KMainWindow
 *  @see KApplication
 *  @see KConfig
 *
 * @author Source Framework Automatically Generated by KDevelop,
 * (c) The KDevelop Team.
 * @version KDevelop version 1.2 code generation
 */
class KSendFaxApp : public KMainWindow
{
Q_OBJECT

friend class KSendFaxView;

  public:
	/** construtor of KSendFaxApp, calls all init functions to create the application.
	 */
	KSendFaxApp(QWidget* parent=0, const char* name=0);
	~KSendFaxApp();
	/** opens a file specified by commandline option
	 */
	void openDocumentFile(const QString & file);
	/** returns a pointer to the current document connected to the
	 *  KTMainWindow instance and is used by the View class to access
	 *  the document object's methods
	 */	
	KSendFaxDoc *getDocument() const; 	
	
  protected:
	/** save general Options like all bar positions and status as well as
	 *  the geometry and the recent file list to the configuration file
	 */ 	
	void saveOptions();
	/** read general Options again and initialize all variables like the
	 *  recent file list
	 */
	void readOptions();
	/** initializes the KActions of the application */
	void initActions();
	/** sets up the statusbar for the main window by initialzing a
	 *  statuslabel.
	 */
	void initStatusBar();
	/** initializes the document object of the main window that is
	 *  connected to the view in initView().
	 *  @see initView();
	 */
	void initDocument();
	/** creates the centerwidget of the KTMainWindow instance and sets
	 *  it as the view
	 */
	void initView();
	/** queryExit is called by KTMainWindow when the last window of the
	 *  application is going to be closed during the closeEvent().
	 *  Against the default implementation that just returns true, this
	 *  calls saveOptions() to save the settings of the last window's	
	 *  properties.
	 *  @see KTMainWindow#queryExit
	 *  @see KTMainWindow#closeEvent
	 */
	virtual bool queryExit();

  public slots:
	/** Send the actual document(s) to the selected fax
	 */
	void slotFileSendFax();
	/** show the send queue
	 */
	void slotFileShowJobs();
	/** remove a document from the send queue
	 */
	void slotFileRemoveJob();
	/** scan a new document
	 */
	void slotFileScanDoc();
	/** preview the document
	 */
	void slotFilePreviewDoc();
	/** edit the document
	 */
	void slotFileEditDoc();
	/** quit the program
	 */
	void slotFileQuit();
	/** shows the preferences dialog
	 */
	void slotShowPreferences();
	/** toggles the toolbar
	 */
	void slotShowToolBar();
	/** toggles the statusbar
	 */
	void slotShowStatusBar();
	/** toggles the file list
	 */
	void slotShowFileList();
	/** toggles the phonebook
	 */
	void slotPbShow();
	/** edit a kab-type phonebook
	 */
	void slotPbEdit();
	/** adds an entry to the phonebook
	 */
	void slotPbAdd();
	/** modifies an entry in the phonebook
	 */
	void slotPbModify();
	/** removes an entry from the phonebook
	 */
	void slotPbRemove();
	/** save the phonebook
	 */
	void slotPbSave();
	/** reload the phonebook
	 */
	void slotPbReload();
	/** changes the statusbar contents for the standard label permanently,
	 *  used to indicate current actions.
	 *  @param text the text that is displayed in the statusbar
	 */
	void slotStatusMsg(const QString &text);

  private:
	/** the configuration object of the application */
	KConfig *config;
	/** view is the main widget which represents your working area.
	 *  The View class should handle all events of the view widget.
	 *  It is kept empty so you can create your view according to your
	 *  application's needs by changing the view class.
	 */
	KSendFaxView *view;
	/** doc represents your actual document and is created only once.
	 *  It keeps information such as filename and does the serialization
	 *  of your files.
	 */
	KSendFaxDoc *doc;
	
	// KAction pointers to enable/disable actions
	KAction* fileSendFax;
	KAction* fileShowJobs;
	KAction* fileRemoveJob;
	KAction* fileScanDoc;
	KAction* filePreviewDoc;
	KAction* fileEditDoc;
	KAction* fileQuit;
	KToggleAction* showToolBar;
	KToggleAction* showStatusBar;
	KToggleAction* showFileList;
	KAction* showPreferences;
	KToggleAction* pbShow;
	KAction* pbEdit;
	KAction* pbAdd;
	KAction* pbModify;
	KAction* pbRemove;
	KAction* pbSave;
	KAction* pbReload;

	Preferences * preferences;
};
 
#endif // KSENDFAX_H
