/***************************************************************************
                          ksendfaxdlg.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qmessagebox.h>
#include <qsplitter.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <qtoolbutton.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kapp.h>
#include <kstddirs.h>

#include "ksendfaxdlg.h"
#include "dialogs/widgetfilename.h"
#include "dialogs/widgetfilelist.h"
#include "dialogs/widgetfaxdata.h"
#include "dialogs/widgetphonebook.h"

extern QString debugFlag;

/* 
 *  Constructs a KSendFaxDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KSendFaxDlg::KSendFaxDlg(bool showPhonebook, bool showFileList,
						 QWidget* parent,  const char* name, WFlags fl)
		: QWidget(parent, name, fl), wfilelist(0), wphonebook(0)
{
	QVBoxLayout * topLayout = new QVBoxLayout(this);

	viewSplitter = new QSplitter(this, "viewSplitter");
	viewSplitter->setOpaqueResize(true);
	viewSplitter->setOrientation(Qt::Vertical);
	viewSplitter->setFrameStyle(QFrame::Box | QFrame::Sunken);
	topLayout->addWidget(viewSplitter);
	
	QWidget * tmpwidget = new QWidget(viewSplitter);
	QVBoxLayout * layout = new QVBoxLayout(tmpwidget);
	if (showFileList) {
		wfilename = new WidgetFileName(tmpwidget);
		layout->addWidget(wfilename);
		wfilelist = new WidgetFileList(tmpwidget);
		layout->addWidget(wfilelist);
		wfaxdata = new WidgetFaxData(viewSplitter);
	} else {
		wfilename = new WidgetFileName(tmpwidget);
		layout->addWidget(wfilename);
		wfaxdata = new WidgetFaxData(tmpwidget);
		layout->addWidget(wfaxdata);
	}
	if (showPhonebook) {
		wphonebook = new WidgetPhonebook(viewSplitter);
#ifdef USE_KAB
		wphonebook->pbListView->addColumn(i18n("Key"));
#endif
		float w = wphonebook->pbListView->width() / 100;
		wphonebook->pbListView->setColumnWidth(0,(int)w*35);
		wphonebook->pbListView->setColumnWidth(1,(int)w*30);
		wphonebook->pbListView->setColumnWidth(2,(int)w*35);
	}
	QValueList<int> sizes = kapp->config()->readIntListEntry("ViewSplitter");
	viewSplitter->setSizes(sizes);

    // signals and slots connections
    connect(wfilename->browseButton, SIGNAL(clicked()), this,
	        SLOT(BrowseFileCB()));
	if (showFileList) {
		connect(wfilelist->buttonAddFile, SIGNAL(clicked()), this,
		        SLOT(AddFileCB()));
		connect(wfilelist->buttonRemoveFile, SIGNAL(clicked()), this,
		        SLOT(RemoveFileCB()));
		connect(wfilelist->buttonUpFile, SIGNAL(clicked()), this,
		        SLOT(moveFileUpCB()));
		connect(wfilelist->buttonDownFile, SIGNAL(clicked()), this,
		        SLOT(moveFileDownCB()));
//		connect(wfilelist->listboxFileNames, SIGNAL(clicked(QListBoxItem *)),
//		        this, SLOT(selectionInFileList(QListBoxItem *)));
		connect(wfilelist->listboxFileNames, SIGNAL(selected(QListBoxItem *)),
		        this, SLOT(selectionInFileList(QListBoxItem *)));
		connect(wfilelist->listboxFileNames, SIGNAL(currentChanged(QListBoxItem *)),
		        this, SLOT(selectionInFileList(QListBoxItem *)));
		currentFLItem = 0;
	}
	if (showPhonebook) {
		connect(wphonebook->pbListView, SIGNAL(doubleClicked(QListViewItem*)),
		        this, SLOT(pbSelectCB(QListViewItem*)));
		connect(wphonebook->pbListView, SIGNAL(returnPressed(QListViewItem*)),
				this, SLOT(pbSelectCB(QListViewItem*)));
	}

    // tab order
	if (showFileList) {
		setTabOrder(wfilename->InputFName, wfilelist->listboxFileNames );
		setTabOrder(wfilelist->listboxFileNames, wfaxdata->InputFaxNumber);
	} else {
		setTabOrder(wfilename->InputFName, wfaxdata->InputFaxNumber);
	}
    setTabOrder(wfaxdata->InputFaxNumber, wfaxdata->InputDestName);
    setTabOrder(wfaxdata->InputDestName, wfaxdata->InputEnterprise);
    setTabOrder(wfaxdata->InputEnterprise, wfaxdata->InputRegarding);
    setTabOrder(wfaxdata->InputRegarding, wfaxdata->InputComment);
	if (showPhonebook) {
		setTabOrder(wfaxdata->InputComment, wphonebook->pbListView);
	}
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KSendFaxDlg::~KSendFaxDlg()
{
	// no need to delete child widgets, Qt does it all for us
}

void KSendFaxDlg::BrowseFileCB()
{
    (void)SetFileName();
}

KFileDialog* KSendFaxDlg::getFileDialog(const char* captiontext)
{
	static KFileDialog *file_dialog=0;

	if(!file_dialog) {
		file_dialog = new KFileDialog(QDir::currentDirPath(), "*",
			                          this, "file_dialog", TRUE);
		KFile::Mode mode = static_cast<KFile::Mode>(KFile::Files |
		                                            KFile::ExistingOnly |
		                                            KFile::LocalOnly );
		file_dialog->setMode(mode);
	}
	file_dialog->setCaption(captiontext);
	// file_dialog->rereadDir();

	return file_dialog;
}

int KSendFaxDlg::SetFileName()
{
	KFileDialog * box;
			
	box = getFileDialog(i18n("Select Document to Open"));
	box->show();
	
	if (!box->result())   /* cancelled */
		return false;

	QStringList qsl = box->selectedFiles();

	if(qsl.isEmpty()) {  /* no selection */
		return false;
	}

	QString fname;

	fname =  qsl.first();
	wfilename->InputFName->setText(fname);
	
	if (wfilelist && (qsl.count() > 1)) {
		for (QStringList::Iterator it = qsl.begin(); it != qsl.end(); ++it) {
			wfilelist->listboxFileNames->insertItem((*it).data());
        }
	}
	return true;
}

bool KSendFaxDlg::SetFileName(const char *fname)
{
	QFileInfo ff(fname);

	if (!ff.exists() || !ff.isFile()) {
		QString message;

		if (!ff.isFile())
			message.sprintf("File %s is not a regular file",fname);
		else
			message.sprintf("File %s empty or does not exists",fname);
		QMessageBox::warning(this,"Parameter Error",message);
		return false;
	} else {
		wfilelist->listboxFileNames->insertItem(fname);
	}
	return true;
}

void KSendFaxDlg::AddFileCB()
{
	if (!wfilelist)
		return;

    QString
        fname = wfilename->InputFName->text();
    if (fname.isEmpty())
        return;
    for(int i=wfilelist->listboxFileNames->count()-1;i>=0;i--)
        if (wfilelist->listboxFileNames->text(i) == fname)
            return;
    wfilelist->listboxFileNames->insertItem(fname.data());
}

void KSendFaxDlg::RemoveFileCB()
{
	if (!wfilelist)
		return;

	int i = wfilelist->listboxFileNames->currentItem();
    if (i >= 0 && wfilelist->listboxFileNames->isSelected(i))
        wfilelist->listboxFileNames->removeItem(wfilelist->listboxFileNames->currentItem());
}

void KSendFaxDlg::pbSelectCB(QListViewItem * item)
{
    wfaxdata->InputDestName->setText(item->text(0));
    wfaxdata->InputFaxNumber->setText(item->text(1));
    wfaxdata->InputEnterprise->setText(item->text(2));
}

void KSendFaxDlg::moveFileUpCB()
{
	if (!wfilelist)
		return;

	int i = wfilelist->listboxFileNames->currentItem();
    if (!wfilelist->listboxFileNames->isSelected(i) ||
		wfilelist->listboxFileNames->count() < 2 || i < 1)
	{
		return;
	}
	QString str = wfilelist->listboxFileNames->currentText();
	wfilelist->listboxFileNames->removeItem(i);
	wfilelist->listboxFileNames->insertItem(str, i-1);
	currentFLItem = 0;
	wfilelist->listboxFileNames->setCurrentItem(i-1);
}

void KSendFaxDlg::moveFileDownCB()
{
	if (!wfilelist)
		return;

	int i = wfilelist->listboxFileNames->currentItem();
	int c = wfilelist->listboxFileNames->count();
    if (!wfilelist->listboxFileNames->isSelected(i) || c < 2 || (c-1) == i)
		return;
	QString str = wfilelist->listboxFileNames->currentText();
	wfilelist->listboxFileNames->clearSelection();
	wfilelist->listboxFileNames->removeItem(i);
	wfilelist->listboxFileNames->insertItem(str, i+1);
	currentFLItem = 0;
	wfilelist->listboxFileNames->setCurrentItem(i+1);
}

QString const KSendFaxDlg::filename() const
{
	return wfilename->InputFName->text();
}

int KSendFaxDlg::nooffiles() const
{
	if (wfilelist)
		return wfilelist->listboxFileNames->count();
	return 0;
}

QString const KSendFaxDlg::filename(int no) const
{
	if (wfilelist)
		return wfilelist->listboxFileNames->text(no);
	return QString();
}

QString const KSendFaxDlg::destname() const
{
	return wfaxdata->InputDestName->text();
}

QString const KSendFaxDlg::faxnumber() const
{
	return wfaxdata->InputFaxNumber->text();
}

QString const KSendFaxDlg::enterprise() const
{
	return wfaxdata->InputEnterprise->text();
}

QString const KSendFaxDlg::regarding() const
{
	return wfaxdata->InputRegarding->text();
}

QString const KSendFaxDlg::comment() const
{
	return wfaxdata->InputComment->text();
}

QStringList const KSendFaxDlg::commentList() const
{
	int n = wfaxdata->InputComment->numLines();
	QStringList qsl;
	
	for(int i = 0; i < n; ++i)
		qsl.append(wfaxdata->InputComment->textLine(i));

	return qsl;
}

QListView * KSendFaxDlg::pbListView() const
{
	if (wphonebook)
		return wphonebook->pbListView;
	return 0;
}

void KSendFaxDlg::writeConfig(KConfig * conf) const
{
	conf->writeEntry("ViewSplitter", viewSplitter->sizes());
	if (wphonebook) {
		conf->writeEntry("height_phonebook", wphonebook->pbListView->height());
	}
}

void KSendFaxDlg::filename(QString const str)
{
	wfilename->InputFName->setText(str);
}

void KSendFaxDlg::filename(int, QString const str)
{
	if (wfilelist)
		wfilelist->listboxFileNames->insertItem(str);
}

void KSendFaxDlg::destname(QString const str)
{
	wfaxdata->InputDestName->setText(str);
}

void KSendFaxDlg::faxnumber(QString const str)
{
	wfaxdata->InputFaxNumber->setText(str);
}

void KSendFaxDlg::enterprise(QString const str)
{
	wfaxdata->InputEnterprise->setText(str);
}

void KSendFaxDlg::regarding(QString const str)
{
	wfaxdata->InputRegarding->setText(str);
}

void KSendFaxDlg::comment(QString const str)
{
	wfaxdata->InputComment->setText(str);
}

QString const KSendFaxDlg::selectedFile() const
{
	int i = wfilelist->listboxFileNames->currentItem();
	if (!wfilelist || i == -1 || !wfilelist->listboxFileNames->isSelected(i))
		return QString();

	return wfilelist->listboxFileNames->currentText();
}

void KSendFaxDlg::selectionInFileList(QListBoxItem * item)
{
	if (!item)
		return;
	wfilelist->listboxFileNames->clearSelection();
	if (currentFLItem == item) {
		currentFLItem = 0;
	} else {
		wfilelist->listboxFileNames->setSelected(item, true);
		currentFLItem = item;
	}
}
