/***************************************************************************
                          ksendfaxdlg.h  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSENDFAXDLG_H
#define KSENDFAXDLG_H

#include <qwidget.h>

class QSplitter;
class QListView;
class QListViewItem;
class QListBoxItem;
class QStringList;
class KFileDialog;
class WidgetFileName;
class WidgetFileList;
class WidgetFaxData;
class WidgetPhonebook;
class KConfig;

class KSendFaxDlg : public QWidget
{ 
    Q_OBJECT

public:
    KSendFaxDlg(bool showPhoneBook, bool showFileList, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~KSendFaxDlg();
    bool SetFileName(const char* fname);
    KFileDialog * getFileDialog(const char* captiontext);
	///
	// get the data from the dialog
	///
	QString const filename() const;
	int nooffiles() const;
	QString const filename(int) const;
	QString const destname() const;
	QString const faxnumber() const;
	QString const enterprise() const;
	QString const regarding() const;
	QString const comment() const;
	QStringList const commentList() const;
	QListView * pbListView() const;
	QString const selectedFile() const;
	///
	// set dialog data
	///
	void filename(QString const);
	void filename(int, QString const);
	void destname(QString const);
	void faxnumber(QString const);
	void enterprise(QString const);
	void regarding(QString const);
	void comment(QString const);
	///
	// write dialog data
	///
	void writeConfig(KConfig *) const;

public slots:
    void BrowseFileCB();
    void AddFileCB();
    void RemoveFileCB();
	void pbSelectCB(QListViewItem *);
    void moveFileUpCB();
    void moveFileDownCB();
	void selectionInFileList(QListBoxItem *);

private:
    int SetFileName();

	QString current_directory;
	QSplitter * viewSplitter;
	QListBoxItem * currentFLItem;
	WidgetFileName  * wfilename;
	WidgetFileList  * wfilelist;
	WidgetFaxData   * wfaxdata;
	WidgetPhonebook * wphonebook;
};

#endif // KSENDFAXDLG_H
