/***************************************************************************
                          ksendfaxview.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <stdlib.h>
#include <unistd.h>

// include files for Qt
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qfileinfo.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qgroupbox.h>
#include <qdir.h>
#include <qregexp.h>
#include <qlabel.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kabc/stdaddressbook.h>
#include <kabc/addressbook.h>
#include <kstddirs.h>
#include <kfileitem.h>
#include <kurl.h>
#include <ktempfile.h>
#include <kfiledialog.h>
#include <kdebug.h>

#ifdef HAVE_SANE
#include "myscandialog.h"
#endif

// application specific includes
#include "ksendfaxview.h"
#include "ksendfax.h"
#include "ksendfaxdlg.h"
#include "loglistbox.h"
#include "myprocess.h"
#include "formedit.h"
#include "preferences.h"
#include "helpers.h"

// global variables
extern QString debugFlag;
extern int oneShotFlag;

#define LEN_PHONE	20
#define LEN_NAME	25


KSendFaxView::KSendFaxView(QWidget *parent, const char *name)
		: QVBox(parent, name)
{
	setBackgroundMode(PaletteBase);
	kapp->config()->setGroup("ksendfax");
	showPB = kapp->config()->readBoolEntry("show_phonebook",true);
	showFL = kapp->config()->readBoolEntry("show_filelist",true);
	readConfig();
	dlg = new KSendFaxDlg(showPB, showFL, this, 0);
	show_listbox = new LogListBox(0,i18n("Show Fax Queue"));
	show_listbox->setIcon(KGlobal::iconLoader()->loadIcon("faxshow.xpm",KIcon::User));
	remove_listbox = new LogListBox(0,i18n("Remove Log"));
	remove_listbox->setIcon(KGlobal::iconLoader()->loadIcon("faxremove.xpm",KIcon::User));
	error_listbox = new LogListBox(0,i18n("Fax Send Log"));
	error_listbox->setIcon(KGlobal::iconLoader()->loadIcon("faxsend.xpm",KIcon::User));
	if (showPB) {
		pbLoad();
	}
	fedit = new FormEdit(0,"Edit Document", true);
#ifdef USE_KAB
    connect(KABC::StdAddressBook::self(),
	        SIGNAL(addressBookChanged(AddressBook *)), this,
	        SLOT(readAddressBook()));
#endif
}

KSendFaxView::~KSendFaxView()
{
	delete fedit;
}

void KSendFaxView::SendFaxCB()
{
	sendFax();
}


bool KSendFaxView::convertToPSIfNeeded(QString fname, QString & psfile,
									   bool convertAll, bool checkTags)
{
	QFileInfo fi1(fname);
	// first check if the file does exist
	if (!fi1.exists()) {
		return false;
	}

	psfile = QString();
	
	bool creaded = false; // so readConfig is not called twice!
	KTempFile * ktf_tags = 0;
	if (checkTags) {
		QFile f(fi1.filePath());
		if (f.open(IO_ReadOnly)) {
			readConfig();
			creaded = true;
			QFileInfo fi2(logdir + "/" + fi1.baseName());
			QString ext = "." + fi1.extension(false);
			ktf_tags = new KTempFile(fi2.absFilePath(), ext);
			QTextStream t(&f);
			bool changed = false;
			QString pages;
			int p = 0;
			
			if (dlg->nooffiles() > 0)
				p = dlg->nooffiles();
			else if (!dlg->filename().isEmpty())
				p = 1;
			pages.sprintf("%d", p);
			
			while (!t.eof()) {
				QString str;
				QString ostr;
				QString tmp;
				QString name = dlg->destname();
				QString phone = dlg->faxnumber();
				QString enterprise = dlg->enterprise();
				QString comment = dlg->comment();
				QStringList comlist = dlg->commentList();
				QString regarding = dlg->regarding();
				KConfig *config = kapp->config();
				QString date = Helpers::getActualDate();
				QString fromname = config->readEntry("personal_name");
				QString fromphone = config->readEntry("personal_phone");
				QString fromenterprise = config->readEntry("personal_enterprise");
				
				str = ostr = t.readLine();
				p = 0;
				for(QStringList::Iterator it = comlist.begin();
					it != comlist.end(); ++it, ++p)
				{
					tmp.setNum(p);
					tmp = "@@Comment" + tmp;
					tmp += "N";
					str.replace(QRegExp(tmp),(*it).latin1());
				}
				str.replace(QRegExp("@@Comment"),comment);
				str.replace(QRegExp("@@Enterprise"),enterprise);
				str.replace(QRegExp("@@Name"),name);
				str.replace(QRegExp("@@Phone"),phone);
				str.replace(QRegExp("@@Date"),date);
				str.replace(QRegExp("@@FromName"),fromname);
				str.replace(QRegExp("@@FromPhone"),fromphone);
				str.replace(QRegExp("@@FromEnterprise"),fromenterprise);
				str.replace(QRegExp("@@Regarding"),regarding);

				str.replace(QRegExp("@@Pages"),pages);
				changed = changed || (str != ostr);
				// add also a date field!
				*(ktf_tags->textStream()) << str << endl;
			}
			f.close();
			if (changed) {
				fname = ktf_tags->name();
				ktf_tags->close();
			} else {
				ktf_tags->unlink();
				delete ktf_tags;
				ktf_tags = 0;
			}
		}
	}
	
	QString	mimeType = KMimeType::findByURL(KURL(fname), 0, true)->name();
	if (!debugFlag.isEmpty())
		fprintf(stderr, "MIME: %s=%s\n",fname.data(), mimeType.data());
	if (mimeType == "application/postscript") {
		psfile = fname;
		delete ktf_tags;
		return true;
	}
	if (!convertAll) {
		if (checkExcludeConvert(mimeType)) {
			delete ktf_tags;
			psfile = fname;
			return true;
		}
		bool useps = kapp->config()->readBoolEntry("convert_ps", true);
		if (!useps && !checkAlwaysConvert(mimeType)) {
			delete ktf_tags;
			psfile = fname;
			return true;
		}
	}
	QString cmd;
	
	if (!getConverterCmd(mimeType, cmd)) {
		QString msg;
		msg.sprintf("No postscript converter found for %s", mimeType.data());
		int ret = QMessageBox::warning( this, "KSendFax", msg,
										i18n("Use Anyway"), i18n("Skip"),
										i18n("Abort"), 0, 3);
		switch(ret) {
		case 0:
			psfile = fname;
			delete ktf_tags;
			return true;
		case 1:
			if (ktf_tags) {
				ktf_tags->setAutoDelete(true);
				delete ktf_tags;
			}
			return true;
		default:
			break;
		}
		if (ktf_tags) {
			ktf_tags->setAutoDelete(true);
			delete ktf_tags;
		}
		return false;
	}
	if (!creaded)
		readConfig();

	QFileInfo fi2(logdir + "/" + fi1.baseName());
	KTempFile ktf1(fi2.absFilePath(), ".ps");
	KTempFile ktf2(fi2.absFilePath(), ".log");
	MyProcess * proc = new MyProcess(0,false);

	ktf1.file()->close();
	ktf2.file()->close();
	ktf2.setAutoDelete(true);
	cmd += " 2>" + ktf2.name();
	cmd.replace(QRegExp("@@FName"), fname);
	cmd.replace(QRegExp("@@OutFName"), ktf1.name().data());
	if (!debugFlag.isEmpty())
		fprintf(stderr,"ANY2PS-CMD: %s\n",cmd.data());
	*proc << cmd;

	bool result = proc->start(KProcess::Block, KProcess::NoCommunication);
	if(!result) {
		QString str;
		str.sprintf(i18n("Cannot start a new program\nfork() failed."));
		QMessageBox::critical(this,"KSendFax",str.data());
		if (proc) {
			if(proc->isRunning())
				proc->kill();
			delete proc;
			proc = 0;
		}
	}
	if (proc)
		delete proc;

	if (ktf1.file()->size() <= 0) {
        QString message = "Error: Trasformation to Postscript failed";
		
		if ((ktf2.file()->size() > 0) && ktf2.file()->open(IO_ReadOnly)) {
			QTextStream t(ktf2.file());
			message += "\n(" + t.readLine() + ")";
			ktf2.file()->close();
		}
		QMessageBox::warning(this,"Trasformation to Postscript failed.",
							 message);
		ktf1.setAutoDelete(true);
		if (ktf_tags) {
			ktf_tags->setAutoDelete(true);
			delete ktf_tags;
		}
		return false;
	}
	psfile = ktf1.name();
	delete ktf_tags;
	return true;
}

int KSendFaxView::sendFax()
{
	if (dlg->faxnumber().isEmpty())
		return false;

	QStringList fnames;
	QStringList	tmpfilenames;
	if (!setFileList(fnames, tmpfilenames))
		return false;
	
	QString phone = dlg->faxnumber();
	QString name = dlg->destname();
	QString enterprise = dlg->enterprise();
	QString comment = dlg->comment();
	QString regarding = dlg->regarding();
	KConfig *config = kapp->config();
	QString fromname = config->readEntry("personal_name");
	QString host = getenv("FAXSERVER");
	QString message = "Error: Trasformation to Postscript failed";
	QString logfile;
	QString cmd;
	QFile   ff;
	QFile   fl;

	readConfig();
	cmd = sendcmd.data();
	if (!debugFlag.isEmpty())
		fprintf(stderr,"CMD: %s:%s:%s\n",cmd.data(),host.data(),name.data());
	cmd.replace(QRegExp("@@Host"),host);
	cmd.replace(QRegExp("@@Comment"),comment);
	cmd.replace(QRegExp("@@Enterprise"),enterprise);
	cmd.replace(QRegExp("@@Name"),name);
	cmd.replace(QRegExp("@@Phone"),phone);
	cmd.replace(QRegExp("@@FName"),fnames.join(" "));
	cmd.replace(QRegExp("@@FromName"),fromname);
	cmd.replace(QRegExp("@@Regarding"),regarding);
	if (!debugFlag.isEmpty())
		fprintf(stderr,"CMD: %s\n",cmd.data());
	MyProcess
		*proc = new MyProcess(0,false);

	*proc << cmd.data();
	bool result;
	if (oneShotFlag) {
		result = proc->start(KProcess::Block, KProcess::NoCommunication);
		if(!result){
			QString str;
			str.sprintf(i18n("Cannot start a new program\nfork() failed."));
			QMessageBox::critical(this,"KSendFax",str.data());
			if (proc) {
			    if(proc->isRunning())
			        proc->kill();
			    delete proc;
			    proc = 0;
			}
		}
		if (proc)
			delete proc;
		emit ExitKSendFax();
		return true;
	}
	connect(proc, SIGNAL(processExited(KProcess *)),this,
			SLOT(SendFaxDone(KProcess*)));
	connect(proc, SIGNAL(receivedStderr(KProcess *,char*,int)),this, 
			SLOT(ReadStderr(KProcess*,char*,int)));
	connect(proc, SIGNAL(receivedStdout(KProcess *,char*,int)),this, 
			SLOT(ReadStdout(KProcess*,char*,int)));
	if (!error_listbox->isVisible())
		error_listbox->show();
	if (!tmpfilenames.isEmpty())
		proc->setLocalData(tmpfilenames);
	result = proc->start(KProcess::NotifyOnExit , KProcess::All);
	if(!result){
		QString str;
		str.sprintf(i18n("Cannot start a new program\nfork() failed."));
		QMessageBox::critical(this,"KSendFax",str.data());
		if(proc->isRunning())
			proc->kill();
		delete proc;
		return false;
	}
	return true;
}

int KSendFaxView::showJobs()
{
	QString
		host = getenv("FAXSERVER"),
		filename,
		logfile,
		cmd;
	QFile
		ff,fl;

	readConfig();
	if (host.isEmpty())
		host = "localhost";
	cmd = showcmd.data();
	cmd.replace(QRegExp("@@Host"),host);
	if (!debugFlag.isEmpty())
		fprintf(stderr,"CMD: %s\n",cmd.data());
	show_listbox->setTimerUpdate(updateSeconds*1000);
	show_listbox->setCommand(cmd);
	show_listbox->activateCommand();
//	show_listbox->show();
	return true;
}

int KSendFaxView::removeJob()
{
	QString
		host = getenv("FAXSERVER"),
		filename,
		logfile,
		cmd;
	QFile
		ff,fl;

	readConfig();
	if (host.isEmpty())
		host = "localhost";
	cmd = removecmd.data();
	cmd.replace(QRegExp("@@Host"),host);
	if (cmd.find("@@ID") >= 0) { // ask for the faxid
		QString
			id = askID();
		if (id.isEmpty())
			return false;
		cmd.replace(QRegExp("@@ID"),id.data());
	}
	if (!debugFlag.isEmpty())
		fprintf(stderr,"CMD: %s\n",cmd.data());
	remove_listbox->setCommand(cmd);
	remove_listbox->activateCommand(false);
	return true;
}


void KSendFaxView::readConfig()
{
	KConfig * conf = kapp->config();
	KStandardDirs ksd;

	conf->setGroup("ksendfax");
	sendcmd = conf->readEntry("send_command");
	if (sendcmd.isEmpty())
		sendcmd = "sendfax -n -h '@@Host' -c '@@Comment' -x '@@Enterprise'" \
			      " -d '@@Name'@'@@Phone' @@FName";
	showcmd = conf->readEntry("show_command");
	if (showcmd.isEmpty())
		showcmd = "faxstat -h '@@Host'";
	removecmd = conf->readEntry("remove_command");
	if (removecmd.isEmpty())
		removecmd = "faxrm -h '@@Host' @@ID";
	updateSeconds = conf->readNumEntry("update_seconds",0);
	logdir = conf->readEntry("log_directory");
	if (logdir.isEmpty()) {
		logdir = ksd.findResourceDir("tmp","");
		if (logdir.isEmpty())
			logdir = "/tmp";
	}
	phonebook_type = conf->readEntry("phonebook_type");
	if (phonebook_type.isEmpty())
		phonebook_type = "ksendfax";
	else if (phonebook_type == "kab") // kab is deprecated in KDE3!!!
		phonebook_type = "kaddressbook";
	phonebook = conf->readEntry("phonebook");
	if (phonebook.isEmpty()) {
		phonebook = getenv("PHONEBOOK");
		if (phonebook.isEmpty()) {
			phonebook = getenv("HOME");
			phonebook += "/.phonebook";
		}
	}
	QString appdir = conf->readEntry("scanner_workdir");
	if (appdir.isEmpty())
		appdir =  ksd.saveLocation("data", "ksendfax");
	workdir.setPath(appdir);
	if (!debugFlag.isEmpty()) {
		fprintf(stderr,"SendCMD: %s\n",sendcmd.data());
		fprintf(stderr,"ShowCMD: %s\n",showcmd.data());
		fprintf(stderr,"RemoveCMD: %s\n",removecmd.data());
		fprintf(stderr, "WorkDir: %s\n",appdir.data());
	}
}

void KSendFaxView::saveOptions()
{
	QString
		str;
	KConfig
		*conf = kapp->config();

	conf->setGroup("ksendfax");
	conf->writeEntry("show_phonebook",showPB);
	conf->writeEntry("show_filelist",showFL);
	conf->writeEntry("scanner_workdir", workdir.absPath());
	dlg->writeConfig(conf);
	conf->sync();
}

void KSendFaxView::ReadStderr(KProcess *proc, char *buffer, int buflen)
{
	if (!proc)
		return;
	QString
		str,
		s;
	int
		pos;
	MyProcess
		*mproc = (MyProcess*)proc;

	s.sprintf("%.*s",buflen,buffer);
	if (mproc->row > 0)
		str = error_listbox->text(mproc->row);
	str += s;
	pos = str.find('\n');
	while((str.length() > 0) && pos >= 0) {
		pos++;
		s = str.left(pos);
	if (mproc->row > 0) {
		error_listbox->changeItem(s, mproc->row);
		mproc->row = 0;
	} else
		error_listbox->insertItem(s);
		str = str.right(str.length()-pos);
		pos = str.find('\n');
	}
	if (str.length() > 0) {
	if (mproc->row > 0)
		error_listbox->changeItem(str, mproc->row);
	else
		error_listbox->insertItem(str);
	mproc->row = error_listbox->count()-1;
	error_listbox->setBottomItem();
	} else
	error_listbox->setBottomItem();
}

void KSendFaxView::ReadStdout(KProcess *proc, char *buffer, int buflen)
{
	if (!proc)
		return;
	QString
		str,
		s;
	int
		pos;
	MyProcess
		*mproc = (MyProcess*)proc;

	s.sprintf("%.*s",buflen,buffer);
	if (mproc->row > 0)
		str = error_listbox->text(mproc->row);
	str += s;
	pos = str.find('\n');
	while((str.length() > 0) && pos >= 0) {
		pos++;
		s = str.left(pos);
	if (mproc->row > 0) {
		error_listbox->changeItem(s, mproc->row);
		mproc->row = 0;
	} else
		error_listbox->insertItem(s);
		str = str.right(str.length()-pos);
		pos = str.find('\n');
	}
	if (str.length() > 0) {
	if (mproc->row > 0)
		error_listbox->changeItem(str, mproc->row);
	else
		error_listbox->insertItem(str);
	mproc->row = error_listbox->count()-1;
	error_listbox->setBottomItem();
	} else
	error_listbox->setBottomItem();
}

void KSendFaxView::SendFaxDone(KProcess *proc)
{
	if (!proc)
		return;
	MyProcess *mproc = (MyProcess*)proc;

	Helpers::removeTempFiles(mproc->localData());
	if (!debugFlag.isEmpty())
		printf("Called SendFaxDone\n");
	if(proc->isRunning()) {
		proc->kill();
	}
	delete mproc;
}

void KSendFaxView::readAddressBook()
{
#ifdef USE_KAB
	readConfig();
	if (phonebook_type != "ksendfax")
		pbLoad();
#endif
}

bool KSendFaxView::pbLoad()
{
	dlg->pbListView()->clear();
	readConfig();
#ifdef USE_KAB
	if (phonebook_type == "ksendfax") {
#endif
		QFile f(phonebook);
		if (!f.open( IO_ReadOnly ))
			return false;

		QTextStream t(&f);
		QString vet[3];
		QString str;
		int cFax;
		int cNam;
		int cEnt;

		getColumnNumbers(cFax, cNam, cEnt);
		while (!t.eof()) {
			str = t.readLine();
			if (str.stripWhiteSpace().length() <= 1)
				continue;
			vet[cFax] = (str.mid(0, LEN_PHONE)).simplifyWhiteSpace();
			if (vet[cFax].isNull())
				vet[cFax] = "";
			vet[cNam] = (str.mid(LEN_PHONE,LEN_NAME)).simplifyWhiteSpace();
			if (vet[cNam].isNull())
				vet[cNam] = "";
			vet[cEnt] = (str.mid(LEN_PHONE+LEN_NAME,str.length())).simplifyWhiteSpace();
			if (vet[cEnt].isNull())
				vet[cEnt] = "";
			new QListViewItem(dlg->pbListView(), vet[0], vet[1], vet[2]);
		}
		f.close();
#ifdef USE_KAB
	} else {
		KABC::AddressBook *ab = KABC::StdAddressBook::self();
		if(!ab) {
			QMessageBox::warning(this,i18n("Error getting Addressbook"),
								 i18n("Couldn't get the KAB Addressbook"));
			return false;
		}
		KABC::AddressBook::Iterator it;
		it = ab->begin();
		if (it == ab->end())
			return false;
		
		MyPBEntry me;
		int nk = 0;
		QString a, b, c, d;

		for(;it != ab->end(); ++it) {
			me.number = nk;
			me.modified = false;
			me.entry = *it;
			pb_entries[nk++] = me;
			a = (*it).realName();
			// Get all Kontact Fields
			b = (*it).organization();
			c = "";
			d.setNum(me.number);
			KABC::PhoneNumber::List numbers = (*it).phoneNumbers();
			KABC::PhoneNumber::List::Iterator pit;
			for(pit = numbers.begin(); pit != numbers.end(); ++pit) {
				if ((*pit).type() & KABC::PhoneNumber::Fax) {
					c = (*pit).number();
					new QListViewItem(dlg->pbListView(), a, c, b, d);
					kdDebug()<<"Found "<<(*it).realName()<<": "<<c<<endl;
				}
			}
		}
	}
#endif
	dlg->pbListView()->repaint();
	return true;
}

bool KSendFaxView::pbAdd()
{
#ifdef USE_KAB
	readConfig();
	if (phonebook_type != "ksendfax")
		return true;
#endif
	QString vet[3];
	QString a2,b2,c2;
	QString str,line1,line2;
	QListViewItem * item;
	int cFax;
	int cNam;
	int cEnt;
	
	getColumnNumbers(cFax, cNam, cEnt);
	vet[cFax] = dlg->faxnumber().simplifyWhiteSpace();
	vet[cNam] = dlg->destname().simplifyWhiteSpace();
	vet[cEnt] = dlg->enterprise().simplifyWhiteSpace();
	line1.sprintf("%-*s %-*s %-s",LEN_NAME,vet[cNam].left(LEN_NAME).data(),
				  LEN_PHONE,vet[cFax].left(LEN_PHONE).data(),vet[cEnt].data());
	if (line1.stripWhiteSpace().length() <= 0)
		return false;
	for(item=dlg->pbListView()->firstChild(); item; item = item->itemBelow()) {
		a2 = ((QString)(item->text(0))).simplifyWhiteSpace();
		b2 = ((QString)(item->text(1))).simplifyWhiteSpace();
		c2 = ((QString)(item->text(2))).simplifyWhiteSpace();
		line2.sprintf("%-*.*s %-*.*s %-s",LEN_NAME,LEN_NAME,b2.data(),
					  LEN_PHONE,LEN_PHONE,a2.data(),c2.data());
		if (line1 == line2)
			break;
	}
	if (!item) {
		new QListViewItem(dlg->pbListView(), vet[0], vet[1], vet[2]);
		return true;
	}
	return false;
}

bool KSendFaxView::pbModify()
{
#ifdef USE_KAB
	readConfig();
	if (phonebook_type != "ksendfax")
		return true;
#endif
	QString vet[3];
	QString str, line;
	int cFax;
	int cNam;
	int cEnt;
	
	getColumnNumbers(cFax, cNam, cEnt);
	vet[cFax] = dlg->faxnumber().simplifyWhiteSpace();
	vet[cNam] = dlg->destname().simplifyWhiteSpace();
	vet[cEnt] = dlg->enterprise().simplifyWhiteSpace();
	line.sprintf("%-*s %-*s %-s",LEN_NAME,vet[cNam].left(LEN_NAME).data(),
			     LEN_PHONE,vet[cFax].left(LEN_PHONE).data(),vet[cEnt].data());
	if ((line.stripWhiteSpace()).length() > 1) {
		dlg->pbListView()->currentItem()->setText(0, vet[0]);
		dlg->pbListView()->currentItem()->setText(1, vet[1]);
		dlg->pbListView()->currentItem()->setText(2, vet[2]);
		return true;
	}
	return false;
}

bool KSendFaxView::pbRemove()
{
#ifdef USE_KAB
	readConfig();
	if (phonebook_type != "ksendfax")
		return true;
#endif
	delete dlg->pbListView()->currentItem();
	return true;
}

bool KSendFaxView::pbSave()
{
	readConfig();
#ifdef USE_KAB
	if (phonebook_type != "ksendfax")
		return true;
#endif
	QFile
		f(phonebook);
	if (!f.open( IO_WriteOnly ))
		return false;

	QString line;
	QString strNam;
	QString strFax;
	QString strEnt;
	int cNam;
	int cFax;
	int cEnt;

	getColumnNumbers(cFax, cNam, cEnt);
	for(QListViewItem * item = dlg->pbListView()->firstChild();
		item; item = item->itemBelow())
	{
		strFax = item->text(cFax);
		if (strFax.isNull())
			strFax = "";
		strNam = item->text(cNam);
		if (strNam.isNull())
			strNam = "";
		strEnt = item->text(cEnt);
		if (strEnt.isNull())
			strEnt = "";
		line = "";
		line.sprintf("%-*s %-*s %s\n",
					 LEN_PHONE,strFax.left(LEN_PHONE).data(),
					 LEN_NAME,strNam.left(LEN_NAME).data(),
					 strEnt.data());
		f.writeBlock(line.data(),line.length());
	}
	f.close();
	return true;
}

void KSendFaxView::setPos(QLabel *lab, QLineEdit *le)
{
	int pos, diff;

	pos = lab->x() + lab->width() + 5;
	diff = pos - le->x();
	if (diff > 0)
		le->setGeometry(pos, le->y(), le->width() - diff, le->height());
}

const char *KSendFaxView::askID()
{
	static QDialog *askIDdiag = 0;
	static QLabel *label;
	static QLineEdit *inputID;
	static QPushButton *ok;
	static QPushButton *cancel;

	if (!askIDdiag) {
		askIDdiag = new QDialog(0,i18n("Input Fax ID"),true);
		CHECK_PTR(askIDdiag);
		label = new QLabel(askIDdiag, "Label");
		CHECK_PTR(label);
		inputID = new QLineEdit(askIDdiag,"LineEdit");
		CHECK_PTR(inputID);
		ok = new QPushButton(askIDdiag,"OKButton");
		CHECK_PTR(ok);
		cancel = new QPushButton(askIDdiag,"CancelButton");
		CHECK_PTR(cancel);
		
		label->setGeometry( 10, 10, 50, 30 );
		label->setText(i18n("Fax ID:"));
		label->setAlignment(289);
		label->setMargin(-1);
		
		inputID->setGeometry( 70, 10, 100, 30 );
		inputID->setMaxLength(30);
		
		ok->setGeometry( 55, 45, 60, 25 );
		ok->setText(i18n("Ok"));
		ok->setDefault(TRUE);
		connect(ok, SIGNAL(clicked()), askIDdiag, SLOT(accept()));
		
		cancel->setGeometry( 125, 45, 60, 25 );
		cancel->setText(i18n("&Cancel"));
		connect(cancel, SIGNAL(clicked()), askIDdiag, SLOT(reject()));
		
		askIDdiag->resize( 190,75 );
		askIDdiag->setMinimumSize( 190, 75 );
		askIDdiag->setMaximumSize( 190, 75 );
	}
	inputID->setText("");
	if (!askIDdiag->exec())
		return "";
	else
		return inputID->text();
}

void moveNewPos(QWidget *obj, int dy)
{
	int
		x = obj->x(),
		y = obj->y();

	obj->move(x, y+dy);
}


bool KSendFaxView::showFileList(bool flag)
{
	if (showFL == flag)
		return false;

	showFL = flag;
	return regenerate(!showFL);
}

bool KSendFaxView::pbShow(bool flag)
{
	if (showPB == flag)
		return false;
	showPB = flag;

	return regenerate(showFL);
}

bool KSendFaxView::pbEdit()
{
	readConfig();
	if (phonebook_type == "ksendfax")
		return false;

	QString cmd;
	MyProcess *proc = new MyProcess(0,false);

	cmd = phonebook_type;
	*proc << cmd.data();
	if (!debugFlag.isEmpty())
		fprintf(stderr,"KABCmd: %s\n",cmd.data());
	
	bool result =proc->start(KProcess::DontCare, KProcess::NoCommunication);
	
	if(!result){
		QString str;
		str.sprintf(i18n("Cannot start a new program\nfork() failed."));
		QMessageBox::critical(this,"KSendFax",str.data());
		if (proc) {
			if(proc->isRunning())
				proc->kill();
			delete proc;
			proc = 0;
		}
		return false;
	}
	return true;
}

bool KSendFaxView::regenerate(bool old_showFL)
{
	KSendFaxDlg * newdlg = new KSendFaxDlg(showPB, showFL, this, 0);
	newdlg->filename(dlg->filename());
	newdlg->destname(dlg->destname());
	newdlg->faxnumber(dlg->faxnumber());
	newdlg->enterprise(dlg->enterprise());
	newdlg->comment(dlg->comment());
	if (showFL && old_showFL) {
		if (dlg->nooffiles() > 0) {
			for(int i=dlg->nooffiles();i>0;i--) {
				newdlg->filename(dlg->nooffiles(),
				                 dlg->filename(dlg->nooffiles()-i));
			}
		}
	}
	delete dlg;
	dlg = newdlg;
#if 0
	if (!showPB)
		dlg->commentGroupBox->setSizePolicy( QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding, dlg->commentGroupBox->sizePolicy().hasHeightForWidth() ) );
	else {
#else
	if (showPB) {
#endif
		pbLoad();
		QListViewItem * item;
		if ((item=pbSearch())) {
			dlg->pbListView()->setSelected(item, true);
			dlg->pbListView()->ensureItemVisible(item);
		}
	}
	dlg->show();
	
	return true;
}

QListViewItem * KSendFaxView::pbSearch()
{
	QString
		a,b,c,line1, line2;

	a = dlg->faxnumber().simplifyWhiteSpace();
	b = dlg->destname().simplifyWhiteSpace();
	c = dlg->enterprise().simplifyWhiteSpace();
	line1.sprintf("%-*.*s %-*.*s %-s",LEN_NAME,LEN_NAME,b.data(),
	              LEN_PHONE,LEN_PHONE,a.data(),c.data());
	QListViewItem * item = 0;
	for (item = dlg->pbListView()->firstChild(); item; item=item->itemBelow()) {
		a = item->text(1);
		b = item->text(0);
		c = item->text(2);
		line2.sprintf("%-*.*s %-*.*s %-s",LEN_NAME,LEN_NAME,b.data(),
		              LEN_PHONE,LEN_PHONE,a.data(),c.data());
		if (line1 == line2)
			break;
	}
	return item;
}

bool KSendFaxView::setFileName(const char * fname)
{
	return dlg->SetFileName(fname);
}

bool KSendFaxView::scanDoc()
{
	QString dirname = KFileDialog::getExistingDirectory(
		workdir.absPath(),this, i18n("Select scanner save directory"));

	if (dirname.isNull())   /* cancelled */
		return false;
	workdir.setPath(dirname);
	workdir.mkdir(workdir.absPath());
	if (chdir(workdir.absPath()) == -1) { // error changing to directory
		QString msg = i18n("Cannot change to directory: ") + workdir.absPath();
		QMessageBox::critical(this,"KSendFax", msg);
		return false;
	}
	KConfig
		*conf = kapp->config();
#ifdef HAVE_SANE
	bool use_xsane = conf->readBoolEntry("use_xsane", false);
	if (use_xsane) {
#endif
		QString cmd = conf->readEntry("xsane_command");
		MyProcess *proc = new MyProcess(0,false);
		KConfig * config = kapp->config();
		QString ext = config->readEntry("scan_type", "tiff");

		if (ext != "tiff")
			ext = "ps";
		
		QString fname = "page_1." + ext;
		if (cmd.isEmpty())
			cmd = "xsane -N @@FName";
		cmd.replace(QRegExp("@@FName"), fname);
		*proc << cmd.data();
		bool result;
		if (!debugFlag.isEmpty())
			fprintf(stderr,"XSaneCMD: %s\n",cmd.data());
		connect(proc, SIGNAL(processExited(KProcess *)),this,
				SLOT(XSaneDone(KProcess*)));
		result = proc->start(KProcess::NotifyOnExit,KProcess::NoCommunication);
		if(!result){
			QString str;
			str.sprintf(i18n("Cannot start a new program\nfork() failed."));
			QMessageBox::critical(this,"KSendFax",str.data());
			if (proc) {
			    if(proc->isRunning())
			        proc->kill();
			    delete proc;
			    proc = 0;
			}
			return false;
		}
#ifdef HAVE_SANE
	} else {
		KScanDialog * m_scanDialog = 0;

		if (!m_scanDialog) {
			m_scanDialog = new MyScanDialog(0, "Scan Dialog");
			
			if (!m_scanDialog) // no scanning support installed?
				return false;
			
			connect(m_scanDialog, SIGNAL(finalImage( const QImage&, int )),
					SLOT(slotScanned( const QImage&, int )));
		}
		
		if (m_scanDialog->setup()) // only if scanner configured/available
			m_scanDialog->show();
	}
#endif
	return true;
}

#ifdef HAVE_SANE
void KSendFaxView::slotScanned(QImage const & qimg, int id)
#else
void KSendFaxView::slotScanned(QImage const &, int)
#endif
{
#ifdef HAVE_SANE
	QString filename;
	KConfig * config = kapp->config();
	QString ext = config->readEntry("scan_type", "tiff");

	if (ext != "tiff")
		ext = "eps";
	filename.sprintf("page_%d.", id);
	filename += ext;
	QFileInfo qfi(filename);
	if (qfi.exists()) {
		QString msg = "File: " + filename;

		msg += "\ndoes already exits.\nOverwrite it?\n";
		if (!QMessageBox::warning(this, "KSendFax", msg, "Abort", "Yes", 0, 0, 1))
			return;
	}
	qimg.save(filename, ext);
	dlg->SetFileName(filename);
	dlg->AddFileCB();
	if (!debugFlag.isEmpty())
		fprintf(stderr, "%s\n",filename.data());
#endif
}


void KSendFaxView::XSaneDone(KProcess *proc)
{
	if (!proc)
		return;
	MyProcess *mproc = (MyProcess*)proc;

	Helpers::removeTempFiles(mproc->localData());
	if (!debugFlag.isEmpty())
		fprintf(stderr, "Called XSaneDone\n");
	if(proc->isRunning()) {
		proc->kill();
	}
	delete mproc;

	workdir.setFilter( QDir::Files | QDir::NoSymLinks );
	const QFileInfoList *list = workdir.entryInfoList();
	QFileInfoListIterator it( *list );      // create list iterator
	QFileInfo *fi;                          // pointer for traversing
	
	while ( (fi=it.current()) ) {           // for each file...
		QString fname;
		fname = workdir.absPath() + "/" + fi->fileName();
		dlg->SetFileName(fname);
		dlg->AddFileCB();
		if (!debugFlag.isEmpty())
			fprintf(stderr, "%s\n", fname.data());
		++it;                               // goto next list element
	}
}


bool KSendFaxView::previewDoc()
{
	QStringList fnames;
	QStringList tmpfilenames;

	if (!setFileList(fnames, tmpfilenames, true))
		return false;
	
	QString cmd;
	KURL url;
	QFileInfo fi1(logdir + "/ksfpreview");
	KTempFile ktf1(fi1.absFilePath(), ".ps");
    KConfig *config = kapp->config();

	ktf1.setAutoDelete(true);
	if (fnames.count() > 1) {
		cmd = config->readEntry("convert_command");
		if (cmd.isEmpty())
			cmd = "convert @@FName @@TmpFName";
		cmd.replace(QRegExp("@@FName"),fnames.join(" "));
		cmd.replace(QRegExp("@@TmpFName"), ktf1.name());
		if (!debugFlag.isEmpty())
			fprintf(stderr,"CMD: %s\n",cmd.data());
		MyProcess
			*proc = new MyProcess(0,false);

		*proc << cmd.data();
		bool result = proc->start(KProcess::Block, KProcess::NoCommunication);
		Helpers::removeTempFiles(tmpfilenames);
		if(!result) {
			QString str;
			str.sprintf(i18n("Cannot start a new program\nfork() failed."));
			QMessageBox::critical(this,"KSendFax",str.data());
			if (proc) {
				if(proc->isRunning())
					proc->kill();
				delete proc;
				proc = 0;
			}
		}
		if (proc)
			delete proc;
		if (!ktf1.file()->size()) {
			QString str;
			str.sprintf(i18n("Error with convert script!"));
			QMessageBox::critical(this,"KSendFax",str.data());
			return false;
		}
		fnames = tmpfilenames = ktf1.name();
		ktf1.setAutoDelete(false);
	}

	MyProcess * proc = new MyProcess(0,false);

	cmd = config->readEntry("preview_command");
	if (cmd.isEmpty())
		cmd = "kghostview @@FName";
	cmd.replace(QRegExp("@@FName"), fnames.join(" "));

	*proc << cmd.data();
	if (!debugFlag.isEmpty())
		fprintf(stderr,"PreviewCMD: %s\n",cmd.data());
	bool result;
	if (!tmpfilenames.isEmpty()) {
		proc->setLocalData(tmpfilenames);
		connect(proc, SIGNAL(processExited(KProcess *)),this,
				SLOT(PreviewDocDone(KProcess*)));
		result=proc->start(KProcess::NotifyOnExit , KProcess::NoCommunication);
	} else {
		result=proc->start(KProcess::DontCare , KProcess::NoCommunication);
	}
	if(!result) {
		ktf1.setAutoDelete(true);
		QString str;
		str.sprintf(i18n("Cannot start a new program\nfork() failed."));
		QMessageBox::critical(this,"KSendFax",str.data());
		if(proc->isRunning())
			proc->kill();
		delete proc;
		return false;
	}
	return true;
}


bool KSendFaxView::editDoc()
{
	QString fname = dlg->selectedFile();
	if (!fname.isEmpty() && !isTextFile(fname)) {
		QString msg;
		msg.sprintf("%s is no text/* mime type", fname.data());
		int ret = QMessageBox::warning( this, "KSendFax", msg,
										i18n("Create New"), i18n("Use Anyway"),
										i18n("Cancel"), 0, 3);
		switch(ret) {
		case 0:
			fname = QString();
			break;
		case 2:
			return false;
		default:
			break;
		}
	}
	if (fname.isEmpty())
		fedit->init();
	else
		fedit->load(fname);
	if (fedit->exec() == QDialog::Rejected) {
		if (fname.isEmpty())
			fedit->removeTmpFile();
		return false;
	}
	if (fname.isEmpty()) { // add the newly created file to the filelist
		fname = fedit->fileName();
		dlg->filename(dlg->nooffiles(), fname);
	}
	return true;
}


void KSendFaxView::PreviewDocDone(KProcess *proc)
{
	if (!proc)
		return;
	MyProcess *mproc = (MyProcess*)proc;

	Helpers::removeTempFiles(mproc->localData());
	if (!debugFlag.isEmpty())
		fprintf(stderr, "Called PreviewDocDone\n");
	if(proc->isRunning()) {
		proc->kill();
	}
	delete mproc;
}


bool KSendFaxView::checkExcludeConvert(QString mime) const
{
	QStringList exlist;

	Helpers::special_exclude_load(exlist);
	QStringList::ConstIterator it;
	for(it = exlist.begin(); it != exlist.end(); ++it) {
		if ((*it) == mime)
			return true;
	}
	return false;
}


bool KSendFaxView::checkAlwaysConvert(QString mime) const
{
	QStringList allist;

	Helpers::special_always_load(allist);
	QStringList::ConstIterator it;
	for(it = allist.begin(); it != allist.end(); ++it) {
		if ((*it) == mime)
			return true;
	}
	return false;
}


bool KSendFaxView::isTextFile(QString fname) const
{
	if (fname.isEmpty())
		return false;
	KURL url;
	QFileInfo fi1(fname);

	url.setPath(fi1.absFilePath());
	KFileItem fi(0, 0, url);
	if (!debugFlag.isEmpty())
		fprintf(stderr, "MIMETXT: %s=%s\n",fname.data(), fi.mimetype().data());
	return (fi.mimetype().left(5) == "text/");
}


bool KSendFaxView::getConverterCmd(QString const mimeType, QString & cmd) const
{
	QFile	f(locate("data","ksendfax/faxfilters"));
	if (f.exists() && f.open(IO_ReadOnly))
	{
		QTextStream	t(&f);
		QString line;
		int p = -1;
		QString mtype;
		QString mcmd;

		while (!t.eof()) {
			line = t.readLine().stripWhiteSpace();
			if ((p=line.find(QRegExp("\\s"))) != -1) {
				mtype = line.left(p);
				if (mimeType.find(QRegExp(mtype)) != -1) {
					cmd = line.right(line.length()-p-1).stripWhiteSpace();
					if ((p=cmd.find(QRegExp("\\s"))) != -1)
						mcmd = cmd.left(p);
					else
						mcmd = cmd;
					return Helpers::findProgram(mcmd);
				}
			}
		}
	}
	return false;
}


QString KSendFaxView::pbType()
{
	readConfig();
	return phonebook_type;
}


bool KSendFaxView::setFileList(QStringList & fnames, QStringList &tmpfilenames,
							   bool convertAll)
{
	QString filename = dlg->filename();
	QString psname;

	fnames.clear();
	tmpfilenames.clear();
	///
	// check if a cover page is requested
	///
	QString coverFile = kapp->config()->readEntry("coverpage_file");
	if (!coverFile.isEmpty()) {
		if (convertToPSIfNeeded(coverFile, psname, true, true) &&
			!psname.isEmpty())
		{
			fnames += psname;
			if (coverFile != psname)
				tmpfilenames += psname;
		}
	}
	///
	// now add all other files if present. Note that one could only send
	// a coverpage if he likes to do so!
	///
	if (dlg->nooffiles() > 0) {
		for(int i = dlg->nooffiles(); i > 0; --i) {
			filename = dlg->filename(dlg->nooffiles()-i);
			if (filename.isEmpty())
			    continue;
			if (!convertToPSIfNeeded(filename, psname, convertAll))
				return false;
			if (psname.isEmpty()) // means skip this file!
				continue;
			fnames += psname;
			if (psname != filename)
				tmpfilenames += psname;
		}
	} else if (!filename.isEmpty()) {
		if (!convertToPSIfNeeded(filename, psname, convertAll) ||
			psname.isEmpty())
		{
			return false;
		}
		fnames += psname;
		if (filename != psname)
			tmpfilenames += psname;
	}
	
	if (fnames.isEmpty())
		return false;

	return true;
}


void KSendFaxView::getColumnNumbers(int & cFax, int & cNam, int & cEnt) const
{
	QString str;
	
	cNam = cFax = cEnt = 0;
	for(int i = 0; i < 3; ++i) {
		str = dlg->pbListView()->columnText(i);
		if (str == i18n("Name"))
			cNam = i;
		else if (str == i18n("Fax Number"))
			cFax = i;
		else if (str == i18n("Enterprise"))
			cEnt = i;
	}
}
