/***************************************************************************
                          ksendfaxview.h  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSENDFAXVIEW_H
#define KSENDFAXVIEW_H

#include <map>

#include <qstring.h>
#include <qstringlist.h>
#include <qvbox.h>
#include <qdir.h>

#include <kabc/addressbook.h>
#include <kabc/addressee.h>

class QVBoxLayout;
class KSendFaxDlg;
class QLabel;
class KProcess;
class QListViewItem;
class QLineEdit;
class LogListBox;
class QImage;
class FormEdit;

class KSendFaxView : public QVBox // QWidget
{
	Q_OBJECT
public:
    enum {
        OPEN_READWRITE 	= 1, 
        OPEN_READONLY 	= 2, 
        OPEN_INSERT	= 4
    };

	/** Constructor for the main view */
    KSendFaxView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KSendFaxView();

    bool showFileList(bool flag);

    int sendFax();
    int showJobs();
    int removeJob();
    bool scanDoc();
	bool previewDoc();
	bool editDoc();
    void saveOptions();
	bool setFileName(const char * name);
	// phonebook functions
    bool pbShow(bool flag);
    bool pbEdit();
    bool pbLoad();
    bool pbAdd();
    bool pbModify();
    bool pbRemove();
    bool pbSave();
	QString pbType();
	
    void readConfig();

	bool
		showPB,
		showFL;

protected:
#ifdef USE_KAB
	struct MyPBEntry {
		int number;
		KABC::Addressee entry;
		bool modified;
		bool deleted;
	};
#endif
	
    void setPos(QLabel *lab, QLineEdit *le);
    const char *askID();
	bool regenerate(bool old_showFL);
	QListViewItem * pbSearch();

signals:
    void ExitKSendFax();

protected slots:
	void readAddressBook();
    void SendFaxCB();
    void ReadStderr(KProcess *, char *buffer, int buflen);
    void ReadStdout(KProcess *, char *buffer, int buflen);
    void SendFaxDone(KProcess*);
    void slotScanned(const QImage &, int);
    void XSaneDone(KProcess*);
    void PreviewDocDone(KProcess*);

private:
	bool convertToPSIfNeeded(QString fname, QString & psfile,
	                         bool convertAll = false, bool checkTags = false);
	bool isPostscriptFile(QString fname) const;
	bool isTextFile(QString fname) const;
	bool isMimeType(QString const fname, QString const mimeType) const;
	bool getConverterCmd(QString const mimeType, QString & cmd) const;
	bool checkExcludeConvert(QString mime) const;
	bool checkAlwaysConvert(QString mime) const;
	bool setFileList(QStringList & fnames, QStringList & tmpfilenames,
					 bool convertAll = false);
	void getColumnNumbers(int & cFax, int & cNam, int & cEnt) const;
	
	///
	/// variable declarations
	///
    QString
		tmpfname,
        sendcmd,
        showcmd,
        removecmd,
        logdir,
		phonebook_type,
        phonebook;
	QStringList
		tmpFileList;
    LogListBox
        *show_listbox,
        *remove_listbox,
        *error_listbox;
	FormEdit
		* fedit;
    int
        updateSeconds;
	QDir
		workdir;

	QVBoxLayout * v_layout;
	KSendFaxDlg * dlg;
#ifdef USE_KAB
	std::map<int, MyPBEntry> pb_entries;
#endif
};

#endif // KSENDFAXVIEW_H
