/***************************************************************************
                          loglistbox.cpp  -  description
                             -------------------
    begin                : Mon Aug 28 2000
    copyright            : (C) 2000 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapp.h>
#include <qfile.h>
#include <qtstream.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qlistbox.h>

#include <kapp.h>
#include <klocale.h>

#include "loglistbox.h"
#include "myprocess.h"

extern QString debugFlag;

#define Inherited LogListBoxData

LogListBox::LogListBox(QWidget* parent,	const char* name)
	:Inherited( parent, name )
{
    if (name)
        setCaption(name);
    timerID=0;
    timerUpdate=0;
    clearBox = true;
}


LogListBox::~LogListBox()
{
}

void LogListBox::load(const char *fileName)
{
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
        return;

    logListBox->setAutoUpdate(false);
    logListBox->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
        QString s = t.readLine();
        logListBox->insertItem( s );
    }
    f.close();

    logListBox->setAutoUpdate( TRUE );
    logListBox->repaint();
    setCaption( fileName );
}

void LogListBox::insertItem(const char *text)
{
    logListBox->insertItem(text);
    logListBox->repaint();
}

void LogListBox::changeItem(const char *text, int index)
{
    logListBox->changeItem(text, index);
    logListBox->repaint();
}

void LogListBox::clear()
{
    logListBox->clear();
}

void LogListBox::CommandDone(KProcess *proc)
{
    if (!proc)
        return;
    MyProcess *mproc = static_cast<MyProcess*>(proc);
    QString
        s;

    if (!debugFlag.isEmpty()) {
        printf("Called CommandDone\n");
        fprintf(stderr,"SSE:%s\n",mproc->stderr_str.data());
        fprintf(stdout,"SSO:%s\n",mproc->stdout_str.data());
    }
    if (clearBox)
        clear();
	if (!mproc->stdout_str.isEmpty()) {
		QTextStream
			tso(&mproc->stdout_str,IO_ReadOnly);
		s = tso.readLine();
		while(!tso.eof()) {
			insertItem(s);
			s = tso.readLine();
		}
		if (!s.isEmpty())
			insertItem(s);
	}
	if (!mproc->stderr_str.isEmpty()) {
		QTextStream
			tse(&mproc->stderr_str,IO_ReadOnly);
		s = tse.readLine();
		while(!tse.eof()) {
			insertItem(s);
			s = tse.readLine();
		}
		if (!s.isEmpty())
			insertItem(s);
	}
    if(proc->isRunning())
        proc->kill();
    delete proc;
    show();
}

void LogListBox::setCommand(const char *cmd)
{
    command = cmd;
}

bool LogListBox::activateCommand(bool clear_box)
{
    clearBox = clear_box;
    if (command.isEmpty())
        return false;

    if (!timerID && (timerUpdate > 0)) {
        if (!(timerID = startTimer(timerUpdate)))
            QMessageBox::warning(this,"KSendFax",i18n("Cannot start TIMER"));
    }

    MyProcess
        *proc = new MyProcess;

    *proc << command.data();
    connect(proc, SIGNAL(processExited(KProcess *)),this,
            SLOT(CommandDone(KProcess*)));

    bool result = proc->start(KProcess::NotifyOnExit , KProcess::All);
    if(!result){
        QString str;
        str.sprintf(i18n("Cannot start a new program\nfork() failed."));
        QMessageBox::critical(this,"KSendFax",str.data());
        if (proc) {
            if(proc->isRunning())
                proc->kill();
            delete proc;
        }
        return false;
    }
    return true;
}

void LogListBox::deactivateCommand()
{
    if (timerID)
        killTimer(timerID);
    timerID = 0;
}

void LogListBox::timerEvent(QTimerEvent *)
{
    activateCommand();
}

void LogListBox::setTimerUpdate(int t)
{
    timerUpdate = t;
}

void LogListBox::hideBox()
{
    if (timerID > 0)
        killTimer(timerID);
    timerID = 0;
    hide();
}

const char *LogListBox::text(int index)
{
    return logListBox->text(index);
}

int LogListBox::currentItem() const
{
    return logListBox->currentItem();
}

void LogListBox::setCurrentItem(int index)
{
    logListBox->setCurrentItem(index);
}

void LogListBox::setBottomItem()
{
    logListBox->setBottomItem(logListBox->count());
}

uint LogListBox::count()
{
    return logListBox->count();
}
