/***************************************************************************
                          loglistbox.h  -  description
                             -------------------
    begin                : Mon Aug 28 2000
    copyright            : (C) 2000 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LogListBox_included
#define LogListBox_included

#include "dialogs/loglistboxdata.h"

class KProcess;

class LogListBox : public LogListBoxData
{
    Q_OBJECT

public:

    LogListBox(QWidget* parent = NULL, const char* name = NULL);
    virtual ~LogListBox();
    void load(const char* fileName);
    void insertItem(const char* text);
    void changeItem(const char* text, int index);
    void clear();
    void setCommand(const char *cmd);
    bool activateCommand(bool clear_box=true);
    void deactivateCommand();
    void setTimerUpdate(int t);
    const char *text(int index);
    int currentItem() const;
    void setCurrentItem(int index);
    void setBottomItem();
    uint count();

protected slots:
    void CommandDone(KProcess *proc);
    void timerEvent(QTimerEvent *);
    void hideBox();
 
private:
    QString
        command;
    int
        timerUpdate,
        timerID;
    bool
        clearBox;
};
#endif // LogListBox_included
