/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 14:07:52 CEST 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qstring.h>
#include <qfile.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kimageio.h>

#include "ksendfax.h"
#include "wizard.h"

static const char *description =
I18N_NOOP("KSendFax is a program for sending facsimiles (faxes),\nusing as backends faxserver packeges like f.ex. HylaFax, mgetty+sendfax, efax.\n\nYou can send existing files, scan new files with an attached scanner or create\nnew text files from within KSendFax and send them to one or more destinations.\n\nYou can preview the files you want to send as one document and may be able\nto print them from the previewer.\n\nYou can also prepend a cover page or send only a cover page if you need to.\n\nEnjoy the program,");
	
static KCmdLineOptions options[] =
{
	{ "o", 0, 0 },
	{ "!oneshot", I18N_NOOP("quit/exit KSendFax after sending one fax"), 0 },
	{ "wizard", I18N_NOOP("lauch the wizard for doing configuration"), 0 },
	{ "+{filename}", I18N_NOOP("file(s) to fax"), 0 },
	{ 0, 0, 0 }
};

QString debugFlag;
bool oneShotFlag = false;

int main(int argc, char *argv[])
{
    debugFlag = getenv("DEBUG");

	KAboutData aboutData( "ksendfax", I18N_NOOP("KSendFax"),
						  VERSION, description, KAboutData::License_GPL,
						  "(c) 2001, Jrgen Vigna", 0, 0, "jug@lyx.org");
	aboutData.addAuthor("Juergen Vigna", 0 , "jug@lyx.org");
	aboutData.addCredit("Susana, my wife, who supported me coding this program");
	aboutData.addCredit("Mark S Parrish, who supported me with ideas/wishes and financial help to realize them");
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options); // Add our own options.

	KApplication app;
	bool wizard_launched = false;

	kapp->config()->setGroup("ksendfax");
	if (kapp->config()->readEntry("fax_package").isEmpty()) {
		Wizard wizard;
		wizard.exec();
		wizard_launched = true;
	}
	
	if (app.isRestored()) {
		RESTORE(KSendFaxApp);
	} else {
		KSendFaxApp *ksendfax = new KSendFaxApp();
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->isSet("oneshot"))
			oneShotFlag = true;
		if (args->isSet("wizard") && !wizard_launched) {
			Wizard wizard;
			wizard.exec();
		}
		for(int i=0; i < args->count(); ++i) {
			ksendfax->openDocumentFile(QFile::decodeName(args->arg(i)));
		}
		args->clear();
		ksendfax->show();
	}
	KImageIO::registerFormats();
	return app.exec();
}  
