/*
 *   ksendfax - showing MagicBuses around
 *   Copyright (C) 1998-2000  Jrgen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include "myprocess.h"

MyProcess::MyProcess(const char *shellname, bool init):
	KShellProcess(shellname)
{
    row = 0;
    if (init) {
        connect(this, SIGNAL(receivedStderr(KProcess *,char*,int)),this, 
                SLOT(ReadStderr(KProcess*,char*,int)));
        connect(this, SIGNAL(receivedStdout(KProcess *,char*,int)),this, 
                SLOT(ReadStdout(KProcess*,char*,int)));
    }
}


void MyProcess::setLocalData(const QStringList & data)
{
    localData_ = data;
}

const QStringList & MyProcess::localData() const
{
	return localData_;
}

void MyProcess::ReadStderr(KProcess *, char *buffer, int buflen)
{
    QString
        s = buffer;

	s.truncate(buflen);
    stderr_str += s;
}

void MyProcess::ReadStdout(KProcess *, char *buffer, int buflen)
{
    QString
        s = buffer;

	s.truncate(buflen);
    stdout_str += s;
}
