/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998-2000  Jrgen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MyProcess_included
#define MyProcess_included

#include <qstringlist.h>

#include <kprocess.h>

class MyProcess : public KShellProcess
{
	Q_OBJECT

public:
	MyProcess(const char *shellname=NULL, bool init=true);
	void setLocalData(const QStringList &);
	const QStringList & localData() const;
	
	int row;
	QString stderr_str;
	QString stdout_str;

protected:
	int childOutput(int fdno);
	int childError(int fdno);

protected slots:
	void ReadStderr(KProcess *, char *buffer, int buflen);
	void ReadStdout(KProcess *, char *buffer, int buflen);

private:
	QStringList localData_;

};
#endif // MyProcess_included
