#ifndef MYSCAN_H
#define MYSCAN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qimage.h>
#ifdef HAVE_SANE
#include <kscan.h>
#endif

class ScanParams;
class KScanDevice;
class Previewer;
class QCheckBox;

#ifndef HAVE_SANE
#define KScanDialog QWidget
#define KScanDialogFactory QWidget
#include <qwidget.h>
#endif
class MyScanDialog : public KScanDialog
{
   Q_OBJECT

public:
   MyScanDialog( QWidget *parent=0, const char *name=0, bool modal=false );
   ~MyScanDialog();

   virtual bool setup();

private:
   void createOptionsTab( void );
      
private slots:
   void slotFinalImage(QImage *);
   void slotNewPreview( QImage *);
   void slotAskOnStartToggle(bool state);
   void slotNetworkToggle( bool state);
private:
   ScanParams   *m_scanParams;
   KScanDevice  *m_device;
   Previewer    *m_previewer;
   QImage       m_previewImage;
   bool         good_scan_connect;
   QCheckBox    *cb_askOnStart;
   QCheckBox    *cb_network;
   class ScanDialogPrivate;
   ScanDialogPrivate *d;
};

class ScanDialogFactory : public KScanDialogFactory
{
public:
   ScanDialogFactory( QObject *parent=0, const char *name=0 );

protected:
#ifdef HAVE_SANE
   virtual KScanDialog * createDialog( QWidget *parent=0, const char *name=0,
				       bool modal=false );
#endif

};

#endif // MYSCAN_H
