/***************************************************************************
                          preferences.h  -  description
                             -------------------
    begin                : Mon Aug 28 2000
    copyright            : (C) 2000 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef Preferences_included
#define Preferences_included

#include <qstringlist.h>

#include <kdialogbase.h>

#include "prefstate.h"

class FormFax;
class FormSpecial;
class FormScanner;
class FormPersonal;
class FormPhonebook;
class FormMisc;
class FormFilters;


class Preferences : public KDialogBase
{
	Q_OBJECT

public:
    enum Page
	{
		page_fax = 0,
		page_special,
		page_scanner,
		page_personal,
		page_phonebook,
		page_misc,
		page_filters,
		page_max
    };

    Preferences( QWidget *parent = 0, char *name = 0, bool modal = false );
    ~Preferences( void );

    void setState(const PrefState &);
	void restoreState();
	
protected slots:
    virtual void slotDefault(void);
    virtual void slotOk(void);
	virtual void slotApply(void);
	virtual void slotCancel(void);
    virtual void slotHelp(void);
	virtual void filters_slotAdd(void);
	virtual void filters_slotRemove(void);
	virtual void filters_slotChange(void);
	virtual void filters_slotUp(void);
	virtual void filters_slotDown(void);
	virtual void special_exclude_slotAdd(void);
	virtual void special_exclude_slotRemove(void);
	virtual void special_exclude_slotChange(void);
	virtual void special_always_slotAdd(void);
	virtual void special_always_slotRemove(void);
	virtual void special_always_slotChange(void);

protected:
	void addFormFax();
	void addFormSpecial();
	void addFormScanner();
	void addFormPersonal();
	void addFormPhonebook();
	void addFormMisc();
	void addFormFilters();

	void setPrefFax(const PrefFaxState &);
	void setPrefSpecial(const PrefSpecialState &);
	void setPrefScanner(const PrefScannerState &);
	void setPrefPersonal(const PrefPersonalState &);
	void setPrefPhonebook(const PrefPhonebookState &);
	void setPrefMisc(const PrefMiscState &);
	void setPrefFilters(const PrefFiltersState &);

signals:
    void PBChanged();
	
private:
	FormFax * ffax;
	FormSpecial * fspecial;
	FormScanner * fscanner;
	FormPersonal * fpersonal;
	FormPhonebook * fphonebook;
	FormMisc * fmisc;
	FormFilters * ffilters;

	PrefState pState;
};

#endif
