/***************************************************************************
                          prefstate.h  -  description
                             -------------------
    begin                : Mon Nov 7 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PrefState_included
#define PrefState_included

#include <cstdio>
#include <cstdlib>

#include <vector>

#include <qstring.h>
#include <qstringlist.h>

#include <kapp.h>
#include <kstddirs.h>
#include <kconfig.h>

struct PrefFaxState
{
	typedef struct defaults
	{
		QString sendcmd;
		QString showcmd;
		QString removecmd;
	};
	PrefFaxState(void)
	{
		hylafax.sendcmd = sendcmd = "sendfax -n -h '@@Host' -c '@@Comment' " \
			"-x '@@Enterprise' -d '@@Name'@'@@Phone' @@FName";
		hylafax.showcmd = showcmd = "faxstat -h '@@Host'";
		hylafax.removecmd = removecmd = "faxrm -h '@@Host' @@ID";
		efax.sendcmd = "fax send '@@Phone''@@FName'";
		mgetty.sendcmd = "faxspool -F '@@From' '@@Phone''@@FName'";
		mgetty.showcmd = "faxq";
		mgetty.removecmd = "faxrm @@ID";
		updatesecs = 0;
		useps = true;
	}

	QString sendcmd;
	QString showcmd;
	QString removecmd;
	QString coverfile;
	unsigned int updatesecs;
	bool useps;
	/// default entries for different know faxpackages
	defaults hylafax;
	defaults efax;
	defaults mgetty;
};


struct PrefSpecialState
{
	PrefSpecialState(void)
	{
		excludeps = true;
		alwaysps = true;
	}

	bool excludeps;
	bool alwaysps;
	QStringList exlist;
	QStringList allist;
};


struct PrefScannerState
{
	enum ScannerImageType
	{
		postscript = 0,
		tiff       = 1
	};

	PrefScannerState(void)
	{
		type = postscript;
		use_external = false;
		cmd = default_xsane = "xsane -N @@FName";
		default_xscanimage = "xscanimage";
	}

	ScannerImageType type;
	bool    use_external;
	QString cmd;
	QString default_xsane;
	QString default_xscanimage;
};


struct PrefPersonalState
{
	QString name;
	QString enterprise;
	QString phone;
};


struct PrefPhonebookState
{
	enum PhonebookType
	{
		ksendfax = 0,
		kaddressbook = 1
	};

	PrefPhonebookState(void)
	{
		type = ksendfax;
		file = getenv("PHONEBOOK");
		if (file.isEmpty()) {
			file = getenv("HOME");
			file += "/.phonebook";
		}
	}

	PhonebookType type;
	QString file;
};


struct PrefMiscState
{
	PrefMiscState(void)
	{
		KStandardDirs ksd;
		logdir = ksd.findResourceDir("tmp","");
		if (logdir.isEmpty())
			logdir = "/tmp";
		previewcmd = default_gv = "gv @@FName";
		default_kghostview = "kghostview @@FName";
		default_ghostview = "ghostview @@FName";
		datefmt = "%a %b %d %T %Y";
		convertcmd = "convert @@FName @@TmpFName";
	}

	QString logdir;
	QString previewcmd;
	QString datefmt;
	QString default_kghostview;
	QString default_gv;
	QString default_ghostview;
	QString convertcmd;
};


struct PrefFiltersState
{
	struct Filters
	{
		QString mimetype;
		QString mimecmd;
	};
	
	std::vector<Filters> filters;
};


struct PrefState
{
	QString            faxpackage;
	PrefFaxState       fax;
	PrefSpecialState   special;
	PrefScannerState   scanner;
	PrefPersonalState  personal;
	PrefPhonebookState phonebook;
	PrefMiscState      misc;
	PrefFiltersState   filters;
};

#endif
