/***************************************************************************
                          wizard.cpp  -  description
                             -------------------
    begin                : Tue Nov 20 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstdio>

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qtoolbutton.h>
#include <qfile.h>
#include <qlistbox.h>
#include <qradiobutton.h>
#include <qdir.h>
#include <qfileinfo.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kapp.h>

#include "wizard.h"
#include "prefstate.h"
#include "filterdlg.h"
#include "helpers.h"
#include "filterdlg.h"
#include "dialogs/formfax.h"
#include "dialogs/formspecial.h"
#include "dialogs/formscanner.h"
#include "dialogs/formpersonal.h"
#include "dialogs/formphonebook.h"
#include "dialogs/formmisc.h"
#include "dialogs/formfilters.h"

using std::vector;

extern QString debugFlag;

Wizard::Wizard(QWidget *parent, char *name, bool modal)
	: FormWizard(parent, name, modal)
{
	setFinishEnabled(page11, true);

	Helpers::readConfig(pState, true);
	setState(pState);
	///
	// fill the fax-cover combobox with files in the cover directory
	///
	ffax->comboCoverPage->clear();
	ffax->comboCoverPage->insertItem(i18n("Use cover feature of fax package"));
	QDir coverdir(locate("data","ksendfax/coverpages/"));
	coverdir.setFilter(QDir::Files);
	const QFileInfoList *list = coverdir.entryInfoList();
	if (list) {
		for(QFileInfoListIterator it(*list); it.current(); ++it) {
			ffax->comboCoverPage->insertItem(it.current()->filePath());
			if (!debugFlag.isEmpty())
				fprintf(stderr, "%s\n", it.current()->filePath().data());
		}
	}
	///
	// check for used commands and set the output page (page2)
	///
	checkCommands();
	///
	// set fax package selection page (page3)
	///
	QString const msg = i18n(" (may not be installed)");
	QString str;

	if (pState.faxpackage == "HylaFax")
		radioHylafax->setChecked(true);
	else if (pState.faxpackage == "EFax")
		radioEfax->setChecked(true);
	else if (pState.faxpackage == "MGetty")
		radioMgetty->setChecked(true);
	else
		radioOther->setChecked(true);
	
	if (hf_faxstat.isEmpty()) {
		str = radioHylafax->text() + msg;
		radioHylafax->setText(str);
	}
	if (ef_fax.isEmpty()) {
		str = radioEfax->text() + msg;
		radioEfax->setText(str);
	}
	if (mg_faxspool.isEmpty()) {
		str = radioMgetty->text() + msg;
		radioMgetty->setText(str);
	}
	///
	// set found scanner command (page7)
	///
	if (pState.scanner.cmd.isEmpty()) {
		if (!sc_xsane.isEmpty())
			fscanner->InputScanCmd->setText(pState.scanner.default_xsane);
		else if (!sc_xscanimage.isEmpty())
			fscanner->InputScanCmd->setText(pState.scanner.default_xscanimage);
	}
	///
	// set found preview command (page9)
	///
	if (pState.misc.previewcmd.isEmpty()) {
		if (!ps_gv.isEmpty())
			fmisc->InputPreviewCmd->setText(pState.misc.default_gv);
		else if (!ps_kghostview.isEmpty())
			fmisc->InputPreviewCmd->setText(pState.misc.default_kghostview);
		else if (!ps_kghostview.isEmpty())
			fmisc->InputPreviewCmd->setText(pState.misc.default_ghostview);
	}
	
	/// connections
	connect(ffilters->lv_filters, SIGNAL(doubleClicked(QListViewItem*)), this,
	        SLOT(filters_slotChange()));
	connect(ffilters->buttonAdd, SIGNAL(clicked()), this,
	        SLOT(filters_slotAdd()));
	connect(ffilters->buttonChange, SIGNAL(clicked()), this,
	        SLOT(filters_slotChange()));
	connect(ffilters->buttonRemove, SIGNAL(clicked()), this,
	        SLOT(filters_slotRemove()));
	connect(ffilters->buttonMoveUp, SIGNAL(clicked()), this,
	        SLOT(filters_slotUp()));
	connect(ffilters->buttonMoveDown, SIGNAL(clicked()), this,
	        SLOT(filters_slotDown()));
}

Wizard::~Wizard(void)
{
}


void Wizard::accept(void)
{
	///
	// fax part
	///
	pState.fax.sendcmd = ffax->InputFaxCommand->text();
	pState.fax.showcmd = ffax->InputShowCommand->text();
	pState.fax.removecmd = ffax->InputRemoveCommand->text();
	pState.fax.updatesecs = ffax->spinUpdateSeconds->value();
	pState.fax.useps = ffax->checkUsePostscript->isOn();
	if (ffax->comboCoverPage->currentItem())
		pState.fax.coverfile = ffax->comboCoverPage->currentText();
	else
		pState.fax.coverfile = QString();
	///
	// special part
	///
	pState.special.excludeps = fspecial->checkExcludeConvert->isOn();
	pState.special.alwaysps = fspecial->checkAlwaysConvert->isOn();
	pState.special.exlist.clear();
	QListBoxItem * box = fspecial->listExcludeConvert->firstItem();
	while(box) {
		pState.special.exlist.append(box->text());
		box = box->next();
	}
	pState.special.allist.clear();
	box = fspecial->listAlwaysConvert->firstItem();
	while(box) {
		pState.special.allist.append(box->text());
		box = box->next();
	}
	///
	// personal part
	///
	pState.personal.name       = fpersonal->InputName->text();
	pState.personal.enterprise = fpersonal->InputEnterprise->text();
	pState.personal.phone      = fpersonal->InputPhone->text();
	///
	// scanner part
	///
	pState.scanner.type = (PrefScannerState::ScannerImageType)fscanner->comboScanType->currentItem();
	pState.scanner.cmd = fscanner->InputScanCmd->text();
	pState.scanner.use_external = fscanner->checkUseExtProg->isOn();
	///
	// phonebook part
	///
	pState.phonebook.file = fphonebook->InputPhonebook->text();
	pState.phonebook.type = (PrefPhonebookState::PhonebookType)fphonebook->comboPBType->currentItem();
	///
	// misc part
	///
	pState.misc.logdir     = fmisc->InputLogdir->text();
	pState.misc.previewcmd = fmisc->InputPreviewCmd->text();
	pState.misc.datefmt    = fmisc->InputDateFormat->text();
	pState.misc.convertcmd = fmisc->InputConvertCmd->text();
	///
	// filters part
	///
	pState.filters.filters.clear();
	QListViewItem *item = ffilters->lv_filters->firstChild();
	PrefFiltersState::Filters data;
	while (item) {
		data.mimetype = item->text(0);
		data.mimecmd = item->text(1);
		pState.filters.filters.push_back(data);
		item = item->nextSibling();
	}
	
	Helpers::writeConfig(pState);

	QWizard::accept();
}


void Wizard::reject(void)
{
	QWizard::reject();
}


void Wizard::help(void)
{
	kapp->invokeHTMLHelp("ksendfax/ksendfax.html", "");
}


void Wizard::next(void)
{
	if (currentPage()->name() == QString("page3")) {
		setPrefFax(pState.fax);
		if (radioHylafax->isChecked() && pState.faxpackage != "HylaFax") {
			ffax->InputFaxCommand->setText(pState.fax.hylafax.sendcmd);
			ffax->InputShowCommand->setText(pState.fax.hylafax.showcmd);
			ffax->InputRemoveCommand->setText(pState.fax.hylafax.removecmd);
		} else if (radioEfax->isChecked() && pState.faxpackage != "EFax") {
			ffax->InputFaxCommand->setText(pState.fax.efax.sendcmd);
			ffax->InputShowCommand->setText(pState.fax.efax.showcmd);
			ffax->InputRemoveCommand->setText(pState.fax.efax.removecmd);
		} else if (radioMgetty->isChecked() && pState.faxpackage != "MGetty") {
			ffax->InputFaxCommand->setText(pState.fax.mgetty.sendcmd);
			ffax->InputShowCommand->setText(pState.fax.mgetty.showcmd);
			ffax->InputRemoveCommand->setText(pState.fax.mgetty.removecmd);
		} else if (radioOther->isChecked() &&
				   ((pState.faxpackage == "MGetty") ||
				   (pState.faxpackage == "EFax") ||
					(pState.faxpackage == "HylaFax")))
		{
			ffax->InputFaxCommand->clear();
			ffax->InputShowCommand->clear();
			ffax->InputRemoveCommand->clear();
		}
	}
	QWizard::next();
}


void Wizard::setPrefFax(const PrefFaxState & fax)
{
	ffax->InputFaxCommand->setText(fax.sendcmd);
	ffax->InputShowCommand->setText(fax.showcmd);
	ffax->InputRemoveCommand->setText(fax.removecmd);
	ffax->spinUpdateSeconds->setValue(fax.updatesecs);
	ffax->checkUsePostscript->setChecked(fax.useps);
	ffax->comboCoverPage->setCurrentItem(0);
	if (!fax.coverfile.isEmpty()) {
		for(int i=1; i < ffax->comboCoverPage->count(); ++i) {
			if (ffax->comboCoverPage->text(i) == fax.coverfile) {
				ffax->comboCoverPage->setCurrentItem(i);
				break;
			}
		}
	}
}


void Wizard::setPrefSpecial(const PrefSpecialState & special)
{
	fspecial->checkExcludeConvert->setChecked(special.excludeps);
	fspecial->checkAlwaysConvert->setChecked(special.alwaysps);
	QStringList::ConstIterator it;

	fspecial->listExcludeConvert->clear();
	for(it = special.exlist.begin(); it != special.exlist.end(); ++it) {
		fspecial->listExcludeConvert->insertItem((*it));
	}

	fspecial->listAlwaysConvert->clear();
	for(it = special.allist.begin(); it != special.allist.end(); ++it) {
		fspecial->listAlwaysConvert->insertItem((*it));
	}
}


void Wizard::setPrefScanner(const PrefScannerState & scanner)
{
	fscanner->comboScanType->setCurrentItem(scanner.type);
	fscanner->InputScanCmd->setText(scanner.cmd);
#ifdef HAVE_SANE
	fscanner->checkUseExtProg->setChecked(scanner.use_external);
#else
	fscanner->checkUseExtProg->setChecked(true);
	fscanner->checkUseExtProg->setDisabled(true);
#endif
}


void Wizard::setPrefPersonal(const PrefPersonalState & personal)
{
	fpersonal->InputName->setText(personal.name);
	fpersonal->InputEnterprise->setText(personal.enterprise);
	fpersonal->InputPhone->setText(personal.phone);
}


void Wizard::setPrefPhonebook(const PrefPhonebookState & phonebook)
{
	fphonebook->InputPhonebook->setText(phonebook.file);
#ifdef USE_KAB
	fphonebook->comboPBType->setCurrentItem(phonebook.type);
#else
	fphonebook->comboPBType->setCurrentItem(PrefPhonebookState::ksendfax);
	fphonebook->comboPBType->setEnabled(false);
#endif
}


void Wizard::setPrefMisc(const PrefMiscState & misc)
{
	fmisc->InputLogdir->setText(misc.logdir);
	fmisc->InputPreviewCmd->setText(misc.previewcmd);
	fmisc->InputDateFormat->setText(misc.datefmt);
	fmisc->InputConvertCmd->setText(misc.convertcmd);
}


void Wizard::setPrefFilters(const PrefFiltersState & filters)
{
	ffilters->lv_filters->clear();
	vector<PrefFiltersState::Filters>::const_iterator it;
	for(it = filters.filters.begin(); it != filters.filters.end(); ++it) {
		(void)new QListViewItem(ffilters->lv_filters, (*it).mimetype, (*it).mimecmd);
	}
}


void Wizard::setState(const PrefState & state)
{
	setPrefFax(state.fax);
	setPrefSpecial(state.special);
	setPrefScanner(state.scanner);
	setPrefPersonal(state.personal);
	setPrefPhonebook(state.phonebook);
	setPrefMisc(state.misc);
	setPrefFilters(state.filters);
}


///
// FormFilters specific functions!
///

void Wizard::filters_slotAdd()
{
	QString	mime;
	QString cmd;
	if (FilterDlg::doIt(this, &mime, &cmd))
		if (!mime.isEmpty() && !cmd.isEmpty())
			new QListViewItem(ffilters->lv_filters, ffilters->lv_filters->currentItem(), mime, cmd);
		else
			KMessageBox::error(this, i18n("Empty parameters."));
}

void Wizard::filters_slotRemove()
{
	QListViewItem	*item = ffilters->lv_filters->currentItem();
	if (item)
		delete item;
}

void Wizard::filters_slotChange()
{
	QListViewItem	*item = ffilters->lv_filters->currentItem();
	if (item)
	{
		QString	mime(item->text(0)), cmd(item->text(1));
		if (FilterDlg::doIt(this, &mime, &cmd))
		{
			item->setText(0, mime);
			item->setText(1, cmd);
		}
	}
}

void Wizard::filters_slotUp()
{
	QListViewItem	*item = ffilters->lv_filters->currentItem();
	if (item && item->itemAbove())
	{
		QString t0 = item->text(0);
		QString t1 = item->text(1);
		item->setText(0, item->itemAbove()->text(0));
		item->setText(1, item->itemAbove()->text(1));
		item->itemAbove()->setText(0, t0);
		item->itemAbove()->setText(1, t1);
		ffilters->lv_filters->setCurrentItem(item->itemAbove());
	}
}

void Wizard::filters_slotDown()
{
	QListViewItem	*item = ffilters->lv_filters->currentItem();
	if (item && item->itemBelow())
	{
		QString t0 = item->text(0);
		QString t1 = item->text(1);
		item->setText(0, item->itemBelow()->text(0));
		item->setText(1, item->itemBelow()->text(1));
		item->itemBelow()->setText(0, t0);
		item->itemBelow()->setText(1, t1);
		ffilters->lv_filters->setCurrentItem(item->itemBelow());
	}
}


///
// FormSpecial specific functions!
///
///
//  always part
///

void Wizard::special_exclude_slotAdd()
{
	QString	mime;
	if (FilterDlg::doIt(this, &mime))
		if (!mime.isEmpty())
			fspecial->listExcludeConvert->insertItem(mime);
		else
			KMessageBox::error(this, i18n("Empty parameters."));
}

void Wizard::special_exclude_slotRemove()
{
	fspecial->listExcludeConvert->removeItem(fspecial->listExcludeConvert->currentItem());
}

void Wizard::special_exclude_slotChange()
{
	int cur = fspecial->listExcludeConvert->currentItem();
	
	if (cur < 0)
		return;
	QString	mime(fspecial->listExcludeConvert->text(cur));
	if (FilterDlg::doIt(this, &mime)) {
		fspecial->listExcludeConvert->changeItem(mime, cur);
	}
}

///
//  always part
///


void Wizard::special_always_slotAdd()
{
	QString	mime;
	if (FilterDlg::doIt(this, &mime))
		if (!mime.isEmpty())
			fspecial->listAlwaysConvert->insertItem(mime);
		else
			KMessageBox::error(this, i18n("Empty parameters."));
}

void Wizard::special_always_slotRemove()
{
	fspecial->listAlwaysConvert->removeItem(fspecial->listAlwaysConvert->currentItem());
}

void Wizard::special_always_slotChange()
{
	int cur = fspecial->listAlwaysConvert->currentItem();
	
	if (cur < 0)
		return;
	QString	mime(fspecial->listAlwaysConvert->text(cur));
	if (FilterDlg::doIt(this, &mime)) {
		fspecial->listAlwaysConvert->changeItem(mime, cur);
	}
}


void Wizard::checkCommands(void)
{
	///
	// find the commands!
	hf_sendfax    = Helpers::findProgram("sendfax");
	hf_faxstat    = Helpers::findProgram("faxstat");
	hf_faxrm      = Helpers::findProgram("faxrm");
	ef_fax        = Helpers::findProgram("fax");
	mg_faxspool   = Helpers::findProgram("faxspool");
	mg_faxq       = Helpers::findProgram("faxq");
	mg_faxrm      = Helpers::findProgram("faxrm");
	ps_gv         = Helpers::findProgram("gv");
	ps_kghostview = Helpers::findProgram("kghostview");
	ps_ghostview  = Helpers::findProgram("ghostview");
	sc_xsane      = Helpers::findProgram("xsane");
	sc_xscanimage = Helpers::findProgram("xscanimage");
	a2ps          = Helpers::findProgram("a2ps");
	convert       = Helpers::findProgram("convert");
	groff         = Helpers::findProgram("groff");

	// fill the listbox
	QString str;

	listFoundCmds->insertItem(Helpers::findProgram("sendfax",true));
	listFoundCmds->insertItem(Helpers::findProgram("faxstat",true));
	listFoundCmds->insertItem(Helpers::findProgram("faxrm",true));
	listFoundCmds->insertItem(Helpers::findProgram("fax",true));
	listFoundCmds->insertItem(Helpers::findProgram("faxspool",true));
	listFoundCmds->insertItem(Helpers::findProgram("faxq",true));
	listFoundCmds->insertItem(Helpers::findProgram("faxrm",true));
	listFoundCmds->insertItem(Helpers::findProgram("gv",true));
	listFoundCmds->insertItem(Helpers::findProgram("kghostview",true));
	listFoundCmds->insertItem(Helpers::findProgram("ghostview",true));
	listFoundCmds->insertItem(Helpers::findProgram("xsane",true));
	listFoundCmds->insertItem(Helpers::findProgram("xscanimage",true));
	listFoundCmds->insertItem(Helpers::findProgram("a2ps",true));
	listFoundCmds->insertItem(Helpers::findProgram("convert",true));
	listFoundCmds->insertItem(Helpers::findProgram("groff",true));
}
