/***************************************************************************
                          wizard.h  -  description
                             -------------------
    begin                : Tue Nov 20 2001
    copyright            : (C) 2001 by Jrgen Vigna
    email                : jug@lyx.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef Wizard_included
#define Wizard_included

#include "dialogs/formwizard.h"
#include "prefstate.h"

class Wizard : public FormWizard
{
	Q_OBJECT

public:
    Wizard(QWidget *parent = 0, char *name = 0, bool modal = true);
    ~Wizard(void);
    void setState(const PrefState &);
	
protected slots:
    virtual void accept(void);
	virtual void reject(void);
    virtual void help(void);
    virtual void next(void);
	virtual void filters_slotAdd(void);
	virtual void filters_slotRemove(void);
	virtual void filters_slotChange(void);
	virtual void filters_slotUp(void);
	virtual void filters_slotDown(void);
	virtual void special_exclude_slotAdd(void);
	virtual void special_exclude_slotRemove(void);
	virtual void special_exclude_slotChange(void);
	virtual void special_always_slotAdd(void);
	virtual void special_always_slotRemove(void);
	virtual void special_always_slotChange(void);

protected:
	void setPrefFax(const PrefFaxState &);
	void setPrefSpecial(const PrefSpecialState &);
	void setPrefScanner(const PrefScannerState &);
	void setPrefPersonal(const PrefPersonalState &);
	void setPrefPhonebook(const PrefPhonebookState &);
	void setPrefMisc(const PrefMiscState &);
	void setPrefFilters(const PrefFiltersState &);
	void checkCommands();

private:
	PrefState pState;
	QString faxpackage;
	
	QString hf_sendfax;
	QString hf_faxstat;
	QString hf_faxrm;
	QString ef_fax;
	QString mg_faxspool;
	QString mg_faxq;
	QString mg_faxrm;
	QString ps_kghostview;
	QString ps_gv;
	QString ps_ghostview;
	QString sc_xsane;
	QString sc_xscanimage;
	QString a2ps;
	QString convert;
	QString groff;
};

#endif
