/*************************************************************************** 
$Id: ksitecopy.cc,v 1.12 2003/04/26 09:27:06 josswern Exp $
------------------- 
begin : Mon Dec 24 09:05:18 CET 2001 
copyright : (C) 2001 by Werner Joss 
email : werner@hoernerfranzracing.de 
***************************************************************************/

/*************************************************************************** 
* * 
* This program is free software; you can redistribute it and/or modify * 
* it under the terms of the GNU General Public License as published by * 
* the Free Software Foundation; either version 2 of the License, or * 
* (at your option) any later version. * 
* * 
***************************************************************************/

#include "ksitecopy.moc"
#include "parsecfg.h"

#include <kprocess.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kstdaction.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <ksimpleconfig.h>

#include <qfileinfo.h>
#include <qgroupbox.h>
#include <qlayout.h>

#include <stdlib.h>		// for getenv..

ksitecopy::ksitecopy():KMainWindow()
{
    QStringList sites;
    setMinimumSize(200, 200);
    setMaximumSize(32767, 32767);
    ReadSiteList = TRUE;
    forceReadCfg = false;

    if (!readConfig())
	doInitialStartupChecks();
    setupMenuBar();
    if (!d.ToolBarVisible) {
	viewToolBar->setChecked(false);
	toolBar("mainToolBar")->hide();
    }
    initStatusBar();
    init();
}

void ksitecopy::doInitialStartupChecks()
{
    if (!foundExecutable()) {
	KMessageBox::sorry(this, i18n("sitecopy executable not found, ksitecopy will do nothing without this and hence abort now,\n \
		please make sure to first install sitecopy correctly and try again ! "));
	exit(0);
    }

    KMessageBox::information(this,
			     i18n
			     ("This seems to be your first start of ksitecopy, \n \
					 ksitecopy will now try to read the rcfile for sitecopy and \n build a basic configuration set from this, if available !"), "");
    NumSites = readRcFile();
    if (NumSites < 1) {
	KMessageBox::information(this, i18n("No rcfile for sitecopy found, ksitecopy will now \n \
		start the site configuration wizzard\n to let you setup a basic configuration !"), "");	/* , "", "", ""); */
	addsitedlg = new addSitedialog(this, "New Site", &d);
	addsitedlg->show();
    } else {
	if (backupRcFile()) {
	    KMessageBox::information(this, i18n("Ksitecopy found an rcfile for sitecopy and tried to analyse it \n and build its own configuration from this\n \
			- however, it is hardly recommended to check if this is really what you want, \n \
			a backup copy of the original rcfile has been saved as ~/.sitecopyrc.bak !"));	/* , "", "", FALSE); */
	} else {
	    KMessageBox::sorry(this, i18n("could not make a backup copy of your sitecopy rcfile, please check your installation ! "));
	    exit(0);
	}
    }
}
void ksitecopy::setupMenuBar()
{
    KStdAction::quit(this, SLOT(slotExit()), actionCollection(),
		     "file_quit");
    AddSite =
	new KAction(i18n("&Add Site"),
		    BarIcon("addsite", KIcon::SizeSmall), 0, this,
		    SLOT(slotAddSite()), actionCollection(), "AddSite");
    DelSite =
	new KAction(i18n("&Delete Site"),
		    BarIcon("delsite", KIcon::SizeSmall), 0, this,
		    SLOT(slotDelSite()), actionCollection(), "DelSite");
    Site =
	new KAction(i18n("&Run Options"), BarIcon("run", KIcon::SizeSmall),
		    0, this, SLOT(slotSetSite()), actionCollection(),
		    "SelectSite");
    SiteData =
	new KAction(i18n("&Site Configuration"),
		    BarIcon("configure", KIcon::SizeSmall), 0, this,
		    SLOT(slotSiteData()), actionCollection(), "SiteData");
    Start =
	new KAction(i18n("&Start"), BarIcon("start", KIcon::SizeSmall), 0,
		    this, SLOT(slotStart()), actionCollection(), "Start");
    Stop =
	new KAction(i18n("&Stop"), BarIcon("stop", KIcon::SizeSmall), 0,
		    this, SLOT(slotStop()), actionCollection(), "Stop");
    ManPage =
	new KAction(i18n("&man Page"), BarIcon("man", KIcon::SizeSmall), 0,
		    this, SLOT(manpage()), actionCollection(), "Manpage");
    viewToolBar =
	KStdAction::showToolbar(this, SLOT(slotViewToolBar()),
				actionCollection());
    createGUI();
}

bool ksitecopy::backupRcFile()
{
    QFile s(default_rcfile), d(default_rcfile.append(".bak"));

    if (!s.open(IO_ReadOnly))
	return false;
    if (!d.open(IO_WriteOnly | IO_Truncate)) {
	s.close();
	return false;
    }
    while (!s.atEnd()) {
	char buf[1024];
	int len = s.readBlock(buf, 1024);
	len = d.writeBlock(buf, len);
    }
    s.close();
    d.close();
    return true;
}

int ksitecopy::readRcFile()
{
    QString Msg, groupName, Site;
    QStringList::Iterator it;
    int NumSites = 0;

    default_rcfile.sprintf("%s%s", getenv("HOME"), "/.sitecopyrc");
    QFileInfo file(default_rcfile);
    if (!file.exists()) {
// rcfile does not exist - display appr. message here... 
	Msg.append(default_rcfile);
	Msg.append(i18n(" not found !"));
	KMessageBox::sorry(this, Msg, i18n("Error"), FALSE);
	return 0;
    }
    if ((NumSites = readSiteList(default_rcfile, d.SiteList)) < 1) {
	Msg.sprintf(i18n("no Site found in rcfile !"));
	KMessageBox::sorry(this, Msg, i18n("Error"), FALSE);
	return 0;
    }

    if (d.Site.length() < 1) {	// kein Site angeg. 
	it = d.SiteList.begin();
	Site = *it;
    }

    for (it = d.SiteList.begin(); it != d.SiteList.end(); it++) {
	d.Site = *it;
	readSiteCfgData(default_rcfile, d.Site, &s);
	writeConfig();
    }
    if (Site.length() > 0)
	d.Site = Site;
    return NumSites;
}

void ksitecopy::init()
{
    QWidget *mainView = new QWidget(this);

    QVBoxLayout *mainLayout = new QVBoxLayout(mainView);
    mainLayout->setSpacing(0);
    mainLayout->setMargin(0);

    QSplitter *s1 = new QSplitter(QSplitter::Vertical, mainView, "top");
    mainLayout->addWidget(s1);

    stdOutWin = new KEdit(s1, "TextView");
    stdOutWin->setText("");
    stdOutWin->setReadOnly(true);

    connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this,
	    SLOT(getOutput(KProcess *, char *, int)));
    connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this,
	    SLOT(getOutput(KProcess *, char *, int)));
    connect(&proc, SIGNAL(processExited(KProcess *)), this,
	    SLOT(slotFinishCopy()));

    mainView->show();
    this->setCentralWidget(mainView);
}

void ksitecopy::controlSettings(bool enabled)
{
    Start->setEnabled(enabled);
    Site->setEnabled(enabled);
    SiteData->setEnabled(enabled);
}

void ksitecopy::initStatusBar()
{
    QString Status;
    Status.append(i18n("current settings: "));
    Status.append("Site:");
    Status.append(d.Site);
    Status.append(" , ");
    Status.append("Operation Mode:");
    Status.append(d.mode);
    Status.append(" , ");
    Status.append("Option(s):");
    Status.append(d.options);
    statusBar()->removeItem(ID_STATUS_MSG);
    statusBar()->insertItem(Status, ID_STATUS_MSG);
}

void ksitecopy::getOutput(KProcess *, char *data, int len)
{
    QString out(data);
    out.truncate(len);
    out = out.stripWhiteSpace();

    if (!out.isEmpty()) {
	stdOutWin->append(out);
	if (d.logging)
	    logString += out;
    }
    stdOutWin->setCursorPosition(stdOutWin->numLines(), 0);
}

void ksitecopy::closeEvent(QCloseEvent * e)
{
    KMainWindow::closeEvent(e);
}

bool ksitecopy::readConfig()
{
    QString groupName, msg;
    bool found = false;

    config = kapp->config();

    default_rcfile.sprintf("%s%s", getenv("HOME"), "/.sitecopyrc");

    config->setGroup("General Options");
    d.ToolBarVisible = config->readBoolEntry("ToolBarVisible", true);
    if (d.Site.length() == 0)
	d.Site = config->readEntry("Site", "");	// wichtig ! 
    if (d.Site.length() > 0)
	found = true;
    if (d.mode.length() == 0)
	d.mode = config->readEntry("Operation mode", "-u");
    if (d.options.length() == 0)
	d.options = config->readEntry("Options", "-k");
    d.logging = config->readBoolEntry("Logging", false);	// default = no logging 
    if (ReadSiteList)
	d.SiteList = config->readListEntry("SiteList");	// may not read sitelist when writing rcfile ! 
    NumSites = d.SiteList.count();

    groupName.sprintf("Site-");
    groupName.append(d.Site);
    s.Site = d.Site;
    config->setGroup(groupName);
    s.port = config->readEntry("Port", "");
    s.proxy = config->readEntry("Proxy", "");
    s.proxyport = config->readEntry("ProxyPort", "");
    s.protocol = config->readEntry("Protocol", "ftp");
    s.server = config->readEntry("Server", "myServer");
    s.url = config->readEntry("Url", "http://myUrl");
    s.username = config->readEntry("Username", "anonymous");
    s.password = config->readEntry("Password", "");
    s.remote = config->readEntry("Remote", "~");
    s.local = config->readEntry("Local", "~");
    s.exclude = config->readEntry("Exclude", "");
    s.ignore = config->readEntry("Ignore", "");
    s.ascii = config->readEntry("Ascii", "");
    s.permissions = config->readEntry("Permissions", "");
    s.symlinks = config->readEntry("Symlinks", "");
    s.nodelete = config->readBoolEntry("Nodelete", false);
    s.nooverwrite = config->readBoolEntry("Nooverwrite", false);
    s.checkmoved = config->readBoolEntry("checkmoved", false);
    return found;
}

void ksitecopy::writeConfig()
{
    QString groupName, exclude, ignore, ascii;

    config->setGroup("General Options");
    config->writeEntry("ToolBarVisible", d.ToolBarVisible);
    config->writeEntry("Site", d.Site);
    config->writeEntry("SiteList", d.SiteList);
    config->writeEntry("Operation mode", d.mode);
    config->writeEntry("Options", d.options);
    config->writeEntry("Logging", d.logging);

    groupName.sprintf("Site-");
    groupName.append(d.Site);
    config->setGroup(groupName);
    config->writeEntry("Port", s.port);
    config->writeEntry("Proxy", s.proxy);
    config->writeEntry("ProxyPort", s.proxyport);
    config->writeEntry("Protocol", s.protocol);
    config->writeEntry("Url", s.url);
    config->writeEntry("Server", s.server);
    config->writeEntry("Url", s.url);
    config->writeEntry("Username", s.username);
    config->writeEntry("Password", s.password);
    config->writeEntry("Remote", s.remote);
    config->writeEntry("Local", s.local);
    config->writeEntry("Exclude", s.exclude);
    config->writeEntry("Ignore", s.ignore);
    config->writeEntry("Ascii", s.ascii);
    config->writeEntry("Permissions", s.permissions);
    config->writeEntry("Symlinks", s.symlinks);
    config->writeEntry("Nodelete", s.nodelete);
    config->writeEntry("Nooverwrite", s.nooverwrite);
    config->writeEntry("checkmoved", s.checkmoved);
}

void ksitecopy::writeRcFile()
{
    QString line, groupName, Entry, allSites;
    QStringList::Iterator StartSite, StopSite;
    QFile f(default_rcfile);
    QStringList EntryList;
    QStringList::Iterator it;
    QStringList::Iterator site;

    ReadSiteList = FALSE;
    allSites.sprintf("%s", "-a");
    if (f.open(IO_WriteOnly)) {
	if (d.options.contains(allSites, FALSE)) {
	    StartSite = d.SiteList.begin();
	    StopSite = d.SiteList.end();
	} else {
	    site = d.SiteList.begin();
	    do {
		line = *site;
		if ((line.contains(d.Site, FALSE))) {
		    StartSite = site;
		    break;
		}
		site++;
	    } while (site != d.SiteList.end());
	    StopSite = StartSite;	// default, ausser option = --all 
	}
	site = StartSite;
	do {
	    d.Site = *site;
	    readConfig();	// may not read sitelist here ! 
	    line.sprintf("site ");
	    line.append(d.Site);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("server ");
	    line.append(s.server);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    if (s.port.length()) {
		line.sprintf("port ");
		line.append(s.port);
		line.append("\n");
		f.writeBlock(line, line.length());
	    }
	    if (s.proxy.length()) {
		line.sprintf("Proxy ");
		line.append(s.proxy);
		line.append("\n");
		f.writeBlock(line, line.length());
		if (s.proxyport.length()) {
		    line.sprintf("ProxyPort ");
		    line.append(s.proxyport);
		    line.append("\n");
		    f.writeBlock(line, line.length());
		}
	    }
	    line.sprintf("protocol ");
	    line.append(s.protocol);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("url ");
	    line.append(s.url);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("username ");
	    line.append(s.username);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("password ");
	    line.append(s.password);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("local ");
	    line.append(s.local);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    line.sprintf("remote ");
	    line.append(s.remote);
	    line.append("\n");
	    f.writeBlock(line, line.length());
	    if (s.exclude.length()) {
		EntryList = (QStringList::split(",", s.exclude));
		it = EntryList.begin();
		while (it != EntryList.end()) {
		    Entry = *it;
		    line.sprintf("exclude ");
		    line.append(Entry);
		    line.append("\n");
		    f.writeBlock(line, line.length());
		    it++;
		}
	    }
	    if (s.ignore.length()) {
		EntryList.clear();
		EntryList = (QStringList::split(",", s.ignore));
		it = EntryList.begin();
		while (it != EntryList.end()) {
		    Entry = *it;
		    line.sprintf("ignore ");
		    line.append(Entry);
		    line.append("\n");
		    f.writeBlock(line, line.length());
		    it++;
		}
	    }
	    if (s.ascii.length()) {
		EntryList = (QStringList::split(",", s.ascii));
		it = EntryList.begin();
		while (it != EntryList.end()) {
		    Entry = *it;
		    line.sprintf("ascii ");
		    line.append(Entry);
		    line.append("\n");
		    f.writeBlock(line, line.length());
		    it++;
		}
	    }
	    if (s.symlinks.length()) {
		line.sprintf("symlinks ");
		line.append(s.symlinks);
		line.append("\n");
		f.writeBlock(line, line.length());
	    }
	    if (s.permissions.length()) {
		line.sprintf("permissions ");
		line.append(s.permissions);
		line.append("\n");
		f.writeBlock(line, line.length());
	    }
	    if (s.nodelete) {
		line.sprintf("nodelete \n");
		f.writeBlock(line, line.length());
	    }
	    if (s.nooverwrite) {
		line.sprintf("nooverwrite \n");
		f.writeBlock(line, line.length());
	    }
	    if (s.checkmoved) {
		line.sprintf("checkmoved \n");
		f.writeBlock(line, line.length());
	    }
	    line.sprintf("\n");
	    f.writeBlock(line, line.length());
	    if (site != StopSite)
		site++;
	} while (site != StopSite);
	f.close();
	f.flush();		// 19.04.03 
    } else {
	KMessageBox::sorry(this, default_rcfile, "could not write", FALSE);
    }
    proc.clearArguments();
    proc << "chmod";
    proc << "600";
    proc << default_rcfile;
    if (!proc.start(KProcess::Block, KProcess::AllOutput)) {	// achtung: Block weil chmod fertig sein muss bevor proc wieder zum starten v. sitecopy gebraucht wird 
	KMessageBox::sorry(this,
			   i18n
			   ("could not chmod rcfile - please check your installation !"),
			   i18n("Error"), FALSE);
    }
}

void ksitecopy::cleanupSiteData()
{
    s.Site.truncate(0);
    s.server.truncate(0);
    s.port.truncate(0);
    s.proxy.truncate(0);
    s.proxyport.truncate(0);
    s.protocol.truncate(0);
    s.url.truncate(0);
    s.username.truncate(0);
    s.password.truncate(0);
    s.local.truncate(0);
    s.remote.truncate(0);
    s.exclude.truncate(0);
    s.ignore.truncate(0);
    s.ascii.truncate(0);
    s.permissions.truncate(0);
    s.symlinks.truncate(0);
    s.nodelete = false;
    s.nooverwrite = false;
    s.checkmoved = false;
}

bool ksitecopy::foundExecutable()
{
    KShellProcess process;

    process << "which sitecopy >/dev/null 2>&1";
    if (process.start(KProcess::Block) && process.normalExit()
	&& process.exitStatus() == 0) {
	return true;
    }
    return false;
}

// slot implementations 
void ksitecopy::slotViewToolBar()
{
	// turn Toolbar on or off
    if (!viewToolBar->isChecked()) {
		toolBar("mainToolBar")->hide();
		d.ToolBarVisible = false;
    } else {
		toolBar("mainToolBar")->show();
		d.ToolBarVisible = true;
    }
}

void ksitecopy::slotSiteData()
{
    QString Msg, Sites;

    s.Site = d.Site;
    if (forceReadCfg)
	readConfig();		// Achtung: muss weg, sonst kein update der dialogdaten nach accept() in sitedialogdata ! 01.05.02
    forceReadCfg = false;
    sitedatadlg = new Sitedatadialog(this, "Site Configuration", &s);

    Msg = i18n("Configuration for Site:");
    Msg.append(d.Site);
    sitedatadlg->setCaption(Msg);
    connect(sitedatadlg, SIGNAL(SiteDataChanged()), this,
	    SLOT(slotSiteDataChanged()));
    sitedatadlg->show();
}

void ksitecopy::slotSiteDataChanged()
{
	bool log;

	writeConfig();
    forceReadCfg = true;
	initStatusBar();
    /*
    readConfig();
    d.logging = log;		// restore dialog val, overwritten by readConfig()
    writeConfig();
    forceReadCfg = true;
	initStatusBar();
	*/
}

void ksitecopy::slotAddSite()
{
    QString groupName, Sites, Msg, currentSite, tmpSite;

    currentSite = d.Site;	// moment. site merken
    d.Site.truncate(0);		// erstmal lschen, damit nach addsitedlg test klappt
    addsitedlg = new addSitedialog(this, "New Site", &d);
    connect(addsitedlg, SIGNAL(siteAdded()), this,
	    SLOT(slotSiteAdded()));
    addsitedlg->show();
}

void ksitecopy::slotSiteAdded()
{
    QString groupName, Sites, Msg, currentSite, tmpSite;

	for (QStringList::Iterator it = d.SiteList.begin();
	     it != d.SiteList.end(); it++) {
	    tmpSite = *it;
	    if (tmpSite.contains(d.Site, true) > 0) {
			KMessageBox::sorry(this,
				   i18n
				   ("Site already in List, not added !"),
				   d.Site, FALSE);
		return;
	    }
	}
	s.Site = d.Site;
	if (d.Site.length() > 0) {	// neue site, eintragen in config
		cleanupSiteData();
		config->setGroup("General Options");
		d.SiteList = config->readListEntry("SiteList");
		d.SiteList.append(d.Site);
		config->writeEntry("SiteList", d.SiteList);
		config->writeEntry("Site", d.Site);
		d.mode.sprintf("--help");	// default f. neue site
		d.options.sprintf("%s", "");	// default f. neue site
		groupName.sprintf("Site-");
		groupName.append(d.Site);
		config->setGroup(groupName);
		writeConfig();
		NumSites = d.SiteList.count();
		if (NumSites > 1)
			DelSite->setEnabled(true);
		Start->setEnabled(true);
		slotSiteData();
		initStatusBar();		
	 }
}

void ksitecopy::slotSetSite()
{
    QString Msg, Sites;

    for (QStringList::Iterator it = d.SiteList.begin();
	 it != d.SiteList.end(); it++) {
	Sites.append(*it);
	Sites.append(",");
    }
    dlg = new Sitedialog(this, "Site Options", &d);
    connect(dlg, SIGNAL(siteChanged()), this,
	    SLOT(slotSiteChanged()));
    dlg->show();
}

void ksitecopy::slotSiteChanged()
{
    if (checkSiteCfgData(d.Site, &s)) {
		//	writeConfig();
		readConfig();
		Start->setEnabled(true);
    } else {
		Start->setEnabled(false);
    }
	initStatusBar();
}

void ksitecopy::slotDelSite()
{
	if (NumSites > 1){
		delsitedlg = new delSitedialog(this, i18n("Delete Site"), &d);
		connect(delsitedlg, SIGNAL(siteDeleted()), this,
			SLOT(slotSiteDeleted()));
		delsitedlg->show();
	}	else	{
		KMessageBox::sorry(this, i18n
				   ("last Site cannot be deleted !"),
				   d.Site, FALSE);

	}
}

void ksitecopy::slotSiteDeleted()
{
    QString groupName, tmpSite, Msg;
    QStringList::Iterator it;
    int Del;
    
	for (it = d.SiteList.begin(); it != d.SiteList.end(); it++) {
	    tmpSite = *it;
	    if (strstr(d.Site, tmpSite)) {
			it = d.SiteList.remove(it);
			NumSites--;
		}
	}
	it = d.SiteList.begin();
	d.Site = *it;
	//	readConfig();
	writeConfig();
	if (NumSites < 2)
	    DelSite->setEnabled(false);
	initStatusBar();
}

void ksitecopy::slotExit()
{
    s.Site = d.Site;
    writeConfig();
    close();
}

void ksitecopy::slotStart()
{
    readConfig (); 
    writeRcFile();		// 
    proc.clearArguments();
    proc << "sitecopy";
    if (strlen(d.options))
	proc << d.options;
    if (strlen(d.mode))
	proc << d.mode;
    if (strlen(d.Site))
	proc << d.Site;
    else {
	KMessageBox::sorry(this, i18n("no Site specified !"),
			   i18n("Error"), FALSE);
	return;
    }
    stdOutWin->clear();		// setText(""); 
    if (!proc.start(KProcess::NotifyOnExit, KProcess::AllOutput)) {
	KMessageBox::sorry(this,
			   i18n
			   ("could not start sitecopy - please check your installation !"),
			   i18n("Error"), FALSE);
	exit(0);
    }
}

void ksitecopy::slotStop()
{
    if (!proc.isRunning())
	return;
    proc.kill();
    if (d.logging) {
	logString += ">> " + i18n("Process killed") + "\n\n";
    }
}

void ksitecopy::slotFinishCopy()
{
    QString initDir, filter;
    QString fileSave;

    if (d.logging) {
	filter.sprintf("*.log");
	initDir.sprintf("%s", getenv("HOME"));
	fileSave =
	    KFileDialog::getSaveFileName(initDir, filter, 0,
					 i18n("Save log file"));
	if (!fileSave.isEmpty()) {
	    QFile file(fileSave);
	    if (file.open(IO_WriteOnly)) {
		QTextStream stream(&file);
		stream << logString;
		file.close();
	    }
	}
    }
    logString.sprintf("%s", "");	// flush logString 
}

void ksitecopy::manpage()
{
/* achtung: khtml geht nur mit LDADD ... $LIB_KHTML in Makefile, weiss noch nicht wie man diese zeile 
automatisch aus configure erzeugt ! - erl. 3.1.: eintrag in ksitecopy.kdevprj */
    QHBox *new_window = new QHBox();
    new_window->setMinimumSize(800, 600);
    khtmlpart = new KHTMLPart(new_window);
    khtmlpart->begin();
    khtmlpart->openURL("man:sitecopy");
    khtmlpart->end();
    khtmlpart->view();
    new_window->show();
}
