/***************************************************************************
$Id$
                             -------------------
    begin                : Mon Dec 24 09:05:18 CET 2001
    copyright            : (C) 2001 by Werner Joss
    email                : werner@hoernerfranzracing.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ksitecopy_H
#define ksitecopy_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <keditcl.h>
#include <kprocess.h>
#include <kaction.h>
#include <kstdaction.h>
#include <klineeditdlg.h>
#include <kpopupmenu.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <khtmlview.h>
#include <khtml_part.h>
#include <kstatusbar.h>

#include <qlistbox.h>
#include <qtextview.h>
#include <qtextstream.h>
#include <qvbox.h>
#include <qfile.h>
#include "sitedialog.h"
#include "sitedatadialog.h"
#include "addsitedialog.h"
#include "delsitedialog.h"

#define ID_STATUS_MSG 1
#define verbose false

class KHTMLPart;

class ksitecopy:public KMainWindow {
  Q_OBJECT public:
    ksitecopy();
    void closeEvent(QCloseEvent *);

	
	protected:

    public slots:
	void slotViewToolBar();
	void slotStart();
	void slotStop();
	void slotSetSite();
	void slotSiteData();
	void slotExit();
	void getOutput(KProcess *, char *, int);
	void slotFinishCopy();
	void slotAddSite();
	void slotDelSite();
	void manpage ();
	void slotSiteChanged();
	void slotSiteDataChanged();
	void slotSiteAdded();
	void slotSiteDeleted();


	private:
	bool foundExecutable();
	void doInitialStartupChecks();
	void controlSettings(bool enabled);
	void writeConfig();
	bool readConfig();
	int readRcFile();
	void writeRcFile();
	bool backupRcFile();
	void initStatusBar();
	void setupMenuBar();
	void init();
	void	cleanupSiteData();

	bool ReadSiteList, forceReadCfg;
	int NumSites;
	QString default_rcfile, logString;
	addSitedialog* addsitedlg;
	delSitedialog* delsitedlg;
	Sitedialog* dlg;
	Sitedatadialog* sitedatadlg;
	Kname::RunDataStruct d; 	// SiteList,Site,mode,options...
	Kname::SiteDataStruct s; 	//
	KHTMLPart *khtmlpart;
	KConfig *config;
	KToggleAction* viewToolBar;
	KAction* ManPage;
	KAction* Options;
	KAction* Site;
	KAction* AddSite;
	KAction* DelSite;
	KAction* SiteData;
	KAction* OpMode;
	KAction* Start;
	KAction* Stop;
	KAction* fileEditCfg;
	KEdit * stdOutWin;
	KProcess proc;
};
#endif				// ksitecopy_H
