/***************************************************************************
$Id$
                             -------------------
    begin                : Thu Dec 27 2001
    copyright            : (C) 2001 by josswern
    email                : werner@hoernerfranzracing.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "parsecfg.h"
#include <kmessagebox.h>
#include <klocale.h>

int 	checkSiteCfgData(const QString& Site,  Kname::SiteDataStruct* SiteData)	{
	bool ok = true;
	if (SiteData->server.length() < 1)	{
		KMessageBox::sorry(0,i18n("Server name invalid"),"",FALSE);
		ok = false;
	}
	if (SiteData->url.length() < 5)	{
		KMessageBox::sorry(0,i18n("Url invalid"),"",FALSE);
		ok = false;
	}
	if (SiteData->username.length() < 1)	{
		KMessageBox::sorry(0,i18n("Username invalid"),"",FALSE);
		ok = false;
	}
	if (SiteData->password.length() < 1)	{
		KMessageBox::sorry(0,i18n("Password invalid"),"",FALSE);
		ok = false;
	}
	if (SiteData->local.length() < 1)	{
		KMessageBox::sorry(0,i18n("Local Directory invalid"),"",FALSE);
		ok = false;
	}
	if (SiteData->remote.length() < 1)	{
		KMessageBox::sorry(0,i18n("Remote Directory invalid"),"",FALSE);
		ok = false;
	}
		
	return ok;
}

void 	readSiteCfgData(const QString& default_rcfile, const QString& Site,  Kname::SiteDataStruct* SiteData)	{
	QFile f( default_rcfile );
	QString line, qline, headerline, token;
	bool Found = false;

	token.sprintf("%s","site");
	if ( f.open( IO_ReadOnly ) )	{
		while (!f.atEnd() && !Found)	{
			f.readLine(qline, 80);
			scan_header(qline.lower(), token, headerline);
			if (headerline.contains(Site,true))		// gew. site gefunden, ab hier sitedata lesen
				Found = true;
		}
		while (!f.atEnd())	{
			f.readLine(qline, 80);
			token.sprintf("%s","site");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				break;	// naechste site gefunden -> abbruch
			token.sprintf("%s","server");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->server = headerline;
			token.sprintf("%s","url");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->url = headerline;
			token.sprintf("%s","username");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->username = headerline;
			token.sprintf("%s","password");
			scan_header(qline, token, headerline);	// kein lower(), da pwd case sensitiv !
			if (headerline.length() > 0)	
				SiteData->password = headerline;
			token.sprintf("%s","local");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->local = headerline;
			token.sprintf("%s","remote");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->remote = headerline;
			token.sprintf("%s","exclude");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	{
				headerline.append(",");
				SiteData->exclude.append(headerline);
			}
			token.sprintf("%s","ignore");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	{
				headerline.append(",");
				SiteData->ignore.append(headerline);
			}
			token.sprintf("%s","ascii");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	{
				headerline.append(",");
				SiteData->ascii.append(headerline);
			}
			token.sprintf("%s","permissions");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->permissions = headerline;
			token.sprintf("%s","symlinks");
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->symlinks = headerline;
			token.sprintf("%s","nodele");	// anfang von 'nodelete' -> scan_header findet den 'rest'
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->nodelete = true;
			token.sprintf("%s","nooverwri");	// anfang von 'nooverwrite' -> scan_header findet den 'rest'
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->nooverwrite = true;
			token.sprintf("%s","checkmov");	// anfang von 'checkmoved' -> scan_header findet den 'rest'
			scan_header(qline.lower(), token, headerline);
			if (headerline.length() > 0)	
				SiteData->checkmoved = true;

		}
		f.close();
	}
	return;
}

int readSiteList(const QString& default_rcfile, QStringList& SiteList)	{
// Sites ist die kommaseparierte liste aller in rcfile gefundenen Sites -
// zeilen die mit #site beginnen werden ignoriert !

	QFile f( default_rcfile );

	QString line, Site;
	QString qline, item, headerline,Sites;
	int NumSites = 0;
	
	item.sprintf("site");
	Sites.sprintf("%s", "");
	if ( f.open( IO_ReadOnly ) )	{
		while (!f.atEnd())	{
			f.readLine(qline, 80);
			//	KMessageBox::information(0,qline);
			scan_header(qline.lower(), item, headerline);
			Site = headerline;
			if (Site.length()>0)		{
				line = Sites;
				NumSites++;
				if (strlen(line))	{
					Sites = line;	Sites.append(",");	 Sites.append(Site);
				}	else
					Sites = Site;
			}
		}
		f.close();
		SiteList.clear();	//	flush SiteList first
		SiteList = (QStringList::split( ",", Sites ));
	}
	return NumSites;	             	
}

void scan_header (const QString& header ,const QString& item ,QString& headerline)
{
	QString searchstring;
 	
	/* get e.g. the "From:" line, starting with cr,lf,"From:" and ending
           with a carriage return */

	 //	searchstring.sprintf ("\r\n%s " , (const char*)item) ;
	searchstring.sprintf ("%s " , (const char*)item) ;

	int pos1 = header.find (searchstring, 0, FALSE);
	int pos2 = header.find ('\n', pos1+2);
	// int pos2 = header.find ('\r', pos1);

	//   if (pos1 >= 0)
   if (pos1 == 0)		// nur ok, wenn item ganz am anfang...
	{
		headerline = header.mid (pos1 + searchstring.length (), pos2 - pos1 - searchstring.length ());
		//	headerline = header.left(searchstring.length());
	}
	else
	{
		/* there was no headerline for the item */

		headerline = "";
	}
}
