/***************************************************************************
$Id: sitedatadialog.cpp,v 1.5 2004/01/03 12:41:09 josswern Exp $
                             -------------------
    begin                : Thu Jan 3 2002
    copyright            : (C) 2002 by josswern
    email                : werner@hoernerfranzracing.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmessagebox.h>
#include <kurlrequester.h>

#include "sitedatadialog.h"

Sitedatadialog::Sitedatadialog(QWidget * parent, const char *name,
			       Kname::SiteDataStruct *
			       SiteData):siteDataDlg(parent, name, true),
s(SiteData)
// wichtig: modal = true in siteDataDlg !
{
    QStringList permissions, symlinks;
    QString label, msg;
    int i, index = 0;

    this->ServerEdit->setText(s->server);
    this->PortEdit->setText(s->port);
    this->ProxyEdit->setText(s->proxy);
    this->ProxyPortEdit->setText(s->proxyport);
    this->ProtocolComboBox->insertItem("ftp");
    this->ProtocolComboBox->insertItem("http");
    if (s->protocol.length() > 0) {
	for (i = 0; i < this->ProtocolComboBox->count(); i++) {	// aktuellen Wert in combobox suchen
	    label = this->ProtocolComboBox->text(i);
	    if (strstr(s->protocol, label))
		index = i;
	}
    }
    this->ProtocolComboBox->setCurrentItem(index);	// aktuellen Wert als default setzen
    this->LocalEdit->setMode(2);	// 2=directory
    this->UrlEdit->setText(s->url);
    this->UserEdit->setText(s->username);
    this->PasswdEdit->setText(s->password);
    this->LocalEdit->setURL(s->local);
    this->RemoteEdit->setText(s->remote);
    this->ExcludeEdit->setText(s->exclude);
    this->IgnoreEdit->setText(s->ignore);
    this->AsciiEdit->setText(s->ascii);

    label.sprintf("ignore,exec,all");
    permissions = (QStringList::split(",", label));
    for (QStringList::Iterator it = permissions.begin();
	 it != permissions.end(); it++) {
	label = *it;
	this->PermissionsComboBox->insertItem(label);
    }
    if (s->permissions.length() > 0) {
	for (i = 0; i < this->PermissionsComboBox->count(); i++) {	// aktuellen Wert in combobox suchen
	    label = this->PermissionsComboBox->text(i);
	    if (strstr(s->permissions, label))
		index = i;
	}
	this->PermissionsComboBox->setCurrentItem(index);	// aktuellen Wert als default setzen
    }
    label.sprintf("ignore,follow,maintain");
    symlinks = (QStringList::split(",", label));
    for (QStringList::Iterator it = symlinks.begin(); it != symlinks.end();
	 it++) {
	label = *it;
	this->SymlinksComboBox->insertItem(label);
    }
    if (s->symlinks.length() > 0) {
	for (i = 0; i < this->SymlinksComboBox->count(); i++) {	// aktuellen Wert in combobox suchen
	    label = this->SymlinksComboBox->text(i);
	    if (strstr(s->symlinks, label))
		index = i;
	}
	this->SymlinksComboBox->setCurrentItem(index);	// aktuellen Wert als default setzen
    }
    this->NodeleteCheckBox->setChecked(s->nodelete);
    this->CheckmovedCeckBox->setChecked(s->checkmoved);
    this->NooverwriteCheckBox->setChecked(s->nooverwrite);
}

Sitedatadialog::~Sitedatadialog()
{
}

void Sitedatadialog::okButtonPressed()
{
    QString msg;
    s->server = this->ServerEdit->text();
    s->port = this->PortEdit->text();
    s->proxy = this->ProxyEdit->text();
    s->proxyport = this->ProxyPortEdit->text();
    s->protocol = this->ProtocolComboBox->currentText();
    s->url = this->UrlEdit->text();
    s->username = this->UserEdit->text();
    s->password = this->PasswdEdit->text();
    s->local = this->LocalEdit->url();
    s->remote = this->RemoteEdit->text();
    s->exclude = this->ExcludeEdit->text();
    s->ignore = this->IgnoreEdit->text();
    s->ascii = this->AsciiEdit->text();
    s->permissions = this->PermissionsComboBox->currentText();
    s->symlinks = this->SymlinksComboBox->currentText();
    s->nodelete = this->NodeleteCheckBox->isChecked();
    s->checkmoved = this->CheckmovedCeckBox->isChecked();
    s->nooverwrite = this->NooverwriteCheckBox->isChecked();
    emit SiteDataChanged();
	  accept();
}
