/***************************************************************************
$Id: sitedialog.cpp,v 1.5 2003/04/21 16:19:58 josswern Exp $
                             -------------------
    begin                : Thu Jan 3 2002
    copyright            : (C) 2002 by josswern
    email                : werner@hoernerfranzracing.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmessagebox.h>

#include "sitedialog.h"

Sitedialog::Sitedialog(QWidget *parent, const char *name, Kname::RunDataStruct* RunData):
	siteDlg(parent, name, true), d(RunData)
// wichtig: modal = true in siteDlg !
{  QStringList modelist;

	int i, index;
	QString tmpSite, tmpmode, modes;
	modes.sprintf("--list,--flatlist,--update,--fetch,--synchronise,--initialize,--catchup,--view,--help,--version");
	modelist = (QStringList::split( ",", modes ));
	for (QStringList::Iterator it = d->SiteList.begin(); it != d->SiteList.end(); it++)	{
		tmpSite = *it;
		this->SiteComboBox->insertItem(tmpSite);
	}
	for (i=0;i<this->SiteComboBox->count();i++)	{	// aktuellen Site in combobox suchen
		tmpSite = this->SiteComboBox->text(i);		
		if (strstr(d->Site, tmpSite)) index = i;
	}
	this->SiteComboBox->setCurrentItem(index);	// aktuellen Site als default setzen
	for (QStringList::Iterator it = modelist.begin(); it != modelist.end(); it++)	{
		tmpmode = *it;
		this->ModeComboBox->insertItem(tmpmode);
	}
	for (i=0;i<this->ModeComboBox->count();i++)	{	// aktuellen mode in combobox suchen
		tmpmode = this->ModeComboBox->text(i);		
		if (strstr(d->mode, tmpmode)) index = i;
	}
	this->ModeComboBox->setCurrentItem(index);	// aktuellen mode als default setzen

	this->EditOptions->setText(d->options); 	// aktuelle options setzten
	this->LogCheckBox->setChecked(d->logging);	// logging true od false

}

Sitedialog::~Sitedialog()
{
}


void Sitedialog::okButtonPressed()
{
	d->Site = this->SiteComboBox->currentText();
	d->mode = this->ModeComboBox->currentText();
	d->options = this->EditOptions->text();
	d->logging = this->LogCheckBox->isChecked();
	//	KMessageBox::information(this,d->Site,"selected Site: ",NULL,FALSE);
	//	s = new ksitecopy::siteChanged();
	emit siteChanged();
	accept(); 	// damit gehts raus...

}
