/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "plaintextplugin.h"
#include <kgenericfactory.h>

#ifndef NOPTIMIZE
#include <qcstring.h>
#endif

#include <qfile.h>
#include <qregexp.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qregexp.h>

#include <kurl.h>
#include <kapplication.h>
#include <kurlrequester.h>
#include <kfiledialog.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif

K_EXPORT_COMPONENT_FACTORY( ktranslator_plaintext,
                            KGenericFactory<PlainTextPlugin>( "ktranslator_plaintext" ) )

PlainTextPlugin::PlainTextPlugin( QObject *parent, const char*, const QStringList &args )
            : KTranslator::DictionaryPlugin(parent, "PlainText" )
{
   KLocale::setMainCatalogue("ktranslator");
   QString filename = args[0];
   dictName = args[1];
   if( filename.isEmpty() )
   {
     setOk( false );
     return;
   }
   dictFile = new QFile( filename );
   if( !QFile::exists( filename ) )
   {
     setOk( false );
     return;
   }
#ifndef NOPTIMIZE
   fileTime = 0;
   loadDictionary();
#else
   if( !dictFile->open( IO_ReadOnly ) )
   {
     setOk( false );
     setEnabled( false );
     return;
   }
   dictFile->close();
#endif
   setOk( true );
   setEnabled( true );
   m_tooltip = i18n( "PlainText Dictionary\nWords: %1" ).arg( size() );
}


QString PlainTextPlugin::search( const QString &word )
{
  #ifndef NDEBUG

  kdDebug() << "PlainText Plugin search()" << endl;

  #endif

#ifndef NOPTIMIZE
  struct stat statbuf;
  if ( ::stat( QFile::encodeName( dictFile->name() ), &statbuf ) == 0 )
  {
    if ( fileTime != statbuf.st_mtime )
    loadDictionary();
  }


  QString result = "<dicName>" + dictName + "</dicName>";
  QString definition;
  QString headword;
  QString line;
  int pos;

  Dictionary::ConstIterator it = dic.find( word );
  if( it != dic.constEnd() )
  {
    long wordOffset = it.data();
    if( !dictFile->open( IO_ReadOnly ) )
    {
      result += "<font color=#000000>" + i18n( "Word not found<br>Error in dictionary" ) + "</font>";
      return result;
    }
    dictFile->at( wordOffset );
    dictFile->readLine( line, 1024 );
    dictFile->close();
    line = QString::fromUtf8( line.local8Bit() );

    // add the headword
    headword = line.section( '\t', 0, 0 );
    pos = headword.find( "|" );
    if( pos != -1 ) headword = headword.replace( '|', " ou " );
    result += "<headword>" + headword + "</headword>";

          // adiciona as flexes
          /*result += "<br><font color=" + Config().m_corFlexoes + ">";
          if( !plural.isEmpty() )
          {
            result += "plural: " + plural;
            if( !plural2.isEmpty() ) result += " or " + plural2 + "<br>";
            else result += "<br>";
          }
          if( !terceiraPessoa.isEmpty() ) result += "3rd person" + terceiraPessoa + "<br>";
          if( !passado.isEmpty() ) result += "past simple" + passado + "<br>";
          if( !participioPassado.isEmpty() ) result += "past participle" + participioPassado + "<br>";
          if( !gerundio.isEmpty() ) result += "gerund: " + gerundio + "<br>";
          result += "</font>";*/

    // add the definition
    definition = line.section( '\t', 1, 1 );
    definition.replace( QRegExp( "[(](.{0,4})[.][)]" ), "<pos>\\1</pos>" );
    definition.replace( ";", "<br>" );
    definition.replace( QRegExp( "\\{([^\\}]*)\\}" ), "<link>\\1</link>" );
    result += "<definition>" + definition + "</definition>";
    return result;
  }

  result += "<font color=#000000>" + i18n( "Word not found" ) + "</font>";
  //result = "";
  return result;

#else

  QString result = "<dicName>" + dictName + "</dicName>";
  QString definition;
  QString headword;
  bool found = false;

  if( !dictFile->open( IO_ReadOnly ) )
  {
    result += "<font color=#000000>" + i18n( "Word not found<br>Error in dictionary" ) + "</font>";
    return result;
  }
  QTextStream textStream( dictFile );
  QString line;
  textStream.readLine(); // ignores the first line, because this is the name of dictionary
  //int count = lista.count();
  while( !textStream.atEnd() )
  {
    line = QString::fromUtf8( textStream.readLine().local8Bit() );
    if( line[ 0 ] == '#' ) continue; // comentary
    headword = line.section( '\t', 0, 0 ).remove( "." ).lower();
    if( !found )
    {
      /*while( headword.find( "|" ) != -1 )
      {
        headword = headword.section( "|", 1 );
      }*/
      /*if( headword.find( word ) == 0 )
        // limitar para no abarrotar a janela
        if( lista.count() < 5 ) lista.append( headword );
        else if( lista.last().compare( "**" ) != 0 ) lista.append( QCString( "**" ) );*/
      /*if( count < 5 && headword.find( word ) == 0 )
      {  // limitar para no abarrotar a janela
        lista.append( headword );
        count++;
        if( count == 5 ) lista.append( QCString( "*" ) );
      }
    }else
    {*/
      while( headword.find( "|" ) != -1 )
      {
        if( headword.section( "|", 0, 0 ) == word ) found = true;
        headword = headword.section( "|", 1 );
      }
      if( headword == word ) found = true;

      if( found )
      {
        // add the headword
        headword = line.section( '\t', 0, 0 );
        if( headword.find( "|" ) ) headword = headword.replace( "|", " ou " );
        result += "<headword>" + headword + "</headword>";

        // adiciona as flexes
        /*result += "<font color=" + Config().m_corFlexoes + ">";
        if( !plural.isEmpty() )
        {
          result += "plural: " + plural;
          if( !plural2.isEmpty() ) result += " ou " + plural2 + "<br>";
          else result += "<br>";
        }
        if( !terceiraPessoa.isEmpty() ) result += "terceira pessoa: " + terceiraPessoa + "<br>";
        if( !passado.isEmpty() ) result += "passado: " + passado + "<br>";
        if( !participioPassado.isEmpty() ) result += "particpio passado: " + participioPassado + "<br>";
        if( !gerundio.isEmpty() ) result += "gerndio: " + gerundio + "<br>";
        result += "</font>";*/

        // add the definition
        definition = line.section( '\t', 1, 1 );
        definition.replace( QRegExp( "[(](.{0,4})[.][)]" ), "<pos>\\1</pos>" );
        definition.replace( ";", "<br>" );
        definition.replace( QRegExp( "\\{([^\\}]*)\\}" ), "<link>\\1</link>" );
        result += "<definition>" + definition + "</definition>";
      }
    }
  }
  if( found )
  {
    dictFile->close();
    return result;
  }

  result += "<font color=#000000>" + i18n( "Word not found" ) + "</font>";
  dictFile->close();
  return result;
#endif
}


QWidget *PlainTextPlugin::confPage()
{
  return new QLabel( "This plugin has no configurations", 0 );
}


void PlainTextPlugin::applyConf( QWidget */*page*/ )
{
  return;
}

#ifndef NOPTIMIZE
/*!
    \fn PlainTextPlugin::loadDictionary()
 */
void PlainTextPlugin::loadDictionary()
{
  QString headword;
  long offset;
  dic.clear();
  if( !dictFile->open( IO_ReadOnly ) ) return;
  QTextStream text( dictFile );
  QString line;
  offset = dictFile->at();
  while( !text.atEnd() )
  {
    line = QString::fromUtf8( text.readLine().local8Bit() );
    if( line[ 0 ] == '#' )
    {
      line = text.readLine();
      continue; // comentary
    }
    headword = line.section( '\t', 0, 0 ).lower().remove(".");
    if( headword.find("|") != -1 )
    {
      dic.insert( headword.section( "|", 0, 0 ), offset );
      headword = headword.section( "|", 1 );
    }
    dic.insert( headword, offset );
    offset = dictFile->at();
  }
  dictFile->close();
  struct stat statbuf;
  if ( ::stat( QFile::encodeName( dictFile->name() ), &statbuf ) == 0 )
  {
    fileTime = statbuf.st_mtime;
  }
}
#endif


int PlainTextPlugin::size()
{
#ifndef NOPTIMIZE
  return dic.size();
#else
  int size = 0;
  dictFile->open( IO_ReadOnly );
  QTextStream text( dictFile );
  while( !text.atEnd() )
  {
    text.readLine();
    size++;
  }
  dictFile->close();
  return size;
#endif
}
