#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>

#include "input.h"
#include "cfg.h"
#include "larepubblica.h"

extern Configurazione config;

static char *point_arg(char *search_string)
{
    search_string = strchr(search_string, '=');

if (search_string)
   search_string++;

    if (*search_string == '\"') {
	search_string++;
        if (strchr(search_string, '\"'))
	  *strchr(search_string, '\"') = '\0';
    } else {
	char *p = strchr(search_string, '\n');
	if (p) {
	  *p-- = '\0';
	if (*p == '\r')
	    *p = '\0';
	 }
    }
    return search_string;
}

static char *assign(char *value)
{
    char *config = xmalloc(strlen(value));
    strcpy(config, point_arg(value));

    return config;
}

static void append(struct curl_slist **slist, char *p, int len)
{
    char *n = (char *) xstrndup(p, len);
    *slist = curl_slist_append(*slist, n);
    free(n);
}

static void
assign_list(struct curl_slist **config, char *buffer, size_t len)
{
    char *list = assign(buffer + len);
    char *s = list;

    if (!*s)
      return;

    do {
	while (*s == ' ')
	    *s++;

	char *c = strchr(s, ',');
	if (c) {
	    append(config, s, c - s);
	    s = s + (c - s);
	} else {
	    char *c = strchr(s, 0);
	    if (c) {
		append(config, s, c - s);
		s = s + (c - s);
	    }
	}
    }
    while (*s++);

    free(list);
}

void load_config()
{
    const char *keyword[] =
	{ "Username", "Password", "Salva_In", "SalvaIn", "EdizioniLocali",
	"FrecceScorrimento",
	0
    };

    const char *frecce_k[] = { "grandi", "doppie", 0};

    char *temp;

    enum { USERNAME, PASSWORD, SALVA_IN, SALVA_IN2, EDIZIONI_LOCALI, FRECCE,
	key_FINE
    };

    FILE *cf;
    char *config_path;
#ifndef WIN32
    config_path = home_dir();

    if (!config_path)
	error(1, "Non individuata l'homedir");

    config_path =
	xrealloc(config_path,
		 strlen(config_path) + strlen(CONFIG_FILE) + 2);
    strcat(config_path, "/" CONFIG_FILE);
#else
    config_path = CONFIG_FILE;
#endif
    cf = fopen(config_path, "r");

    if (!cf && config.tipo_accesso > CHIAVE_TELEFONICA) {
	error(1,
	      "Non in grado di leggere il file di configurazione %s: %s",
	      config_path, strerror(errno));
    }
#ifndef WIN32
    free(config_path);
#endif

/* Prelevamento dei dati */

    if (cf) {
	char buffer[4096];

	while (fgets(buffer, 4096, cf)) {
	    if (*buffer == '#' || *buffer == ' ' || *buffer == '\n'
		|| *buffer == '\r')
		continue;

	    int k;
	    for (k = 0; k < key_FINE; k++) {
		int len = strlen(keyword[k]);
		if (curl_strnequal(keyword[k], buffer, len)) {
		    switch (k) {
		    case USERNAME:
			config.username = assign(buffer + len);
			break;
		    case PASSWORD:
			config.password = assign(buffer + len);
			break;
		    case SALVA_IN:
		    case SALVA_IN2:
			config.savepath = assign(buffer + len);
			if (*config.savepath && config.savepath) {
			    create_dirs(config.savepath);
			    if (chdir(config.savepath))
				error(1,
				      "Non possibile spostarsi alla directory richiesta per il salvataggio dei dati (%s) - %s",
				      config.savepath, strerror(errno));
			}
			break;
		    case EDIZIONI_LOCALI:
			assign_list(&config.ediz_local_selection, buffer,
				    len);
                        break;
                    case FRECCE:
                         temp = assign(buffer + len);
                         if (!strcmp(temp, frecce_k[0]))
                         config.dim_frecce = 1;
                         if (!strcmp(temp, frecce_k[1]))
                         config.dim_frecce = 1;
                         free(temp);
                        break;
		    default:
			break;
		    }
		    break;
		}
	    }
	}
	fclose(cf);
    }
}

void unload_config()
{
    free(config.username);
    free(config.password);
    ck_close(&config.ediz_local_selection);
}
